/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma;

import eus.ixa.ixa.pipe.lemma.LemmaSample;
import eus.ixa.ixa.pipe.lemma.Lemmatizer;
import eus.ixa.ixa.pipe.lemma.LemmatizerEvaluationMonitor;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.Mean;

public class LemmatizerEvaluator
extends Evaluator<LemmaSample> {
    private Lemmatizer lemmatizer;
    private Mean wordAccuracy = new Mean();

    public LemmatizerEvaluator(Lemmatizer aLemmatizer, LemmatizerEvaluationMonitor ... listeners) {
        super(listeners);
        this.lemmatizer = aLemmatizer;
    }

    @Override
    protected LemmaSample processSample(LemmaSample reference) {
        String[] predictedLemmas = this.lemmatizer.lemmatize(reference.getTokens(), reference.getTags());
        String[] referenceLemmas = reference.getLemmas();
        for (int i = 0; i < referenceLemmas.length; ++i) {
            if (referenceLemmas[i].equals(predictedLemmas[i])) {
                this.wordAccuracy.add(1.0);
                continue;
            }
            this.wordAccuracy.add(0.0);
        }
        return new LemmaSample(reference.getTokens(), reference.getTags(), predictedLemmas);
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }

    public String toString() {
        return "Accuracy:" + this.wordAccuracy.mean() + " Number of Samples: " + this.wordAccuracy.count();
    }
}

