/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma;

import eus.ixa.ixa.pipe.lemma.LemmatizerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;

public class LemmatizerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "StatisticalLemmatizer";
    private static final String LEMMATIZER_MODEL_ENTRY_NAME = "lemmatizer.model";

    public LemmatizerModel(String languageCode, SequenceClassificationModel<String> lemmatizerModel, Map<String, String> manifestInfoEntries, LemmatizerFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, factory);
        this.artifactMap.put(LEMMATIZER_MODEL_ENTRY_NAME, lemmatizerModel);
        this.checkArtifactMap();
    }

    public LemmatizerModel(String languageCode, MaxentModel lemmatizerModel, Map<String, String> manifestInfoEntries, LemmatizerFactory factory) {
        this(languageCode, lemmatizerModel, 3, manifestInfoEntries, factory);
    }

    public LemmatizerModel(String languageCode, MaxentModel lemmatizerModel, int beamSize, Map<String, String> manifestInfoEntries, LemmatizerFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, factory);
        this.artifactMap.put(LEMMATIZER_MODEL_ENTRY_NAME, lemmatizerModel);
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.put("BeamSize", Integer.toString(beamSize));
        this.checkArtifactMap();
    }

    public LemmatizerModel(String languageCode, MaxentModel lemmatizerModel, LemmatizerFactory factory) {
        this(languageCode, lemmatizerModel, null, factory);
    }

    public LemmatizerModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public LemmatizerModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public LemmatizerModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(LEMMATIZER_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Lemmatizer model is incomplete!");
        }
    }

    public SequenceClassificationModel<String> getLemmatizerSequenceModel() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        if (this.artifactMap.get(LEMMATIZER_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            String beamSizeString = manifest.getProperty("BeamSize");
            int beamSize = 3;
            if (beamSizeString != null) {
                beamSize = Integer.parseInt(beamSizeString);
            }
            return new BeamSearch<String>(beamSize, (MaxentModel)this.artifactMap.get(LEMMATIZER_MODEL_ENTRY_NAME));
        }
        if (this.artifactMap.get(LEMMATIZER_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel) {
            return (SequenceClassificationModel)this.artifactMap.get(LEMMATIZER_MODEL_ENTRY_NAME);
        }
        return null;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return LemmatizerFactory.class;
    }

    public LemmatizerFactory getFactory() {
        return (LemmatizerFactory)this.toolFactory;
    }
}

