/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import eus.ixa.ixa.pipe.lemma.LemmatizerME;
import eus.ixa.ixa.pipe.lemma.LemmatizerModel;
import eus.ixa.ixa.pipe.pos.Morpheme;
import eus.ixa.ixa.pipe.pos.MorphoFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class StatisticalLemmatizer {
    private final LemmatizerME lemmatizer;
    private static ConcurrentHashMap<String, LemmatizerModel> lemmaModels = new ConcurrentHashMap();
    private MorphoFactory morphoFactory;

    public StatisticalLemmatizer(Properties props) {
        String lang = props.getProperty("language");
        String model = props.getProperty("lemmatizerModel");
        LemmatizerModel lemmatizerModel = this.loadModel(lang, model);
        this.lemmatizer = new LemmatizerME(lemmatizerModel);
    }

    public StatisticalLemmatizer(Properties props, MorphoFactory aMorphoFactory) {
        String lang = props.getProperty("language");
        String model = props.getProperty("lemmatizerModel");
        LemmatizerModel posModel = this.loadModel(lang, model);
        this.lemmatizer = new LemmatizerME(posModel);
        this.morphoFactory = aMorphoFactory;
    }

    public final List<Morpheme> getMorphemes(String[] tokens, String[] posTags) {
        List<String> lemmas = this.lemmatize(tokens, posTags);
        List<Morpheme> morphemes = this.getMorphemesFromStrings(tokens, posTags, lemmas);
        return morphemes;
    }

    public List<String> lemmatize(String[] tokens, String[] posTags) {
        String[] annotatedLemmas = this.lemmatizer.lemmatize(tokens, posTags);
        String[] decodedLemmas = this.lemmatizer.decodeLemmas(tokens, annotatedLemmas);
        ArrayList<String> lemmas = new ArrayList<String>(Arrays.asList(decodedLemmas));
        return lemmas;
    }

    public final List<Morpheme> getMorphemesFromStrings(String[] tokens, String[] posTags, List<String> lemmas) {
        ArrayList<Morpheme> morphemes = new ArrayList<Morpheme>();
        for (int i = 0; i < posTags.length; ++i) {
            String word = tokens[i];
            String tag = posTags[i];
            String lemma = lemmas.get(i);
            Morpheme morpheme = this.morphoFactory.createMorpheme(word, tag, lemma);
            morphemes.add(morpheme);
        }
        return morphemes;
    }

    public ListMultimap<String, String> getMultipleLemmas(String[] tokens, String[][] posTags) {
        ArrayListMultimap<String, String> morphMap = ArrayListMultimap.create();
        for (int i = 0; i < posTags.length; ++i) {
            String[] rowLemmas = this.lemmatizer.lemmatize(tokens, posTags[i]);
            String[] decodedLemmas = this.lemmatizer.decodeLemmas(tokens, rowLemmas);
            for (int j = 0; j < decodedLemmas.length; ++j) {
                morphMap.put(tokens[j], posTags[i][j] + "#" + decodedLemmas[j]);
            }
        }
        return morphMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LemmatizerModel loadModel(String lang, String model) {
        long lStartTime = new Date().getTime();
        try {
            ConcurrentHashMap<String, LemmatizerModel> concurrentHashMap = lemmaModels;
            synchronized (concurrentHashMap) {
                if (!lemmaModels.containsKey(lang)) {
                    lemmaModels.put(lang, new LemmatizerModel(new FileInputStream(model)));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long lEndTime = new Date().getTime();
        long difference = lEndTime - lStartTime;
        System.err.println("ixa-pipe-lemma model loaded in: " + difference + " miliseconds ... [DONE]");
        return lemmaModels.get(lang);
    }
}

