/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.nerc.Annotate;
import eus.ixa.ixa.pipe.nerc.NameFinderServer;
import eus.ixa.ixa.pipe.nerc.OpinionTargetExtractor;
import eus.ixa.ixa.pipe.nerc.TargetExtractorServer;
import eus.ixa.ixa.pipe.nerc.eval.CrossValidator;
import eus.ixa.ixa.pipe.nerc.eval.Evaluate;
import eus.ixa.ixa.pipe.nerc.train.FixedTrainer;
import eus.ixa.ixa.pipe.nerc.train.Flags;
import eus.ixa.ixa.pipe.nerc.train.InputOutputUtils;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.TrainingParameters;
import org.jdom2.JDOMException;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    private Namespace parsedArguments = null;
    private ArgumentParser argParser = ArgumentParsers.newArgumentParser("ixa-pipe-nerc-" + this.version + ".jar").description("ixa-pipe-nerc-" + this.version + " is a multilingual sequence labeler module developed by IXA NLP Group.\n");
    private Subparsers subParsers = this.argParser.addSubparsers().help("sub-command help");
    private Subparser annotateParser = this.subParsers.addParser("tag").help("NER Tagging CLI");
    private Subparser oteParser;
    private Subparser trainParser;
    private Subparser evalParser;
    private Subparser crossValidateParser;
    private Subparser serverParser;
    private Subparser clientParser;

    public CLI() {
        this.loadAnnotateParameters();
        this.oteParser = this.subParsers.addParser("ote").help("Opinion Target Extraction CLI");
        this.loadOteParameters();
        this.trainParser = this.subParsers.addParser("train").help("Training CLI");
        this.loadTrainingParameters();
        this.evalParser = this.subParsers.addParser("eval").help("Evaluation CLI");
        this.loadEvalParameters();
        this.crossValidateParser = this.subParsers.addParser("cross").help("Cross validation CLI");
        this.loadCrossValidateParameters();
        this.serverParser = this.subParsers.addParser("server").help("Start TCP socket server");
        this.loadServerParameters();
        this.clientParser = this.subParsers.addParser("client").help("Send queries to the TCP socket server");
        this.loadClientParameters();
    }

    public static void main(String[] args) throws IOException, JDOMException {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    public final void parseCLI(String[] args) throws IOException, JDOMException {
        try {
            this.parsedArguments = this.argParser.parseArgs(args);
            System.err.println("CLI options: " + this.parsedArguments);
            if (args[0].equals("tag")) {
                this.annotate(System.in, System.out);
            } else if (args[0].equals("ote")) {
                this.extractOte(System.in, System.out);
            } else if (args[0].equals("eval")) {
                this.eval();
            } else if (args[0].equals("train")) {
                this.train();
            } else if (args[0].equals("cross")) {
                this.crossValidate();
            } else if (args[0].equals("server")) {
                this.server();
            } else if (args[0].equals("client")) {
                this.client(System.in, System.out);
            }
        }
        catch (ArgumentParserException e) {
            this.argParser.handleError(e);
            System.out.println("Run java -jar target/ixa-pipe-nerc-" + this.version + ".jar (tag|ote|train|eval|cross|server|client) -help for details");
            System.exit(1);
        }
    }

    public final void annotate(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream(breader);
        String model = this.parsedArguments.getString("model");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String lexer = this.parsedArguments.getString("lexer");
        String dictTag = this.parsedArguments.getString("dictTag");
        String dictPath = this.parsedArguments.getString("dictPath");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String lang = null;
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
                System.exit(1);
            }
        } else {
            lang = kaf.getLang();
        }
        Properties properties = this.setAnnotateProperties(model, lang, lexer, dictTag, dictPath, clearFeatures);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("entities", "ixa-pipe-nerc-" + Files.getNameWithoutExtension(model), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        Annotate annotator = new Annotate(properties);
        annotator.annotateNEs(kaf);
        newLp.setEndTimestamp();
        String kafToString = null;
        kafToString = outputFormat.equalsIgnoreCase("conll03") ? annotator.annotateNEsToCoNLL2003(kaf) : (outputFormat.equalsIgnoreCase("conll02") ? annotator.annotateNEsToCoNLL2002(kaf) : (outputFormat.equalsIgnoreCase("opennlp") ? annotator.annotateNEsToOpenNLP(kaf) : annotator.annotateNEsToKAF(kaf)));
        bwriter.write(kafToString);
        bwriter.close();
        breader.close();
    }

    public final void extractOte(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream(breader);
        String model = this.parsedArguments.getString("model");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String lang = null;
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
                System.exit(1);
            }
        } else {
            lang = kaf.getLang();
        }
        Properties properties = this.setOteProperties(model, lang, clearFeatures);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("opinions", "ixa-pipe-nerc-" + Files.getNameWithoutExtension(model), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        OpinionTargetExtractor oteExtractor = new OpinionTargetExtractor(properties);
        oteExtractor.annotateOTE(kaf);
        newLp.setEndTimestamp();
        String kafToString = null;
        kafToString = outputFormat.equalsIgnoreCase("opennlp") ? oteExtractor.annotateOTEsToOpenNLP(kaf) : oteExtractor.annotateOTEsToKAF(kaf);
        bwriter.write(kafToString);
        bwriter.close();
        breader.close();
    }

    public final void train() throws IOException {
        String paramFile = this.parsedArguments.getString("params");
        TrainingParameters params = InputOutputUtils.loadTrainingParameters(paramFile);
        String outModel = null;
        if (params.getSettings().get("OutputModel") == null || params.getSettings().get("OutputModel").length() == 0) {
            outModel = Files.getNameWithoutExtension(paramFile) + ".bin";
            params.put("OutputModel", outModel);
        } else {
            outModel = Flags.getModel(params);
        }
        FixedTrainer nercTrainer = new FixedTrainer(params);
        TokenNameFinderModel trainedModel = nercTrainer.train(params);
        CmdLineUtil.writeModel("ixa-pipe-nerc", new File(outModel), trainedModel);
    }

    public final void eval() throws IOException {
        String lang = this.parsedArguments.getString("language");
        String model = this.parsedArguments.getString("model");
        String testset = this.parsedArguments.getString("testset");
        String corpusFormat = this.parsedArguments.getString("corpusFormat");
        String netypes = this.parsedArguments.getString("types");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        Properties props = this.setEvalProperties(lang, model, testset, corpusFormat, netypes, clearFeatures);
        Evaluate evaluator = new Evaluate(props);
        if (this.parsedArguments.getString("evalReport") != null) {
            if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("brief")) {
                evaluator.evaluate();
            } else if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("error")) {
                evaluator.evalError();
            } else if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("detailed")) {
                evaluator.detailEvaluate();
            }
        } else {
            evaluator.detailEvaluate();
        }
    }

    public final void crossValidate() throws IOException {
        String paramFile = this.parsedArguments.getString("params");
        TrainingParameters params = InputOutputUtils.loadTrainingParameters(paramFile);
        CrossValidator crossValidator = new CrossValidator(params);
        crossValidator.crossValidate(params);
    }

    public final void server() {
        String task = this.parsedArguments.getString("task");
        String port = this.parsedArguments.getString("port");
        String model = this.parsedArguments.getString("model");
        String lexer = this.parsedArguments.getString("lexer");
        String dictTag = this.parsedArguments.getString("dictTag");
        String dictPath = this.parsedArguments.getString("dictPath");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String lang = this.parsedArguments.getString("language");
        Properties serverproperties = this.setNameServerProperties(port, model, lang, lexer, dictTag, dictPath, clearFeatures, outputFormat);
        if (task.equalsIgnoreCase("ote")) {
            new TargetExtractorServer(serverproperties);
        } else {
            new NameFinderServer(serverproperties);
        }
    }

    public final void client(InputStream inputStream, OutputStream outputStream) {
        String host = this.parsedArguments.getString("host");
        String port = this.parsedArguments.getString("port");
        try (Socket socketClient = new Socket(host, Integer.parseInt(port));
             BufferedReader inFromUser = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
             BufferedWriter outToUser = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
             BufferedWriter outToServer = new BufferedWriter(new OutputStreamWriter(socketClient.getOutputStream(), "UTF-8"));
             BufferedReader inFromServer = new BufferedReader(new InputStreamReader(socketClient.getInputStream(), "UTF-8"));){
            String kafString;
            String line;
            StringBuilder inText = new StringBuilder();
            while ((line = inFromUser.readLine()) != null) {
                inText.append(line).append("\n");
            }
            inText.append("<ENDOFDOCUMENT>").append("\n");
            outToServer.write(inText.toString());
            outToServer.flush();
            StringBuilder sb = new StringBuilder();
            while ((kafString = inFromServer.readLine()) != null) {
                sb.append(kafString).append("\n");
            }
            outToUser.write(sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (UnknownHostException e) {
            System.err.println("ERROR: Unknown hostname or IP address!");
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println("Port number not correct!");
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadAnnotateParameters() {
        this.annotateParser.addArgument("-m", "--model").required(true).help("Pass the model to do the tagging as a parameter.\n");
        this.annotateParser.addArgument("--clearFeatures").required(false).choices("yes", "no", "docstart").setDefault("no").help("Reset the adaptive features every sentence; defaults to 'no'; if -DOCSTART- marks are present, choose 'docstart'.\n");
        this.annotateParser.addArgument("-l", "--language").required(false).choices("de", "en", "es", "eu", "it", "nl").help("Choose language; it defaults to the language value in incoming NAF file.\n");
        this.annotateParser.addArgument("-o", "--outputFormat").required(false).choices("conll03", "conll02", "naf", "opennlp").setDefault("naf").help("Choose output format; it defaults to NAF.\n");
        this.annotateParser.addArgument("--lexer").choices("numeric").setDefault("off").required(false).help("Use lexer rules for NERC tagging; it defaults to false.\n");
        this.annotateParser.addArgument("--dictTag").required(false).choices("tag", "post").setDefault("off").help("Choose to directly tag entities by dictionary look-up; if the 'tag' option is chosen, only tags entities found in the dictionary; if 'post' option is chosen, it will post-process the results of the statistical model.\n");
        this.annotateParser.addArgument("--dictPath").required(false).setDefault("off").help("Provide the path to the dictionaries for direct dictionary tagging; it ONLY WORKS if --dictTag option is activated.\n");
    }

    private void loadOteParameters() {
        this.oteParser.addArgument("-m", "--model").required(true).help("Pass the model to do the tagging as a parameter.\n");
        this.oteParser.addArgument("--clearFeatures").required(false).choices("yes", "no", "docstart").setDefault("no").help("Reset the adaptive features every sentence; defaults to 'no'; if -DOCSTART- marks are present, choose 'docstart'.\n");
        this.oteParser.addArgument("-l", "--language").required(false).choices("en").help("Choose language; it defaults to the language value in incoming NAF file.\n");
        this.oteParser.addArgument("-o", "--outputFormat").required(false).choices("naf", "opennlp").setDefault("naf").help("Choose output format; it defaults to NAF.\n");
    }

    private void loadTrainingParameters() {
        this.trainParser.addArgument("-p", "--params").required(true).help("Load the training parameters file\n");
    }

    private void loadEvalParameters() {
        this.evalParser.addArgument("-l", "--language").required(true).choices("de", "en", "es", "eu", "it", "nl").help("Choose language.\n");
        this.evalParser.addArgument("-m", "--model").required(false).setDefault("off").help("Pass the model to evaluate as a parameter.\n");
        this.evalParser.addArgument("-t", "--testset").required(true).help("The test or reference corpus.\n");
        this.evalParser.addArgument("--clearFeatures").required(false).choices("yes", "no", "docstart").setDefault("no").help("Reset the adaptive features; defaults to 'no'.\n");
        this.evalParser.addArgument("-f", "--corpusFormat").required(false).choices("conll02", "conll03", "opennlp").setDefault("conll02").help("Choose format of reference corpus; it defaults to conll02 format.\n");
        this.evalParser.addArgument("--evalReport").required(false).choices("brief", "detailed", "error").help("Choose level of detail of evaluation report; it defaults to detailed evaluation.\n");
        this.evalParser.addArgument("--types").required(false).setDefault("off").help("Choose which Sequence types used for evaluation; the argument must be a comma separated string; e.g., 'person,organization'.\n");
    }

    private void loadCrossValidateParameters() {
        this.crossValidateParser.addArgument("-p", "--params").required(true).help("Load the Cross validation parameters file\n");
    }

    private void loadServerParameters() {
        this.serverParser.addArgument("-t", "--task").required(false).choices("ner", "ote", "sst").setDefault("ner").help("Choose the type of sequence labeling task.\n");
        this.serverParser.addArgument("-p", "--port").required(true).help("Port to be assigned to the server.\n");
        this.serverParser.addArgument("-m", "--model").required(true).help("Pass the model to do the tagging as a parameter.\n");
        this.serverParser.addArgument("--clearFeatures").required(false).choices("yes", "no", "docstart").setDefault("no").help("Reset the adaptive features every sentence; defaults to 'no'; if -DOCSTART- marks are present, choose 'docstart'.\n");
        this.serverParser.addArgument("-l", "--language").required(true).choices("de", "en", "es", "eu", "it", "nl").help("Choose language.\n");
        this.serverParser.addArgument("-o", "--outputFormat").required(false).choices("conll03", "conll02", "naf", "opennlp").setDefault("naf").help("Choose output format; it defaults to NAF.\n");
        this.serverParser.addArgument("--lexer").choices("numeric").setDefault("off").required(false).help("Use lexer rules for NERC tagging; it defaults to false.\n");
        this.serverParser.addArgument("--dictTag").required(false).choices("tag", "post").setDefault("off").help("Choose to directly tag entities by dictionary look-up; if the 'tag' option is chosen, only tags entities found in the dictionary; if 'post' option is chosen, it will post-process the results of the statistical model.\n");
        this.serverParser.addArgument("--dictPath").required(false).setDefault("off").help("Provide the path to the dictionaries for direct dictionary tagging; it ONLY WORKS if --dictTag option is activated.\n");
    }

    private void loadClientParameters() {
        this.clientParser.addArgument("-p", "--port").required(true).help("Port of the TCP server.\n");
        this.clientParser.addArgument("--host").required(false).setDefault("localhost").help("Hostname or IP where the TCP server is running.\n");
    }

    private Properties setAnnotateProperties(String model, String language, String lexer, String dictTag, String dictPath, String clearFeatures) {
        Properties annotateProperties = new Properties();
        annotateProperties.setProperty("model", model);
        annotateProperties.setProperty("language", language);
        annotateProperties.setProperty("ruleBasedOption", lexer);
        annotateProperties.setProperty("dictTag", dictTag);
        annotateProperties.setProperty("dictPath", dictPath);
        annotateProperties.setProperty("clearFeatures", clearFeatures);
        return annotateProperties;
    }

    private Properties setOteProperties(String model, String language, String clearFeatures) {
        Properties oteProperties = new Properties();
        oteProperties.setProperty("model", model);
        oteProperties.setProperty("language", language);
        oteProperties.setProperty("clearFeatures", clearFeatures);
        return oteProperties;
    }

    private Properties setEvalProperties(String language, String model, String testset, String corpusFormat, String netypes, String clearFeatures) {
        Properties evalProperties = new Properties();
        evalProperties.setProperty("language", language);
        evalProperties.setProperty("model", model);
        evalProperties.setProperty("testset", testset);
        evalProperties.setProperty("corpusFormat", corpusFormat);
        evalProperties.setProperty("types", netypes);
        evalProperties.setProperty("clearFeatures", clearFeatures);
        return evalProperties;
    }

    private Properties setNameServerProperties(String port, String model, String language, String lexer, String dictTag, String dictPath, String clearFeatures, String outputFormat) {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("port", port);
        serverProperties.setProperty("model", model);
        serverProperties.setProperty("language", language);
        serverProperties.setProperty("ruleBasedOption", lexer);
        serverProperties.setProperty("dictTag", dictTag);
        serverProperties.setProperty("dictPath", dictPath);
        serverProperties.setProperty("clearFeatures", clearFeatures);
        serverProperties.setProperty("outputFormat", outputFormat);
        return serverProperties;
    }
}

