/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc;

import eus.ixa.ixa.pipe.nerc.Name;
import eus.ixa.ixa.pipe.nerc.NameFactory;
import eus.ixa.ixa.pipe.nerc.NameFinder;
import eus.ixa.ixa.pipe.nerc.StringUtils;
import eus.ixa.ixa.pipe.nerc.dict.Dictionaries;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.util.Span;

public class DictionariesNameFinder
implements NameFinder {
    private NameFactory nameFactory;
    private Dictionaries dictionaries;
    private final boolean debug = false;

    public DictionariesNameFinder(Dictionaries aDictionaries) {
        this.dictionaries = aDictionaries;
    }

    public DictionariesNameFinder(Dictionaries aDictionaries, NameFactory aNameFactory) {
        this.dictionaries = aDictionaries;
        this.nameFactory = aNameFactory;
    }

    @Override
    public final List<Name> getNames(String[] tokens) {
        Span[] origSpans = this.nercToSpans(tokens);
        Span[] neSpans = NameFinderME.dropOverlappingSpans(origSpans);
        List<Name> names = this.getNamesFromSpans(neSpans, tokens);
        return names;
    }

    @Override
    public final Span[] nercToSpans(String[] tokens) {
        ArrayList<Span> neSpans = new ArrayList<Span>();
        for (Map<String, String> neDict : this.dictionaries.getIgnoreCaseDictionaries()) {
            for (Map.Entry<String, String> neEntry : neDict.entrySet()) {
                String neForm = neEntry.getKey();
                String neType = neEntry.getValue();
                List<Integer> neIds = StringUtils.exactTokenFinderIgnoreCase(neForm, tokens);
                if (neIds.isEmpty()) continue;
                for (int i = 0; i < neIds.size(); i += 2) {
                    Span neSpan = new Span((int)neIds.get(i), (int)neIds.get(i + 1), neType);
                    neSpans.add(neSpan);
                }
            }
        }
        return neSpans.toArray(new Span[neSpans.size()]);
    }

    public final Span[] nercToSpansExact(String[] tokens) {
        ArrayList<Span> neSpans = new ArrayList<Span>();
        for (Map<String, String> neDict : this.dictionaries.getDictionaries()) {
            for (Map.Entry<String, String> neEntry : neDict.entrySet()) {
                String neForm = neEntry.getKey();
                String neType = neEntry.getValue();
                List<Integer> neIds = StringUtils.exactTokenFinder(neForm, tokens);
                if (neIds.isEmpty()) continue;
                for (int i = 0; i < neIds.size(); i += 2) {
                    Span neSpan = new Span((int)neIds.get(i), (int)neIds.get(i + 1), neType);
                    neSpans.add(neSpan);
                }
            }
        }
        return neSpans.toArray(new Span[neSpans.size()]);
    }

    @Override
    public final List<Name> getNamesFromSpans(Span[] neSpans, String[] tokens) {
        ArrayList<Name> names = new ArrayList<Name>();
        for (Span neSpan : neSpans) {
            String nameString = StringUtils.getStringFromSpan(neSpan, tokens);
            String neType = neSpan.getType();
            Name name = this.nameFactory.createName(nameString, neType, neSpan);
            names.add(name);
        }
        return names;
    }

    @Override
    public void clearAdaptiveData() {
    }
}

