/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.dict;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class Dictionary
implements SerializableArtifact {
    private static final Pattern tabPattern = Pattern.compile("\t");
    private Map<String, String> dictionary = new HashMap<String, String>();

    public Dictionary(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            String[] lineArray = tabPattern.split(line);
            if (lineArray.length == 2) {
                this.dictionary.put(lineArray[0].toLowerCase(), lineArray[1].intern());
                continue;
            }
            System.err.println(lineArray[0] + " is not well formed!");
        }
    }

    public String lookup(String string) {
        return this.dictionary.get(string);
    }

    public int getMaxTokenCount() {
        return this.dictionary.size();
    }

    public final Map<String, String> getDict() {
        return this.dictionary;
    }

    public List<String> getBioDictionaryMatch(String[] tokens) {
        ArrayList<String> entitiesList = new ArrayList<String>();
        String prefix = "-start";
        String gazEntry = null;
        String searchSpan = null;
        for (int i = 0; i < tokens.length; ++i) {
            int j;
            gazEntry = null;
            for (j = tokens.length - 1; j >= i && (gazEntry = this.lookup((searchSpan = this.createSpan(tokens, i, j)).toLowerCase())) == null; --j) {
            }
            prefix = "-start";
            if (gazEntry != null) {
                while (i < j) {
                    entitiesList.add((gazEntry + prefix).intern());
                    prefix = "-cont";
                    ++i;
                }
            }
            if (gazEntry != null) {
                entitiesList.add((gazEntry + prefix).intern());
                continue;
            }
            entitiesList.add("other");
        }
        return entitiesList;
    }

    public List<String> getBilouDictionaryMatch(String[] tokens) {
        ArrayList<String> entitiesList = new ArrayList<String>();
        String prefix = "-start";
        String gazClass = null;
        String searchSpan = null;
        for (int i = 0; i < tokens.length; ++i) {
            int j;
            gazClass = null;
            for (j = tokens.length - 1; j >= i && (gazClass = this.lookup((searchSpan = this.createSpan(tokens, i, j)).toLowerCase())) == null; --j) {
            }
            prefix = "-start";
            if (gazClass != null) {
                while (i < j) {
                    entitiesList.add((gazClass + prefix).intern());
                    prefix = "-cont";
                    ++i;
                }
            }
            if (gazClass != null) {
                if (prefix.equals("-start")) {
                    entitiesList.add((gazClass + "-" + "unit").intern());
                    continue;
                }
                if (!prefix.equals("-cont")) continue;
                entitiesList.add((gazClass + "-" + "last").intern());
                continue;
            }
            entitiesList.add("other");
        }
        return entitiesList;
    }

    private String createSpan(String[] tokens, int from, int to) {
        String tokenSpan = "";
        for (int i = from; i < to; ++i) {
            tokenSpan = tokenSpan + tokens[i] + " ";
        }
        tokenSpan = tokenSpan + tokens[to];
        return tokenSpan;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            writer.write(entry.getKey() + "\t" + entry.getValue() + "\n");
        }
        ((Writer)writer).flush();
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return DictionarySerializer.class;
    }

    public static class DictionarySerializer
    implements ArtifactSerializer<Dictionary> {
        @Override
        public Dictionary create(InputStream in) throws IOException, InvalidFormatException {
            return new Dictionary(in);
        }

        @Override
        public void serialize(Dictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

