/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.features;

import eus.ixa.ixa.pipe.nerc.dict.BrownCluster;
import eus.ixa.ixa.pipe.nerc.features.BrownTokenClasses;
import eus.ixa.ixa.pipe.nerc.features.TokenClassFeatureGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class BrownTokenClassFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private BrownCluster brownLexicon;
    private Map<String, String> attributes;

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String tokenShape = TokenClassFeatureGenerator.tokenShapeFeature(tokens[index]);
        List<String> wordClasses = BrownTokenClasses.getWordClasses(tokens[index], this.brownLexicon);
        for (int i = 0; i < wordClasses.size(); ++i) {
            features.add("c," + this.attributes.get("dict") + "=" + tokenShape + "," + wordClasses.get(i));
        }
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    @Override
    public void clearAdaptiveData() {
    }

    @Override
    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object dictResource = resourceProvider.getResource(properties.get("dict"));
        if (!(dictResource instanceof BrownCluster)) {
            throw new InvalidFormatException("Not a BrownCluster resource for key: " + properties.get("dict"));
        }
        this.brownLexicon = (BrownCluster)dictResource;
        this.attributes = properties;
    }

    @Override
    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, BrownCluster.BrownClusterSerializer> mapping = new HashMap<String, BrownCluster.BrownClusterSerializer>();
        mapping.put("brownserializer", new BrownCluster.BrownClusterSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

