/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.features;

import eus.ixa.ixa.pipe.nerc.dict.Dictionary;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class DictionaryFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private String[] currentSentence;
    private List<String> currentEntities;
    private Dictionary dictionary;
    private Map<String, String> attributes;
    private boolean isBilou = true;

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentEntities = this.isBilou ? this.dictionary.getBilouDictionaryMatch(tokens) : this.dictionary.getBioDictionaryMatch(tokens);
        }
        String currentEntity = this.currentEntities.get(index);
        features.add(this.attributes.get("dict") + "=" + currentEntity);
        features.add(this.attributes.get("dict") + "," + "w=" + currentEntity + "," + tokens[index]);
        features.add(this.attributes.get("dict") + ",w=dict");
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    @Override
    public void clearAdaptiveData() {
    }

    @Override
    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object dictResource = resourceProvider.getResource(properties.get("dict"));
        if (!(dictResource instanceof Dictionary)) {
            throw new InvalidFormatException("Not a Dictionary resource for key: " + properties.get("dict"));
        }
        this.dictionary = (Dictionary)dictResource;
        this.attributes = properties;
        this.isBilou = !properties.get("seqCodec").equalsIgnoreCase("bio");
    }

    @Override
    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, Dictionary.DictionarySerializer> mapping = new HashMap<String, Dictionary.DictionarySerializer>();
        mapping.put("dictionaryserializer", new Dictionary.DictionarySerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

