/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

public class CoNLL02Format
implements ObjectStream<NameSample> {
    private final ObjectStream<String> lineStream;
    private String clearFeatures;

    public CoNLL02Format(String clearFeatures, ObjectStream<String> lineStream) {
        this.clearFeatures = clearFeatures;
        this.lineStream = lineStream;
    }

    public CoNLL02Format(String clearFeatures, InputStreamFactory in) throws IOException {
        this.clearFeatures = clearFeatures;
        try {
            this.lineStream = new PlainTextByLineStream(in, "UTF-8");
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NameSample read() throws IOException {
        String line;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> neTypes = new ArrayList<String>();
        boolean isClearAdaptiveData = false;
        while ((line = this.lineStream.read()) != null && !StringUtil.isEmpty(line)) {
            if (this.clearFeatures.equalsIgnoreCase("docstart") && line.startsWith("-DOCSTART-")) {
                isClearAdaptiveData = true;
                String emptyLine = this.lineStream.read();
                if (StringUtil.isEmpty(emptyLine)) continue;
                throw new IOException("Empty line after -DOCSTART- not empty: '" + emptyLine + "'!");
            }
            String[] fields = line.split("\t");
            if (fields.length == 2) {
                tokens.add(fields[0]);
                neTypes.add(fields[1]);
                continue;
            }
            throw new IOException("Expected two fields per line in training data, got " + fields.length + " for line '" + line + "'!");
        }
        if (this.clearFeatures.equalsIgnoreCase("yes")) {
            isClearAdaptiveData = true;
        }
        if (tokens.size() > 0) {
            ArrayList<Span> names = new ArrayList<Span>();
            int beginIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < neTypes.size(); ++i) {
                String neTag = (String)neTypes.get(i);
                if (neTag.startsWith("B-")) {
                    if (beginIndex != -1) {
                        names.add(CoNLL02Format.extract(beginIndex, endIndex, (String)neTypes.get(beginIndex)));
                    }
                    beginIndex = i;
                    endIndex = i + 1;
                    continue;
                }
                if (neTag.startsWith("I-")) {
                    ++endIndex;
                    continue;
                }
                if (neTag.equals("O")) {
                    if (beginIndex == -1) continue;
                    names.add(CoNLL02Format.extract(beginIndex, endIndex, (String)neTypes.get(beginIndex)));
                    beginIndex = -1;
                    endIndex = -1;
                    continue;
                }
                throw new IOException("Invalid tag: " + neTag);
            }
            if (beginIndex != -1) {
                names.add(CoNLL02Format.extract(beginIndex, endIndex, (String)neTypes.get(beginIndex)));
            }
            return new NameSample(tokens.toArray(new String[tokens.size()]), names.toArray(new Span[names.size()]), isClearAdaptiveData);
        }
        if (line != null) {
            return this.read();
        }
        return null;
    }

    static final Span extract(int begin, int end, String beginTag) throws InvalidFormatException {
        String type = beginTag.substring(2);
        return new Span(begin, end, type);
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }
}

