/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos.eval;

import eus.ixa.ixa.pipe.pos.MorphoSampleStream;
import eus.ixa.ixa.pipe.pos.eval.Evaluate;
import eus.ixa.ixa.pipe.pos.train.InputOutputUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.cmdline.postag.POSTaggerFineGrainedReportListener;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;

public class POSEvaluate
implements Evaluate {
    private final ObjectStream<POSSample> testSamples;
    private static POSModel posModel;
    private final POSTaggerME posTagger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POSEvaluate(String testData, String model) throws IOException {
        ObjectStream<String> testStream = InputOutputUtils.readFileIntoMarkableStreamFactory(testData);
        this.testSamples = new MorphoSampleStream(testStream);
        FileInputStream trainedModelInputStream = null;
        try {
            if (posModel == null) {
                trainedModelInputStream = new FileInputStream(model);
                posModel = new POSModel(trainedModelInputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (trainedModelInputStream != null) {
                try {
                    ((InputStream)trainedModelInputStream).close();
                }
                catch (IOException e) {
                    System.err.println("Could not load model!");
                }
            }
        }
        this.posTagger = new POSTaggerME(posModel);
    }

    @Override
    public final void evaluate() {
        POSEvaluator evaluator = new POSEvaluator(this.posTagger, new POSTaggerEvaluationMonitor[0]);
        try {
            evaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(evaluator.getWordAccuracy());
    }

    @Override
    public final void detailEvaluate() {
        LinkedList<POSTaggerFineGrainedReportListener> listeners = new LinkedList<POSTaggerFineGrainedReportListener>();
        POSTaggerFineGrainedReportListener detailedFListener = new POSTaggerFineGrainedReportListener(System.out);
        listeners.add(detailedFListener);
        POSEvaluator evaluator = new POSEvaluator(this.posTagger, listeners.toArray(new POSTaggerEvaluationMonitor[listeners.size()]));
        try {
            evaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        detailedFListener.writeReport();
    }

    @Override
    public final void evalError() {
        LinkedList<POSEvaluationErrorListener> listeners = new LinkedList<POSEvaluationErrorListener>();
        listeners.add(new POSEvaluationErrorListener());
        POSEvaluator evaluator = new POSEvaluator(this.posTagger, listeners.toArray(new POSTaggerEvaluationMonitor[listeners.size()]));
        try {
            evaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(evaluator.getWordAccuracy());
    }
}

