/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.AnnotationContainer;
import ixa.kaflib.CLink;
import ixa.kaflib.Chunk;
import ixa.kaflib.Comment;
import ixa.kaflib.Coref;
import ixa.kaflib.Dep;
import ixa.kaflib.Entity;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.Factuality;
import ixa.kaflib.Factvalue;
import ixa.kaflib.Feature;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.KAFNotValidException;
import ixa.kaflib.LinkedEntity;
import ixa.kaflib.Mark;
import ixa.kaflib.NonTerminal;
import ixa.kaflib.Opinion;
import ixa.kaflib.Predicate;
import ixa.kaflib.PredicateAnchor;
import ixa.kaflib.Relation;
import ixa.kaflib.Relational;
import ixa.kaflib.Span;
import ixa.kaflib.Statement;
import ixa.kaflib.TLink;
import ixa.kaflib.TLinkReferable;
import ixa.kaflib.Term;
import ixa.kaflib.Terminal;
import ixa.kaflib.Timex3;
import ixa.kaflib.Topic;
import ixa.kaflib.Tree;
import ixa.kaflib.TreeNode;
import ixa.kaflib.WF;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.CDATA;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;

class ReadWriteManager {
    ReadWriteManager() {
    }

    static KAFDocument load(File file) throws IOException, JDOMException, KAFNotValidException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        Element rootElem = document.getRootElement();
        return ReadWriteManager.DOMToKAF(document);
    }

    static KAFDocument load(Reader stream) throws IOException, JDOMException, KAFNotValidException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(stream);
        Element rootElem = document.getRootElement();
        return ReadWriteManager.DOMToKAF(document);
    }

    static void save(KAFDocument kaf, String filename) {
        try {
            File file = new File(filename);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            out.write(ReadWriteManager.kafToStr(kaf));
            ((Writer)out).flush();
        }
        catch (Exception e) {
            System.out.println("Error writing to file");
        }
    }

    static void print(KAFDocument kaf) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
            out.write(ReadWriteManager.kafToStr(kaf));
            ((Writer)out).flush();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static String kafToStr(KAFDocument kaf) {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat().setLineSeparator(LineSeparator.UNIX).setTextMode(Format.TextMode.TRIM_FULL_WHITE));
        Document jdom = ReadWriteManager.KAFToDOM(kaf);
        return out.outputString(jdom);
    }

    private static KAFDocument DOMToKAF(Document dom) throws KAFNotValidException {
        Span<Term> span;
        Element spanElem;
        List<Element> factualityElems;
        String toId;
        String fromId;
        Object timex3Freq;
        String targetId;
        String id;
        Span<Term> span2;
        Term targetTerm;
        List<ExternalRef> externalRefs;
        boolean isHead;
        HashMap<String, WF> wfIndex = new HashMap<String, WF>();
        HashMap<String, Term> termIndex = new HashMap<String, Term>();
        HashMap<String, IdentifiableAnnotation> relationalIndex = new HashMap<String, IdentifiableAnnotation>();
        HashMap<String, Predicate> predicateIndex = new HashMap<String, Predicate>();
        HashMap<String, Timex3> timexIndex = new HashMap<String, Timex3>();
        Element rootElem = dom.getRootElement();
        String lang = ReadWriteManager.getAttribute("lang", rootElem, Namespace.XML_NAMESPACE);
        String kafVersion = ReadWriteManager.getAttribute("version", rootElem);
        KAFDocument kaf = new KAFDocument(lang, kafVersion);
        List<Element> rootChildrenElems = rootElem.getChildren();
        Element elem = rootElem.getChild("nafHeader");
        if (elem != null) {
            Element publicElem;
            List<Element> lpsElems = elem.getChildren("linguisticProcessors");
            for (Element lpsElem : lpsElems) {
                String layer = ReadWriteManager.getAttribute("layer", lpsElem);
                List<Element> lpElems = lpsElem.getChildren();
                for (Element lpElem : lpElems) {
                    String hostname;
                    String version;
                    String endTimestamp;
                    String string;
                    String name = ReadWriteManager.getAttribute("name", lpElem);
                    KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor(layer, name);
                    String timestamp = ReadWriteManager.getOptAttribute("timestamp", lpElem);
                    if (timestamp != null) {
                        newLp.setTimestamp(timestamp);
                    }
                    if ((string = ReadWriteManager.getOptAttribute("beginTimestamp", lpElem)) != null) {
                        newLp.beginTimestamp = string;
                    }
                    if ((endTimestamp = ReadWriteManager.getOptAttribute("endTimestamp", lpElem)) != null) {
                        newLp.setEndTimestamp(endTimestamp);
                    }
                    if ((version = ReadWriteManager.getOptAttribute("version", lpElem)) != null) {
                        newLp.setVersion(version);
                    }
                    if ((hostname = ReadWriteManager.getOptAttribute("hostname", lpElem)) == null) continue;
                    newLp.setHostname(hostname);
                }
            }
            Element fileDescElem = elem.getChild("fileDesc");
            if (fileDescElem != null) {
                String creationtime;
                String pages;
                String string;
                String filename;
                String magazine;
                String location;
                String section;
                String publisher;
                String title;
                KAFDocument.FileDesc fd = kaf.createFileDesc();
                String author = ReadWriteManager.getOptAttribute("author", fileDescElem);
                if (author != null) {
                    fd.author = author;
                }
                if ((title = ReadWriteManager.getOptAttribute("title", fileDescElem)) != null) {
                    fd.title = title;
                }
                if ((publisher = ReadWriteManager.getOptAttribute("publisher", fileDescElem)) != null) {
                    fd.publisher = publisher;
                }
                if ((section = ReadWriteManager.getOptAttribute("section", fileDescElem)) != null) {
                    fd.section = section;
                }
                if ((location = ReadWriteManager.getOptAttribute("location", fileDescElem)) != null) {
                    fd.location = location;
                }
                if ((magazine = ReadWriteManager.getOptAttribute("magazine", fileDescElem)) != null) {
                    fd.magazine = magazine;
                }
                if ((filename = ReadWriteManager.getOptAttribute("filename", fileDescElem)) != null) {
                    fd.filename = filename;
                }
                if ((string = ReadWriteManager.getOptAttribute("filetype", fileDescElem)) != null) {
                    fd.filetype = string;
                }
                if ((pages = ReadWriteManager.getOptAttribute("pages", fileDescElem)) != null) {
                    fd.pages = Integer.parseInt(pages);
                }
                if ((creationtime = ReadWriteManager.getOptAttribute("creationtime", fileDescElem)) != null) {
                    fd.creationtime = creationtime;
                }
            }
            if ((publicElem = elem.getChild("public")) != null) {
                String uri;
                KAFDocument.Public pub = kaf.createPublic();
                String publicId = ReadWriteManager.getOptAttribute("publicId", publicElem);
                if (publicId != null) {
                    pub.publicId = publicId;
                }
                if ((uri = ReadWriteManager.getOptAttribute("uri", publicElem)) != null) {
                    pub.uri = uri;
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("raw")) != null) {
            kaf.setRawText(elem.getText());
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("text")) != null) {
            List<Element> wfElems = elem.getChildren();
            for (Element wfElem : wfElems) {
                String wXpath;
                String string;
                String wid = ReadWriteManager.getAttribute("id", wfElem);
                String wOffset = ReadWriteManager.getAttribute("offset", wfElem);
                String wLength = ReadWriteManager.getAttribute("length", wfElem);
                String wForm = wfElem.getText();
                String wSent = ReadWriteManager.getAttribute("sent", wfElem);
                WF newWf = kaf.newWF(wid, Integer.valueOf(wOffset), Integer.valueOf(wLength), wForm, Integer.valueOf(wSent));
                String wPara = ReadWriteManager.getOptAttribute("para", wfElem);
                if (wPara != null) {
                    newWf.setPara(Integer.valueOf(wPara));
                }
                if ((string = ReadWriteManager.getOptAttribute("page", wfElem)) != null) {
                    newWf.setPage(Integer.valueOf(string));
                }
                if ((wXpath = ReadWriteManager.getOptAttribute("xpath", wfElem)) != null) {
                    newWf.setXpath(wXpath);
                }
                wfIndex.put(newWf.getId(), newWf);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("terms")) != null) {
            List<Element> termElems = elem.getChildren();
            for (Element termElem : termElems) {
                ReadWriteManager.DOMToTerm(termElem, kaf, false, wfIndex, termIndex, null);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("entities")) != null) {
            List<Element> entityElems = elem.getChildren();
            for (Element entityElem : entityElems) {
                List<Element> list;
                String entSource;
                String entId = ReadWriteManager.getAttribute("id", entityElem);
                List<Element> referencesElem = entityElem.getChildren("references");
                if (referencesElem.size() < 1) {
                    throw new IllegalStateException("Every entity must contain a 'references' element");
                }
                List<Element> spanElems = referencesElem.get(0).getChildren();
                if (spanElems.size() < 1) {
                    throw new IllegalStateException("Every entity must contain a 'span' element inside 'references'");
                }
                ArrayList<Span<Term>> references = new ArrayList<Span<Term>>();
                for (Element spanElem3 : spanElems) {
                    Span<Term> span4 = kaf.newTermSpan();
                    List<Element> list2 = spanElem3.getChildren();
                    if (list2.size() < 1) {
                        throw new IllegalStateException("Every span in an entity must contain at least one target inside");
                    }
                    for (Element targetElem : list2) {
                        String targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                        Term targetTerm2 = termIndex.get(targetTermId);
                        if (targetTerm2 == null) {
                            throw new KAFNotValidException("Term " + targetTermId + " not found when loading entity " + entId);
                        }
                        isHead = ReadWriteManager.isHead(targetElem);
                        span4.addTarget(targetTerm2, isHead);
                    }
                    references.add(span4);
                }
                Entity newEntity = kaf.newEntity(entId, references);
                String entType = ReadWriteManager.getOptAttribute("type", entityElem);
                if (entType != null) {
                    newEntity.setType(entType);
                }
                if ((entSource = ReadWriteManager.getOptAttribute("source", entityElem)) != null) {
                    newEntity.setSource(entSource);
                }
                if ((list = entityElem.getChildren("externalReferences")).size() > 0) {
                    externalRefs = ReadWriteManager.getExternalReferences(list.get(0), kaf);
                    newEntity.addExternalRefs(externalRefs);
                }
                relationalIndex.put(newEntity.getId(), newEntity);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("constituency")) != null) {
            List<Element> treeElems = elem.getChildren("tree");
            for (Element treeElem : treeElems) {
                String type = ReadWriteManager.getOptAttribute("type", treeElem);
                HashMap<String, TreeNode> treeNodes = new HashMap<String, TreeNode>();
                HashMap<String, Boolean> rootNodes = new HashMap<String, Boolean>();
                List<Element> terminalElems = treeElem.getChildren("t");
                for (Element terminalElem : terminalElems) {
                    String id2 = ReadWriteManager.getAttribute("id", terminalElem);
                    Element element = terminalElem.getChild("span");
                    if (element == null) {
                        throw new KAFNotValidException("Constituent non terminal nodes need a span");
                    }
                    Span<Term> span5 = ReadWriteManager.loadTermSpan(element, termIndex, id2);
                    treeNodes.put(id2, kaf.newTerminal(id2, span5));
                    rootNodes.put(id2, true);
                }
                List<Element> nonTerminalElems = treeElem.getChildren("nt");
                for (Element nonTerminalElem : nonTerminalElems) {
                    String string = ReadWriteManager.getAttribute("id", nonTerminalElem);
                    String label = ReadWriteManager.getAttribute("label", nonTerminalElem);
                    treeNodes.put(string, kaf.newNonTerminal(string, label));
                    rootNodes.put(string, true);
                }
                List<Element> edgeElems = treeElem.getChildren("edge");
                for (Element element : edgeElems) {
                    String fromId2 = ReadWriteManager.getAttribute("from", element);
                    String toId2 = ReadWriteManager.getAttribute("to", element);
                    String edgeId = ReadWriteManager.getOptAttribute("id", element);
                    String head = ReadWriteManager.getOptAttribute("head", element);
                    isHead = head != null && head.equals("yes");
                    TreeNode parentNode = (TreeNode)treeNodes.get(toId2);
                    TreeNode childNode = (TreeNode)treeNodes.get(fromId2);
                    if (parentNode == null || childNode == null) {
                        throw new KAFNotValidException("There is a problem with the edge(" + fromId2 + ", " + toId2 + "). One of its targets doesn't exist.");
                    }
                    try {
                        ((NonTerminal)parentNode).addChild(childNode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rootNodes.put(fromId2, false);
                    if (edgeId != null) {
                        childNode.setEdgeId(edgeId);
                    }
                    if (!isHead) continue;
                    ((NonTerminal)childNode).setHead(isHead);
                }
                for (Map.Entry entry : rootNodes.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    TreeNode rootNode = (TreeNode)treeNodes.get(entry.getKey());
                    if (type == null) {
                        kaf.newConstituent(rootNode);
                        continue;
                    }
                    kaf.newConstituent(rootNode, type);
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("chunks")) != null) {
            List<Element> chunkElems = elem.getChildren();
            for (Element chunkElem : chunkElems) {
                String chunkCase;
                String chunkId = ReadWriteManager.getAttribute("id", chunkElem);
                String headId = ReadWriteManager.getAttribute("head", chunkElem);
                Term chunkHead = termIndex.get(headId);
                if (chunkHead == null) {
                    throw new KAFNotValidException("Term " + headId + " not found when loading chunk " + chunkId);
                }
                Element spanElem5 = chunkElem.getChild("span");
                if (spanElem5 == null) {
                    throw new IllegalStateException("Every chunk must contain a span element");
                }
                List<Element> chunksTermElems = spanElem5.getChildren("target");
                Span<Term> span3 = kaf.newTermSpan();
                for (Element element : chunksTermElems) {
                    String termId = ReadWriteManager.getAttribute("id", element);
                    boolean isHead2 = ReadWriteManager.isHead(element);
                    targetTerm = termIndex.get(termId);
                    if (targetTerm == null) {
                        throw new KAFNotValidException("Term " + termId + " not found when loading chunk " + chunkId);
                    }
                    span3.addTarget(targetTerm, targetTerm == chunkHead || isHead2);
                }
                if (!span3.hasTarget(chunkHead)) {
                    throw new KAFNotValidException("The head of the chunk is not in it's span.");
                }
                Chunk newChunk = kaf.newChunk(chunkId, span3);
                String string = ReadWriteManager.getOptAttribute("phrase", chunkElem);
                if (string != null) {
                    newChunk.setPhrase(string);
                }
                if ((chunkCase = ReadWriteManager.getOptAttribute("case", chunkElem)) == null) continue;
                newChunk.setCase(chunkCase);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("coreferences")) != null) {
            List<Element> corefElems = elem.getChildren();
            for (Element corefElem : corefElems) {
                List<Element> externalReferencesElems2;
                String coId = ReadWriteManager.getAttribute("id", corefElem);
                List<Element> spanElems = corefElem.getChildren("span");
                if (spanElems.size() < 1) {
                    throw new IllegalStateException("Every coref must contain a 'span' element inside 'references'");
                }
                ArrayList<Span<Term>> mentions = new ArrayList<Span<Term>>();
                for (Element spanElem6 : spanElems) {
                    span2 = kaf.newTermSpan();
                    List<Element> targetElems2 = spanElem6.getChildren();
                    if (targetElems2.size() < 1) {
                        throw new IllegalStateException("Every span in an entity must contain at least one target inside");
                    }
                    for (Element targetElem : targetElems2) {
                        String targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                        targetTerm = termIndex.get(targetTermId);
                        if (targetTerm == null) {
                            throw new KAFNotValidException("Term " + targetTermId + " not found when loading coref " + coId);
                        }
                        boolean isHead3 = ReadWriteManager.isHead(targetElem);
                        span2.addTarget(targetTerm, isHead3);
                    }
                    mentions.add(span2);
                }
                Coref newCoref = kaf.newCoref(coId, mentions);
                String corefType = ReadWriteManager.getOptAttribute("type", corefElem);
                if (corefType != null) {
                    newCoref.setType(corefType);
                }
                if ((externalReferencesElems2 = corefElem.getChildren("externalReferences")).size() <= 0) continue;
                List<ExternalRef> externalRefs2 = ReadWriteManager.getExternalReferences(externalReferencesElems2.get(0), kaf);
                newCoref.addExternalRefs(externalRefs2);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("opinions")) != null) {
            List<Element> opinionElems = elem.getChildren("opinion");
            for (Element opinionElem : opinionElems) {
                Element spanElem7;
                Element opinionExpressionElem;
                Element opinionTargetElem;
                String refId;
                String opinionId = ReadWriteManager.getAttribute("id", opinionElem);
                Opinion opinion = kaf.newOpinion(opinionId);
                Element opinionHolderElem = opinionElem.getChild("opinion_holder");
                if (opinionHolderElem != null) {
                    Element spanElem8;
                    Span<Term> span22 = kaf.newTermSpan();
                    Opinion.OpinionHolder opinionHolder = opinion.createOpinionHolder(span22);
                    String ohType = ReadWriteManager.getOptAttribute("type", opinionHolderElem);
                    if (ohType != null) {
                        opinionHolder.setType(ohType);
                    }
                    if ((spanElem8 = opinionHolderElem.getChild("span")) != null) {
                        List<Element> list = spanElem8.getChildren("target");
                        for (Element targetElem : list) {
                            refId = ReadWriteManager.getOptAttribute("id", targetElem);
                            boolean isHead4 = ReadWriteManager.isHead(targetElem);
                            Term targetTerm3 = termIndex.get(refId);
                            if (targetTerm3 == null) {
                                throw new KAFNotValidException("Term " + refId + " not found when loading opinion " + opinionId);
                            }
                            span22.addTarget(targetTerm3, isHead4);
                        }
                    }
                }
                if ((opinionTargetElem = opinionElem.getChild("opinion_target")) != null) {
                    Span<Term> span6 = kaf.newTermSpan();
                    Opinion.OpinionTarget opinionTarget = opinion.createOpinionTarget(span6);
                    Element spanElem2 = opinionTargetElem.getChild("span");
                    if (spanElem2 != null) {
                        List<Element> list = spanElem2.getChildren("target");
                        for (Element targetElem : list) {
                            refId = ReadWriteManager.getOptAttribute("id", targetElem);
                            boolean isHead5 = ReadWriteManager.isHead(targetElem);
                            Term targetTerm2 = termIndex.get(refId);
                            if (targetTerm2 == null) {
                                throw new KAFNotValidException("Term " + refId + " not found when loading opinion " + opinionId);
                            }
                            span6.addTarget(targetTerm2, isHead5);
                        }
                    }
                }
                if ((opinionExpressionElem = opinionElem.getChild("opinion_expression")) == null) continue;
                span2 = kaf.newTermSpan();
                String polarity = ReadWriteManager.getOptAttribute("polarity", opinionExpressionElem);
                String string = ReadWriteManager.getOptAttribute("strength", opinionExpressionElem);
                String subjectivity = ReadWriteManager.getOptAttribute("subjectivity", opinionExpressionElem);
                String sentimentSemanticType = ReadWriteManager.getOptAttribute("sentiment_semantic_type", opinionExpressionElem);
                String sentimentProductFeature = ReadWriteManager.getOptAttribute("sentiment_product_feature", opinionExpressionElem);
                Opinion.OpinionExpression opinionExpression = opinion.createOpinionExpression(span2);
                if (polarity != null) {
                    opinionExpression.setPolarity(polarity);
                }
                if (string != null) {
                    opinionExpression.setStrength(string);
                }
                if (subjectivity != null) {
                    opinionExpression.setSubjectivity(subjectivity);
                }
                if (sentimentSemanticType != null) {
                    opinionExpression.setSentimentSemanticType(sentimentSemanticType);
                }
                if (sentimentProductFeature != null) {
                    opinionExpression.setSentimentProductFeature(sentimentProductFeature);
                }
                if ((spanElem7 = opinionExpressionElem.getChild("span")) == null) continue;
                List<Element> targetElems3 = spanElem7.getChildren("target");
                for (Element targetElem : targetElems3) {
                    String refId2 = ReadWriteManager.getOptAttribute("id", targetElem);
                    boolean isHead6 = ReadWriteManager.isHead(targetElem);
                    Term targetTerm4 = termIndex.get(refId2);
                    if (targetTerm4 == null) {
                        throw new KAFNotValidException("Term " + refId2 + " not found when loading opinion " + opinionId);
                    }
                    span2.addTarget(targetTerm4, isHead6);
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("deps")) != null) {
            List<Element> depElems = elem.getChildren();
            for (Element depElem : depElems) {
                String fromId3 = ReadWriteManager.getAttribute("from", depElem);
                String toId3 = ReadWriteManager.getAttribute("to", depElem);
                Term from = termIndex.get(fromId3);
                if (from == null) {
                    throw new KAFNotValidException("Term " + fromId3 + " not found when loading Dep (" + fromId3 + ", " + toId3 + ")");
                }
                Term to = termIndex.get(toId3);
                if (to == null) {
                    throw new KAFNotValidException("Term " + toId3 + " not found when loading Dep (" + fromId3 + ", " + toId3 + ")");
                }
                String rfunc = ReadWriteManager.getAttribute("rfunc", depElem);
                Dep newDep = kaf.newDep(from, to, rfunc);
                String depcase = ReadWriteManager.getOptAttribute("case", depElem);
                if (depcase == null) continue;
                newDep.setCase(depcase);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("srl")) != null) {
            List<Element> predicateElems = elem.getChildren("predicate");
            for (Element predicateElem : predicateElems) {
                String confidence;
                List<Element> list;
                id = ReadWriteManager.getAttribute("id", predicateElem);
                Span<Term> span7 = kaf.newTermSpan();
                Element spanElem2 = predicateElem.getChild("span");
                if (spanElem2 != null) {
                    List<Element> targetElems4 = spanElem2.getChildren("target");
                    for (Element targetElem : targetElems4) {
                        targetId = ReadWriteManager.getAttribute("id", targetElem);
                        boolean bl = ReadWriteManager.isHead(targetElem);
                        Term targetTerm5 = termIndex.get(targetId);
                        if (targetTerm5 == null) {
                            throw new KAFNotValidException("Term object " + targetId + " not found when loading predicate " + id);
                        }
                        span7.addTarget(targetTerm5, bl);
                    }
                }
                ArrayList<String> predTypes = new ArrayList<String>();
                List<Element> predTypeElems = predicateElem.getChildren("predType");
                for (Element predTypeElem : predTypeElems) {
                    String string = ReadWriteManager.getAttribute("uri", predTypeElem);
                    predTypes.add(string);
                }
                Predicate newPredicate = kaf.newPredicate(id, span7);
                String uri = ReadWriteManager.getOptAttribute("uri", predicateElem);
                if (uri != null) {
                    newPredicate.setUri(uri);
                }
                if ((list = predicateElem.getChildren("externalReferences")).size() > 0) {
                    externalRefs = ReadWriteManager.getExternalReferences(list.get(0), kaf);
                    newPredicate.addExternalRefs(externalRefs);
                }
                if ((confidence = ReadWriteManager.getOptAttribute("confidence", predicateElem)) != null) {
                    newPredicate.setConfidence(Float.valueOf(confidence).floatValue());
                }
                List<Element> roleElems = predicateElem.getChildren("role");
                for (Element roleElem : roleElems) {
                    String rid = ReadWriteManager.getAttribute("id", roleElem);
                    String semRole = ReadWriteManager.getAttribute("semRole", roleElem);
                    Span<Term> roleSpan = kaf.newTermSpan();
                    Element roleSpanElem = roleElem.getChild("span");
                    if (roleSpanElem != null) {
                        List<Element> targetElems5 = roleSpanElem.getChildren("target");
                        for (Element targetElem : targetElems5) {
                            String targetId2 = ReadWriteManager.getAttribute("id", targetElem);
                            boolean isHead8 = ReadWriteManager.isHead(targetElem);
                            Term targetTerm6 = termIndex.get(targetId2);
                            if (targetTerm6 == null) {
                                throw new KAFNotValidException("Term object " + targetId2 + " not found when loading role " + rid);
                            }
                            roleSpan.addTarget(targetTerm6, isHead8);
                        }
                    }
                    Predicate.Role newRole = kaf.newRole(rid, newPredicate, semRole, roleSpan);
                    List<Element> rExternalReferencesElems = roleElem.getChildren("externalReferences");
                    if (rExternalReferencesElems.size() > 0) {
                        List<ExternalRef> externalRefs3 = ReadWriteManager.getExternalReferences(rExternalReferencesElems.get(0), kaf);
                        newRole.addExternalRefs(externalRefs3);
                    }
                    newPredicate.addRole(newRole);
                }
                predicateIndex.put(newPredicate.getId(), newPredicate);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("timeExpressions")) != null) {
            List<Element> timex3Elems = elem.getChildren();
            HashMap<Timex3, String> uncompleteBeginPointRefs = new HashMap<Timex3, String>();
            HashMap<Timex3, String> uncompleteEndPointRefs = new HashMap<Timex3, String>();
            for (Element timex3Elem : timex3Elems) {
                Element spanElem9;
                String timex3Comment;
                String timex3AnchorTimeId;
                String timex3Mod;
                String timex3ValueFromFunction;
                String timex3Value;
                String timex3TempFunc;
                String timex3FuncInDoc;
                String string;
                String timex3EndPointId;
                String timex3Id = ReadWriteManager.getAttribute("id", timex3Elem);
                String timex3Type = ReadWriteManager.getAttribute("type", timex3Elem);
                Timex3 timex3 = kaf.newTimex3(timex3Id, timex3Type);
                String timex3BeginPointId = ReadWriteManager.getOptAttribute("beginPoint", timex3Elem);
                if (timex3BeginPointId != null) {
                    Timex3 beginPoint = (Timex3)timexIndex.get(timex3BeginPointId);
                    if (beginPoint == null) {
                        uncompleteBeginPointRefs.put(timex3, timex3BeginPointId);
                    } else {
                        timex3.setBeginPoint(beginPoint);
                    }
                }
                if ((timex3EndPointId = ReadWriteManager.getOptAttribute("endPoint", timex3Elem)) != null) {
                    Timex3 timex32 = (Timex3)timexIndex.get(timex3EndPointId);
                    if (timex32 == null) {
                        uncompleteEndPointRefs.put(timex3, timex3EndPointId);
                    } else {
                        timex3.setEndPoint(timex32);
                    }
                }
                if ((string = ReadWriteManager.getOptAttribute("quant", timex3Elem)) != null) {
                    timex3.setQuant(string);
                }
                if ((timex3Freq = ReadWriteManager.getOptAttribute("freq", timex3Elem)) != null) {
                    timex3.setFreq((String)timex3Freq);
                }
                if ((timex3FuncInDoc = ReadWriteManager.getOptAttribute("functionInDocument", timex3Elem)) != null) {
                    timex3.setFunctionInDocument(timex3FuncInDoc);
                }
                if ((timex3TempFunc = ReadWriteManager.getOptAttribute("temporalFunction", timex3Elem)) != null) {
                    Boolean tempFunc = timex3TempFunc.equals("true");
                    timex3.setTemporalFunction(tempFunc);
                }
                if ((timex3Value = ReadWriteManager.getOptAttribute("value", timex3Elem)) != null) {
                    timex3.setValue(timex3Value);
                }
                if ((timex3ValueFromFunction = ReadWriteManager.getOptAttribute("valueFromFunction", timex3Elem)) != null) {
                    timex3.setValueFromFunction(timex3ValueFromFunction);
                }
                if ((timex3Mod = ReadWriteManager.getOptAttribute("mod", timex3Elem)) != null) {
                    timex3.setMod(timex3Mod);
                }
                if ((timex3AnchorTimeId = ReadWriteManager.getOptAttribute("anchorTimeId", timex3Elem)) != null) {
                    timex3.setAnchorTimeId(timex3AnchorTimeId);
                }
                if ((timex3Comment = ReadWriteManager.getOptAttribute("comment", timex3Elem)) != null) {
                    timex3.setComment(timex3Comment);
                }
                if ((spanElem9 = timex3Elem.getChild("span")) != null) {
                    Span<WF> timex3Span = kaf.newWFSpan();
                    for (Element targetElem : spanElem9.getChildren("target")) {
                        String targetId3 = ReadWriteManager.getAttribute("id", targetElem);
                        WF wf = wfIndex.get(targetId3);
                        if (wf == null) {
                            throw new KAFNotValidException("Word form " + targetId3 + " not found when loading timex3 " + timex3Id);
                        }
                        boolean isHead9 = ReadWriteManager.isHead(targetElem);
                        timex3Span.addTarget(wf, isHead9);
                    }
                    timex3.setSpan(timex3Span);
                }
                timexIndex.put(timex3.getId(), timex3);
            }
            for (Timex3 timex3 : uncompleteBeginPointRefs.keySet()) {
                timex3.setBeginPoint((Timex3)timexIndex.get(uncompleteBeginPointRefs.get(timex3)));
            }
            for (Timex3 timex3 : uncompleteEndPointRefs.keySet()) {
                timex3.setEndPoint((Timex3)timexIndex.get(uncompleteEndPointRefs.get(timex3)));
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("temporalRelations")) != null) {
            List<Element> tLinkElems = elem.getChildren("tlink");
            for (Element tLinkElem : tLinkElems) {
                String tlid = ReadWriteManager.getAttribute("id", tLinkElem);
                fromId = ReadWriteManager.getAttribute("from", tLinkElem);
                toId = ReadWriteManager.getAttribute("to", tLinkElem);
                String fromType = ReadWriteManager.getAttribute("fromType", tLinkElem);
                String toType = ReadWriteManager.getAttribute("toType", tLinkElem);
                String relType = ReadWriteManager.getAttribute("relType", tLinkElem);
                TLinkReferable from = (TLinkReferable)((Object)(fromType.equals("event") ? (IdentifiableAnnotation)predicateIndex.get(fromId) : (IdentifiableAnnotation)timexIndex.get(fromId)));
                TLinkReferable tLinkReferable = (TLinkReferable)((Object)(toType.equals("event") ? (IdentifiableAnnotation)predicateIndex.get(toId) : (IdentifiableAnnotation)timexIndex.get(toId)));
                timex3Freq = kaf.newTLink(tlid, from, tLinkReferable, relType);
            }
            List<Element> predAnchorElems = elem.getChildren("predicateAnchor");
            for (Element predAnchorElem : predAnchorElems) {
                String string;
                String beginPointId;
                String id4 = ReadWriteManager.getAttribute("id", predAnchorElem);
                Element spanElem3 = predAnchorElem.getChild("span");
                Span<Predicate> predAnchorSpan = KAFDocument.newSpan();
                if (spanElem3 != null) {
                    for (Element targetElem : spanElem3.getChildren("target")) {
                        targetId = ReadWriteManager.getAttribute("id", targetElem);
                        Predicate predicate = (Predicate)predicateIndex.get(targetId);
                        if (predicate == null) {
                            throw new KAFNotValidException("Predicate " + targetId + " not found when loading PredicateAnchor " + id4);
                        }
                        boolean isHead10 = ReadWriteManager.isHead(targetElem);
                        predAnchorSpan.addTarget(predicate, isHead10);
                    }
                }
                PredicateAnchor newPa = kaf.newPredicateAnchor(id4, predAnchorSpan);
                String anchorTimeId = ReadWriteManager.getOptAttribute("anchorTime", predAnchorElem);
                if (anchorTimeId != null) {
                    Timex3 anchorTime = (Timex3)timexIndex.get(anchorTimeId);
                    if (anchorTime == null) {
                        throw new IllegalStateException("Invalid timex ID (" + anchorTimeId + ") in predicateAnchor " + id4);
                    }
                    newPa.setAnchorTime(anchorTime);
                }
                if ((beginPointId = ReadWriteManager.getOptAttribute("beginPoint", predAnchorElem)) != null) {
                    Timex3 timex3 = (Timex3)timexIndex.get(beginPointId);
                    if (timex3 == null) {
                        throw new IllegalStateException("Invalid timex ID (" + beginPointId + ") in predicateAnchor " + id4);
                    }
                    newPa.setBeginPoint(timex3);
                }
                if ((string = ReadWriteManager.getOptAttribute("endPoint", predAnchorElem)) == null) continue;
                Timex3 endPoint = (Timex3)timexIndex.get(string);
                if (endPoint == null) {
                    throw new IllegalStateException("Invalid timex ID (" + string + ") in predicateAnchor " + id4);
                }
                newPa.setEndPoint(endPoint);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("causalRelations")) != null) {
            List<Element> clinkElems = elem.getChildren("clink");
            for (Element clinkElem : clinkElems) {
                String clid = ReadWriteManager.getAttribute("id", clinkElem);
                fromId = ReadWriteManager.getAttribute("from", clinkElem);
                toId = ReadWriteManager.getAttribute("to", clinkElem);
                String relType = ReadWriteManager.getOptAttribute("relType", clinkElem);
                Predicate from = (Predicate)predicateIndex.get(fromId);
                Predicate to = (Predicate)predicateIndex.get(toId);
                CLink clink = kaf.newCLink(clid, from, to);
                if (relType == null) continue;
                clink.setRelType(relType);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("factualities")) != null) {
            factualityElems = elem.getChildren("factuality");
            for (Element factualityElem : factualityElems) {
                id = ReadWriteManager.getAttribute("id", factualityElem);
                spanElem = factualityElem.getChild("span");
                if (spanElem == null) {
                    throw new IllegalStateException("Every factuality must contain a 'span' element");
                }
                span = ReadWriteManager.loadTermSpan(spanElem, termIndex, id);
                Factuality newFactuality = kaf.newFactuality(id, span);
                List<Element> factValElems = factualityElem.getChildren("factVal");
                for (Element factValElem : factValElems) {
                    newFactuality.addFactVal(ReadWriteManager.DOMToFactVal(factValElem, kaf));
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("factualityLayer")) != null) {
            factualityElems = elem.getChildren("factvalue");
            for (Element factualityElem : factualityElems) {
                id = ReadWriteManager.getAttribute("id", factualityElem);
                String prediction = ReadWriteManager.getAttribute("prediction", factualityElem);
                String confidenceStr = ReadWriteManager.getAttribute("confidence", factualityElem);
                Double confidence = null;
                if (confidenceStr != null) {
                    confidence = Double.parseDouble(confidenceStr);
                }
                Factvalue factuality = kaf.newFactvalue(wfIndex.get(id), prediction);
                if (confidence == null) continue;
                factuality.setConfidence(confidence);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("features")) != null) {
            String targetTermId;
            ArrayList<Span<Term>> references;
            List<Element> spanElems;
            Element referencesElem;
            String lemma;
            Element propertiesElem = elem.getChild("properties");
            Element categoriesElem = elem.getChild("categories");
            if (propertiesElem != null) {
                List<Element> propertyElems = propertiesElem.getChildren("property");
                for (Element propertyElem : propertyElems) {
                    String pid = ReadWriteManager.getAttribute("id", propertyElem);
                    lemma = ReadWriteManager.getAttribute("lemma", propertyElem);
                    referencesElem = propertyElem.getChild("references");
                    if (referencesElem == null) {
                        throw new IllegalStateException("Every property must contain a 'references' element");
                    }
                    spanElems = referencesElem.getChildren("span");
                    if (spanElems.size() < 1) {
                        throw new IllegalStateException("Every property must contain a 'span' element inside 'references'");
                    }
                    references = new ArrayList<Span<Term>>();
                    for (Element spanElem10 : spanElems) {
                        Span<Term> span8 = kaf.newTermSpan();
                        List<Element> targetElems6 = spanElem10.getChildren();
                        if (targetElems6.size() < 1) {
                            throw new IllegalStateException("Every span in a property must contain at least one target inside");
                        }
                        for (Element targetElem : targetElems6) {
                            targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                            Term targetTerm7 = termIndex.get(targetTermId);
                            if (targetTerm7 == null) {
                                throw new KAFNotValidException("Term " + targetTermId + " not found when loading property " + pid);
                            }
                            boolean isHead11 = ReadWriteManager.isHead(targetElem);
                            span8.addTarget(targetTerm7, isHead11);
                        }
                        references.add(span8);
                    }
                    Feature feature = kaf.newProperty(pid, lemma, references);
                    List<Element> externalReferencesElems3 = propertyElem.getChildren("externalReferences");
                    if (externalReferencesElems3.size() > 0) {
                        List<ExternalRef> externalRefs4 = ReadWriteManager.getExternalReferences(externalReferencesElems3.get(0), kaf);
                        feature.addExternalRefs(externalRefs4);
                    }
                    relationalIndex.put(feature.getId(), feature);
                }
            }
            if (categoriesElem != null) {
                List<Element> categoryElems = categoriesElem.getChildren("category");
                for (Element categoryElem : categoryElems) {
                    String cid = ReadWriteManager.getAttribute("id", categoryElem);
                    lemma = ReadWriteManager.getAttribute("lemma", categoryElem);
                    referencesElem = categoryElem.getChild("references");
                    if (referencesElem == null) {
                        throw new IllegalStateException("Every category must contain a 'references' element");
                    }
                    spanElems = referencesElem.getChildren("span");
                    if (spanElems.size() < 1) {
                        throw new IllegalStateException("Every category must contain a 'span' element inside 'references'");
                    }
                    references = new ArrayList();
                    for (Element spanElem11 : spanElems) {
                        Span<Term> span9 = kaf.newTermSpan();
                        List<Element> targetElems = spanElem11.getChildren();
                        if (targetElems.size() < 1) {
                            throw new IllegalStateException("Every span in a property must contain at least one target inside");
                        }
                        for (Element targetElem : targetElems) {
                            targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                            Term targetTerm3 = termIndex.get(targetTermId);
                            if (targetTerm3 == null) {
                                throw new KAFNotValidException("Term " + targetTermId + " not found when loading category " + cid);
                            }
                            boolean isHead12 = ReadWriteManager.isHead(targetElem);
                            span9.addTarget(targetTerm3, isHead12);
                        }
                        references.add(span9);
                    }
                    Feature feature = kaf.newCategory(cid, lemma, references);
                    List<Element> externalReferencesElems4 = categoryElem.getChildren("externalReferences");
                    if (externalReferencesElems4.size() > 0) {
                        List<ExternalRef> externalRefs5 = ReadWriteManager.getExternalReferences(externalReferencesElems4.get(0), kaf);
                        feature.addExternalRefs(externalRefs5);
                    }
                    relationalIndex.put(feature.getId(), feature);
                }
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("relations")) != null) {
            List<Element> relationElems = elem.getChildren("relation");
            for (Element relationElem : relationElems) {
                Relational from;
                id = ReadWriteManager.getAttribute("id", relationElem);
                fromId = ReadWriteManager.getAttribute("from", relationElem);
                toId = ReadWriteManager.getAttribute("to", relationElem);
                String confidenceStr = ReadWriteManager.getOptAttribute("confidence", relationElem);
                float confidence = -1.0f;
                if (confidenceStr != null) {
                    confidence = Float.parseFloat(confidenceStr);
                }
                if ((from = (Relational)relationalIndex.get(fromId)) == null) {
                    throw new KAFNotValidException("Entity/feature object " + fromId + " not found when loading relation " + id);
                }
                Relational to = (Relational)relationalIndex.get(toId);
                if (to == null) {
                    throw new KAFNotValidException("Entity/feature object " + toId + " not found when loading relation " + id);
                }
                Relation relation = kaf.newRelation(id, from, to);
                if (!(confidence >= 0.0f)) continue;
                relation.setConfidence(confidence);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("topics")) != null) {
            List<Element> topicElems = elem.getChildren("topic");
            for (Element topicElem : topicElems) {
                String URI2;
                String method;
                String value = topicElem.getText();
                Topic topic = kaf.newTopic(value);
                String source = ReadWriteManager.getOptAttribute("source", topicElem);
                if (source != null) {
                    topic.setSource(source);
                }
                if ((method = ReadWriteManager.getOptAttribute("method", topicElem)) != null) {
                    topic.setMethod(method);
                }
                String confidenceStr = ReadWriteManager.getOptAttribute("confidence", topicElem);
                float confidence = -1.0f;
                if (confidenceStr != null) {
                    confidence = Float.parseFloat(confidenceStr);
                    topic.setConfidence(Float.valueOf(confidence));
                }
                if ((URI2 = ReadWriteManager.getOptAttribute("uri", topicElem)) == null) continue;
                topic.setURI(URI2);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("markables")) != null) {
            List<Element> markElems = elem.getChildren();
            for (Element markElem : markElems) {
                List<Element> externalReferencesElems5;
                String markcase;
                String tMorphofeat;
                String pos;
                String lemma;
                String string;
                String sid = ReadWriteManager.getAttribute("id", markElem);
                spanElem = markElem.getChild("span");
                if (spanElem == null) {
                    throw new IllegalStateException("Every mark must contain a span element");
                }
                List<Element> marksWfElems = spanElem.getChildren("target");
                Span<WF> span3 = kaf.newWFSpan();
                for (Element marksWfElem : marksWfElems) {
                    String wfId = ReadWriteManager.getAttribute("id", marksWfElem);
                    boolean bl = ReadWriteManager.isHead(marksWfElem);
                    WF wf = wfIndex.get(wfId);
                    if (wf == null) {
                        throw new KAFNotValidException("WF " + wfId + " not found when loading mark " + sid);
                    }
                    span3.addTarget(wf, bl);
                }
                String source = ReadWriteManager.getOptAttribute("source", markElem);
                Mark newMark = source == null ? kaf.newMark(sid, span3) : kaf.newMark(sid, source, span3);
                Element sentimentElem = markElem.getChild("sentiment");
                if (sentimentElem != null) {
                    newMark.setSentiment(ReadWriteManager.DOMToSentiment(sentimentElem, kaf));
                }
                if ((string = ReadWriteManager.getOptAttribute("type", markElem)) != null) {
                    newMark.setType(string);
                }
                if ((lemma = ReadWriteManager.getOptAttribute("lemma", markElem)) != null) {
                    newMark.setLemma(lemma);
                }
                if ((pos = ReadWriteManager.getOptAttribute("pos", markElem)) != null) {
                    newMark.setPos(pos);
                }
                if ((tMorphofeat = ReadWriteManager.getOptAttribute("morphofeat", markElem)) != null) {
                    newMark.setMorphofeat(tMorphofeat);
                }
                if ((markcase = ReadWriteManager.getOptAttribute("case", markElem)) != null) {
                    newMark.setCase(markcase);
                }
                if ((externalReferencesElems5 = markElem.getChildren("externalReferences")).size() <= 0) continue;
                List<ExternalRef> externalRefs6 = ReadWriteManager.getExternalReferences(externalReferencesElems5.get(0), kaf);
                newMark.addExternalRefs(externalRefs6);
            }
            rootChildrenElems.remove(elem);
        }
        if ((elem = rootElem.getChild("attribution")) != null) {
            List<Element> statementElems = elem.getChildren("statement");
            for (Element statementElem : statementElems) {
                Element element;
                String statementId = ReadWriteManager.getAttribute("id", statementElem);
                Element stTargetElem = statementElem.getChild("statement_target");
                if (stTargetElem == null) {
                    throw new KAFNotValidException("Statement " + statementId + " does not contain the compulsory StatementTarget element.");
                }
                span = kaf.newTermSpan();
                Statement.StatementTarget target = kaf.newStatementTarget(span);
                Element spanElem12 = stTargetElem.getChild("span");
                if (spanElem12 != null) {
                    List<Element> targetElems7 = spanElem12.getChildren("target");
                    for (Element element2 : targetElems7) {
                        String refId = ReadWriteManager.getOptAttribute("id", element2);
                        boolean isHead14 = ReadWriteManager.isHead(element2);
                        targetTerm = termIndex.get(refId);
                        if (targetTerm == null) {
                            throw new KAFNotValidException("Term " + refId + " not found when loading statement " + statementId);
                        }
                        span.addTarget(targetTerm, isHead14);
                    }
                }
                Statement statement = kaf.newStatement(statementId, target);
                Element stSourceElem = statementElem.getChild("statement_source");
                if (stSourceElem != null) {
                    Element element3 = stSourceElem.getChild("span");
                    if (element3 == null) {
                        throw new KAFNotValidException("StatementSource elements need to contain the span element");
                    }
                    Span<Term> sourceSpan = ReadWriteManager.loadTermSpan(element3, termIndex, statementId);
                    statement.setSource(kaf.newStatementSource(sourceSpan));
                }
                if ((element = statementElem.getChild("statement_cue")) == null) continue;
                Element cueSpanElem = element.getChild("span");
                if (cueSpanElem == null) {
                    throw new KAFNotValidException("StatementCue elements need to contain the span element");
                }
                Span<Term> cueSpan = ReadWriteManager.loadTermSpan(cueSpanElem, termIndex, statementId);
                statement.setCue(kaf.newStatementCue(cueSpan));
            }
            rootChildrenElems.remove(elem);
        }
        for (Element unknownLayerElem : rootChildrenElems) {
            kaf.addUnknownLayer(unknownLayerElem);
        }
        return kaf;
    }

    private static void DOMToTerm(Element termElem, KAFDocument kaf, boolean isComponent, Map<String, WF> wfIndex, Map<String, Term> termIndex, Term parentTerm) throws KAFNotValidException {
        List<Element> sentimentElems;
        String tMorphofeat;
        String pos;
        String lemma;
        String tid = ReadWriteManager.getAttribute("id", termElem);
        Element spanElem = termElem.getChild("span");
        List<Object> termsWfElems = new ArrayList();
        if (!isComponent) {
            if (spanElem == null) {
                throw new IllegalStateException("Every term must contain a span element");
            }
            termsWfElems = spanElem.getChildren("target");
        }
        Span<WF> span = kaf.newWFSpan();
        for (Element termsWfElem : termsWfElems) {
            String wfId = ReadWriteManager.getAttribute("id", termsWfElem);
            boolean isHead = ReadWriteManager.isHead(termsWfElem);
            WF wf = wfIndex.get(wfId);
            if (wf == null) {
                throw new KAFNotValidException("Wf " + wfId + " not found when loading term " + tid);
            }
            span.addTarget(wf, isHead);
        }
        Term newTerm = kaf.newTerm(tid, span, isComponent);
        String type = ReadWriteManager.getOptAttribute("type", termElem);
        if (type != null) {
            newTerm.setType(type);
        }
        if ((lemma = ReadWriteManager.getOptAttribute("lemma", termElem)) != null) {
            newTerm.setLemma(lemma);
        }
        if ((pos = ReadWriteManager.getOptAttribute("pos", termElem)) != null) {
            newTerm.setPos(pos);
        }
        if ((tMorphofeat = ReadWriteManager.getOptAttribute("morphofeat", termElem)) != null) {
            newTerm.setMorphofeat(tMorphofeat);
        }
        String tHead = ReadWriteManager.getOptAttribute("head", termElem);
        String termcase = ReadWriteManager.getOptAttribute("case", termElem);
        if (termcase != null) {
            newTerm.setCase(termcase);
        }
        if ((sentimentElems = termElem.getChildren("sentiment")).size() > 0) {
            Term.Sentiment sentiment = ReadWriteManager.DOMToSentiment(sentimentElems.get(0), kaf);
            newTerm.setSentiment(sentiment);
        }
        if (!isComponent) {
            List<Element> termsComponentElems = termElem.getChildren("component");
            for (Element termsComponentElem : termsComponentElems) {
                ReadWriteManager.DOMToTerm(termsComponentElem, kaf, true, wfIndex, termIndex, newTerm);
            }
        } else {
            parentTerm.addComponent(newTerm);
        }
        List<Element> externalReferencesElems = termElem.getChildren("externalReferences");
        if (externalReferencesElems.size() > 0) {
            List<ExternalRef> externalRefs = ReadWriteManager.getExternalReferences(externalReferencesElems.get(0), kaf);
            newTerm.addExternalRefs(externalRefs);
        }
        termIndex.put(newTerm.getId(), newTerm);
    }

    private static Term.Sentiment DOMToSentiment(Element sentimentElem, KAFDocument kaf) {
        String sentSentimentProductFeature;
        String sentSentimentMarker;
        String sentSentimentModifier;
        String sentSentimentSemanticType;
        String sentSubjectivity;
        String sentStrength;
        String sentPolarity;
        Term.Sentiment newSentiment = kaf.newSentiment();
        String sentResource = ReadWriteManager.getOptAttribute("resource", sentimentElem);
        if (sentResource != null) {
            newSentiment.setResource(sentResource);
        }
        if ((sentPolarity = ReadWriteManager.getOptAttribute("polarity", sentimentElem)) != null) {
            newSentiment.setPolarity(sentPolarity);
        }
        if ((sentStrength = ReadWriteManager.getOptAttribute("strength", sentimentElem)) != null) {
            newSentiment.setStrength(sentStrength);
        }
        if ((sentSubjectivity = ReadWriteManager.getOptAttribute("subjectivity", sentimentElem)) != null) {
            newSentiment.setSubjectivity(sentSubjectivity);
        }
        if ((sentSentimentSemanticType = ReadWriteManager.getOptAttribute("sentiment_semantic_type", sentimentElem)) != null) {
            newSentiment.setSentimentSemanticType(sentSentimentSemanticType);
        }
        if ((sentSentimentModifier = ReadWriteManager.getOptAttribute("sentiment_modifier", sentimentElem)) != null) {
            newSentiment.setSentimentModifier(sentSentimentModifier);
        }
        if ((sentSentimentMarker = ReadWriteManager.getOptAttribute("sentiment_marker", sentimentElem)) != null) {
            newSentiment.setSentimentMarker(sentSentimentMarker);
        }
        if ((sentSentimentProductFeature = ReadWriteManager.getOptAttribute("sentiment_product_feature", sentimentElem)) != null) {
            newSentiment.setSentimentProductFeature(sentSentimentProductFeature);
        }
        return newSentiment;
    }

    private static Factuality.FactVal DOMToFactVal(Element factValElem, KAFDocument kaf) {
        String confidence;
        String value = ReadWriteManager.getAttribute("value", factValElem);
        String resource = ReadWriteManager.getAttribute("resource", factValElem);
        Factuality.FactVal newFactVal = kaf.newFactVal(value, resource);
        String source = ReadWriteManager.getOptAttribute("source", factValElem);
        if (source != null) {
            newFactVal.setSource(source);
        }
        if ((confidence = ReadWriteManager.getOptAttribute("confidence", factValElem)) != null) {
            newFactVal.setConfidence(Float.valueOf(confidence));
        }
        return newFactVal;
    }

    private static Span<Term> loadTermSpan(Element spanElem, HashMap<String, Term> terms, String objId) throws KAFNotValidException {
        List<Element> targetElems = spanElem.getChildren("target");
        if (targetElems.size() < 1) {
            throw new KAFNotValidException("A span element can not be empty");
        }
        Span<Term> span = KAFDocument.newTermSpan();
        for (Element targetElem : targetElems) {
            String targetId = ReadWriteManager.getAttribute("id", targetElem);
            boolean isHead = ReadWriteManager.isHead(targetElem);
            Term targetTerm = terms.get(targetId);
            if (targetTerm == null) {
                throw new KAFNotValidException("Term object " + targetId + " not found when loading object " + objId);
            }
            span.addTarget(targetTerm, isHead);
        }
        return span;
    }

    private static Element createTermSpanElem(Span<Term> span) {
        Element spanElem = new Element("span");
        for (Term term : span.getTargets()) {
            Element targetElem = new Element("target");
            String targetId = term.getId();
            targetElem.setAttribute("id", targetId);
            if (span.isHead(term)) {
                targetElem.setAttribute("head", "yes");
            }
            spanElem.addContent(targetElem);
        }
        return spanElem;
    }

    private static List<ExternalRef> getExternalReferences(Element externalReferencesElem, KAFDocument kaf) {
        ArrayList<ExternalRef> externalRefs = new ArrayList<ExternalRef>();
        List<Element> externalRefElems = externalReferencesElem.getChildren();
        for (Element externalRefElem : externalRefElems) {
            ExternalRef externalRef = ReadWriteManager.getExternalRef(externalRefElem, kaf);
            externalRefs.add(externalRef);
        }
        return externalRefs;
    }

    private static ExternalRef getExternalRef(Element externalRefElem, KAFDocument kaf) {
        List<Element> sentimentElems;
        String source;
        String status;
        String reftype;
        String confidence;
        String resource = ReadWriteManager.getAttribute("resource", externalRefElem);
        ExternalRef newExternalRef = kaf.newExternalRef(resource);
        String references = ReadWriteManager.getOptAttribute("reference", externalRefElem);
        if (references != null) {
            newExternalRef.setReference(references);
        }
        if ((confidence = ReadWriteManager.getOptAttribute("confidence", externalRefElem)) != null) {
            newExternalRef.setConfidence(Float.valueOf(confidence));
        }
        if ((reftype = ReadWriteManager.getOptAttribute("reftype", externalRefElem)) != null) {
            newExternalRef.setReftype(reftype);
        }
        if ((status = ReadWriteManager.getOptAttribute("status", externalRefElem)) != null) {
            newExternalRef.setStatus(status);
        }
        if ((source = ReadWriteManager.getOptAttribute("source", externalRefElem)) != null) {
            newExternalRef.setSource(source);
        }
        if ((sentimentElems = externalRefElem.getChildren("sentiment")).size() > 0) {
            Term.Sentiment sentiment = ReadWriteManager.DOMToSentiment(sentimentElems.get(0), kaf);
            newExternalRef.setSentiment(sentiment);
        }
        List<Element> subRefElems = externalRefElem.getChildren("externalRef");
        for (Element subRefElem : subRefElems) {
            ExternalRef subRef = ReadWriteManager.getExternalRef(subRefElem, kaf);
            newExternalRef.addExternalRef(subRef);
        }
        return newExternalRef;
    }

    private static String getAttribute(String attName, Element elem) {
        String value = elem.getAttributeValue(attName);
        if (value == null) {
            throw new IllegalStateException(attName + " attribute must be defined for element " + elem.getName());
        }
        return value;
    }

    private static String getAttribute(String attName, Element elem, Namespace nmspace) {
        String value = elem.getAttributeValue(attName, nmspace);
        if (value == null) {
            throw new IllegalStateException(attName + " attribute must be defined for element " + elem.getName());
        }
        return value;
    }

    private static String getOptAttribute(String attName, Element elem) {
        String value = elem.getAttributeValue(attName);
        if (value == null) {
            return null;
        }
        return value;
    }

    private static boolean isHead(Element elem) {
        String value = elem.getAttributeValue("head");
        if (value == null) {
            return false;
        }
        return value.equals("yes");
    }

    /*
     * WARNING - void declaration
     */
    private static Document KAFToDOM(KAFDocument kaf) {
        List<Annotation> statements;
        List<Annotation> topics;
        List<Annotation> list;
        List<Annotation> list2;
        List<String> list3;
        List<Annotation> list4;
        List<Annotation> list5;
        Span<IdentifiableAnnotation> span;
        Element targetElem;
        List<Annotation> opinions;
        List<Annotation> list6;
        List<Annotation> list7;
        List<Annotation> list8;
        List<Annotation> list9;
        List<Annotation> list10;
        List<Annotation> list11;
        Element spanElem;
        List<Annotation> list12;
        List<Annotation> list13;
        List<Annotation> list14;
        List<Annotation> marks;
        List<Annotation> terms;
        List<Annotation> text;
        KAFDocument.Public pub;
        AnnotationContainer annotationContainer = kaf.getAnnotationContainer();
        Element root = new Element("NAF");
        root.setAttribute("lang", kaf.getLang(), Namespace.XML_NAMESPACE);
        root.setAttribute("version", kaf.getVersion());
        Document doc = new Document(root);
        Element kafHeaderElem = new Element("nafHeader");
        root.addContent(kafHeaderElem);
        KAFDocument.FileDesc fd = kaf.getFileDesc();
        if (fd != null) {
            Element fdElem = new Element("fileDesc");
            if (fd.author != null) {
                fdElem.setAttribute("author", fd.author);
            }
            if (fd.creationtime != null) {
                fdElem.setAttribute("creationtime", fd.creationtime);
            }
            if (fd.title != null) {
                fdElem.setAttribute("title", fd.title);
            }
            if (fd.publisher != null) {
                fdElem.setAttribute("publisher", fd.publisher);
            }
            if (fd.section != null) {
                fdElem.setAttribute("section", fd.section);
            }
            if (fd.location != null) {
                fdElem.setAttribute("location", fd.location);
            }
            if (fd.magazine != null) {
                fdElem.setAttribute("magazine", fd.magazine);
            }
            if (fd.filename != null) {
                fdElem.setAttribute("filename", fd.filename);
            }
            if (fd.filetype != null) {
                fdElem.setAttribute("filetype", fd.filetype);
            }
            if (fd.pages != null) {
                fdElem.setAttribute("pages", Integer.toString(fd.pages));
            }
            kafHeaderElem.addContent(fdElem);
        }
        if ((pub = kaf.getPublic()) != null) {
            Element pubElem = new Element("public");
            if (pub.publicId != null) {
                pubElem.setAttribute("publicId", pub.publicId);
            }
            if (pub.uri != null) {
                pubElem.setAttribute("uri", pub.uri);
            }
            kafHeaderElem.addContent(pubElem);
        }
        Map<String, List<KAFDocument.LinguisticProcessor>> lps = kaf.getLinguisticProcessors();
        for (Map.Entry<String, List<KAFDocument.LinguisticProcessor>> entry : lps.entrySet()) {
            Element lpsElem = new Element("linguisticProcessors");
            lpsElem.setAttribute("layer", entry.getKey());
            for (KAFDocument.LinguisticProcessor linguisticProcessor : entry.getValue()) {
                Element element = new Element("lp");
                element.setAttribute("name", linguisticProcessor.name);
                if (linguisticProcessor.hasTimestamp()) {
                    element.setAttribute("timestamp", linguisticProcessor.timestamp);
                }
                if (linguisticProcessor.hasBeginTimestamp()) {
                    element.setAttribute("beginTimestamp", linguisticProcessor.beginTimestamp);
                }
                if (linguisticProcessor.hasEndTimestamp()) {
                    element.setAttribute("endTimestamp", linguisticProcessor.endTimestamp);
                }
                if (linguisticProcessor.hasVersion()) {
                    element.setAttribute("version", linguisticProcessor.version);
                }
                if (linguisticProcessor.hasHostname().booleanValue()) {
                    element.setAttribute("hostname", linguisticProcessor.hostname);
                }
                lpsElem.addContent(element);
            }
            kafHeaderElem.addContent(lpsElem);
        }
        String rawText = annotationContainer.getRawText();
        if (rawText.length() > 0) {
            Element rawElem = new Element("raw");
            CDATA cdataElem = new CDATA(rawText);
            rawElem.addContent(cdataElem);
            root.addContent(rawElem);
        }
        if ((text = annotationContainer.getLayer(KAFDocument.Layer.TEXT)).size() > 0) {
            Element textElem = new Element("text");
            for (WF wF : text) {
                Element element = new Element("wf");
                element.setAttribute("id", wF.getId());
                element.setAttribute("offset", Integer.toString(wF.getOffset()));
                element.setAttribute("length", Integer.toString(wF.getLength()));
                element.setAttribute("sent", Integer.toString(wF.getSent()));
                if (wF.hasPara()) {
                    element.setAttribute("para", Integer.toString(wF.getPara()));
                }
                if (wF.hasPage()) {
                    element.setAttribute("page", Integer.toString(wF.getPage()));
                }
                if (wF.hasXpath()) {
                    element.setAttribute("xpath", wF.getXpath());
                }
                element.setText(wF.getForm());
                textElem.addContent(element);
            }
            root.addContent(textElem);
        }
        if ((terms = annotationContainer.getLayer(KAFDocument.Layer.TERMS)).size() > 0) {
            Element termsElem = new Element("terms");
            for (Term term : terms) {
                ReadWriteManager.termToDOM(term, false, termsElem);
            }
            root.addContent(termsElem);
        }
        if ((marks = annotationContainer.getLayer(KAFDocument.Layer.MARKABLES)).size() > 0) {
            Element element = new Element("markables");
            for (Mark mark : marks) {
                Comment comment = new Comment(ReadWriteManager.cleanUnicode(mark.getStr()));
                element.addContent(comment);
                Element element2 = new Element("mark");
                element2.setAttribute("id", mark.getId());
                if (mark.hasSource()) {
                    element2.setAttribute("source", mark.getSource());
                }
                if (mark.hasType()) {
                    element2.setAttribute("type", mark.getType());
                }
                if (mark.hasLemma()) {
                    element2.setAttribute("lemma", mark.getLemma());
                }
                if (mark.hasPos()) {
                    element2.setAttribute("pos", mark.getPos());
                }
                if (mark.hasMorphofeat()) {
                    element2.setAttribute("morphofeat", mark.getMorphofeat());
                }
                if (mark.hasCase()) {
                    element2.setAttribute("case", mark.getCase());
                }
                if (mark.hasSentiment()) {
                    element2.addContent(ReadWriteManager.sentimentToDOM(mark.getSentiment()));
                }
                Element element3 = new Element("span");
                Span<WF> span2 = mark.getSpan();
                for (WF wF : span2.getTargets()) {
                    Element element4 = new Element("target");
                    element4.setAttribute("id", wF.getId());
                    if (wF == span2.getHead()) {
                        element4.setAttribute("head", "yes");
                    }
                    element3.addContent(element4);
                }
                element2.addContent(element3);
                List<ExternalRef> list15 = mark.getExternalRefs();
                if (list15.size() > 0) {
                    Element element5 = ReadWriteManager.externalReferencesToDOM(list15);
                    element2.addContent(element5);
                }
                element.addContent(element2);
            }
            root.addContent(element);
        }
        if ((list14 = annotationContainer.getLayer(KAFDocument.Layer.DEPS)).size() > 0) {
            Element element = new Element("deps");
            for (Dep dep : list14) {
                Comment comment = new Comment(ReadWriteManager.cleanUnicode(dep.getStr()));
                element.addContent(comment);
                Element element6 = new Element("dep");
                element6.setAttribute("from", dep.getFrom().getId());
                element6.setAttribute("to", dep.getTo().getId());
                element6.setAttribute("rfunc", dep.getRfunc());
                if (dep.hasCase()) {
                    element6.setAttribute("case", dep.getCase());
                }
                element.addContent(element6);
            }
            root.addContent(element);
        }
        if ((list13 = annotationContainer.getLayer(KAFDocument.Layer.CHUNKS)).size() > 0) {
            Element element = new Element("chunks");
            for (Chunk chunk : list13) {
                Comment comment = new Comment(ReadWriteManager.cleanUnicode(chunk.getStr()));
                element.addContent(comment);
                Element element7 = new Element("chunk");
                element7.setAttribute("id", chunk.getId());
                element7.setAttribute("head", chunk.getHead().getId());
                if (chunk.hasPhrase()) {
                    element7.setAttribute("phrase", chunk.getPhrase());
                }
                if (chunk.hasCase()) {
                    element7.setAttribute("case", chunk.getCase());
                }
                Element element8 = new Element("span");
                for (Term term : chunk.getTerms()) {
                    Element element9 = new Element("target");
                    element9.setAttribute("id", term.getId());
                    element8.addContent(element9);
                }
                element7.addContent(element8);
                element.addContent(element7);
            }
            root.addContent(element);
        }
        if ((list12 = annotationContainer.getLayer(KAFDocument.Layer.ENTITIES)).size() > 0) {
            Element element = new Element("entities");
            for (Entity entity : list12) {
                Element element10 = new Element("entity");
                element10.setAttribute("id", entity.getId());
                if (entity.hasType()) {
                    element10.setAttribute("type", entity.getType());
                }
                if (entity.hasSource()) {
                    element10.setAttribute("source", entity.getSource());
                }
                Element element11 = new Element("references");
                for (Span<Term> span3 : entity.getSpans()) {
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(entity.getSpanStr(span3)));
                    element11.addContent(comment);
                    spanElem = new Element("span");
                    for (Term term : span3.getTargets()) {
                        Element element12 = new Element("target");
                        element12.setAttribute("id", term.getId());
                        if (term == span3.getHead()) {
                            element12.setAttribute("head", "yes");
                        }
                        spanElem.addContent(element12);
                    }
                    element11.addContent(spanElem);
                }
                element10.addContent(element11);
                List<ExternalRef> list16 = entity.getExternalRefs();
                if (list16.size() > 0) {
                    Element element13 = ReadWriteManager.externalReferencesToDOM(list16);
                    element10.addContent(element13);
                }
                element.addContent(element10);
            }
            root.addContent(element);
        }
        if ((list11 = annotationContainer.getLayer(KAFDocument.Layer.COREFERENCES)).size() > 0) {
            Element element = new Element("coreferences");
            for (Coref coref : list11) {
                Element element14 = new Element("coref");
                element14.setAttribute("id", coref.getId());
                if (coref.hasType()) {
                    element14.setAttribute("type", coref.getType());
                }
                for (Span<Term> span4 : coref.getSpans()) {
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(coref.getSpanStr(span4)));
                    element14.addContent(comment);
                    Element spanElem2 = new Element("span");
                    for (Term term : span4.getTargets()) {
                        Element element15 = new Element("target");
                        element15.setAttribute("id", term.getId());
                        if (term == span4.getHead()) {
                            element15.setAttribute("head", "yes");
                        }
                        spanElem2.addContent(element15);
                    }
                    element14.addContent(spanElem2);
                }
                List<ExternalRef> list17 = coref.getExternalRefs();
                if (list17.size() > 0) {
                    Element element16 = ReadWriteManager.externalReferencesToDOM(list17);
                    element14.addContent(element16);
                }
                element.addContent(element14);
            }
            root.addContent(element);
        }
        if ((list10 = annotationContainer.getLayer(KAFDocument.Layer.TIME_EXPRESSIONS)).size() > 0) {
            Element element = new Element("timeExpressions");
            for (Timex3 timex3 : list10) {
                Element element17 = new Element("timex3");
                element17.setAttribute("id", timex3.getId());
                element17.setAttribute("type", timex3.getType());
                if (timex3.hasBeginPoint()) {
                    element17.setAttribute("beginPoint", timex3.getBeginPoint().getId());
                }
                if (timex3.hasEndPoint()) {
                    element17.setAttribute("endPoint", timex3.getEndPoint().getId());
                }
                if (timex3.hasQuant()) {
                    element17.setAttribute("quant", timex3.getQuant());
                }
                if (timex3.hasFreq()) {
                    element17.setAttribute("freq", timex3.getFreq());
                }
                if (timex3.hasFunctionInDocument()) {
                    element17.setAttribute("functionInDocument", timex3.getFunctionInDocument());
                }
                if (timex3.hasTemporalFunction()) {
                    String string = timex3.getTemporalFunction() != false ? "true" : "false";
                    element17.setAttribute("temporalFunction", string);
                }
                if (timex3.hasValue()) {
                    element17.setAttribute("value", timex3.getValue());
                }
                if (timex3.hasValueFromFunction()) {
                    element17.setAttribute("valueFromFunction", timex3.getValueFromFunction());
                }
                if (timex3.hasMod()) {
                    element17.setAttribute("mod", timex3.getMod());
                }
                if (timex3.hasAnchorTimeId()) {
                    element17.setAttribute("anchorTimeId", timex3.getAnchorTimeId());
                }
                if (timex3.hasComment()) {
                    element17.setAttribute("comment", timex3.getComment());
                }
                if (timex3.hasSpan()) {
                    Span<WF> span5 = timex3.getSpan();
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(timex3.getSpanStr(span5)));
                    element17.addContent(comment);
                    spanElem = new Element("span");
                    for (WF wF : span5.getTargets()) {
                        Element element18 = new Element("target");
                        element18.setAttribute("id", wF.getId());
                        if (wF == span5.getHead()) {
                            element18.setAttribute("head", "yes");
                        }
                        spanElem.addContent(element18);
                    }
                    element17.addContent(spanElem);
                }
                element.addContent(element17);
            }
            root.addContent(element);
        }
        if ((list9 = annotationContainer.getLayer(KAFDocument.Layer.FACTUALITIES)).size() > 0) {
            Element element = new Element("factualities");
            for (Factuality factuality : list9) {
                Element element19 = new Element("factuality");
                element19.setAttribute("id", factuality.getId());
                Span<Term> span6 = factuality.getSpan();
                Comment spanComment2 = new Comment(ReadWriteManager.cleanUnicode(factuality.getSpanStr(span6)));
                element19.addContent(spanComment2);
                Element element20 = new Element("span");
                for (Term term : span6.getTargets()) {
                    Element element21 = new Element("target");
                    element21.setAttribute("id", term.getId());
                    if (term == span6.getHead()) {
                        element21.setAttribute("head", "yes");
                    }
                    element20.addContent(element21);
                }
                element19.addContent(element20);
                for (Factuality.FactVal factVal : factuality.getFactVals()) {
                    element19.addContent(ReadWriteManager.factValToDOM(factVal));
                }
                element.addContent(element19);
            }
            root.addContent(element);
        }
        if ((list8 = annotationContainer.getLayer(KAFDocument.Layer.FACTUALITY_LAYER)).size() > 0) {
            Element element = new Element("factualitylayer");
            for (Factvalue factvalue : list8) {
                Element element22 = new Element("factvalue");
                element22.setAttribute("id", factvalue.getId());
                element22.setAttribute("prediction", factvalue.getPrediction());
                element22.setAttribute("confidence", Double.toString(factvalue.getConfidence()));
                element.addContent(element22);
            }
            root.addContent(element);
        }
        if ((list7 = annotationContainer.getLayer(KAFDocument.Layer.LINKED_ENTITIES)).size() > 0) {
            Element element = new Element("linkedEntities");
            for (LinkedEntity linkedEntity : list7) {
                Element lEnt = new Element("linkedEntity");
                lEnt.setAttribute("id", linkedEntity.getId());
                lEnt.setAttribute("resource", linkedEntity.getResource());
                lEnt.setAttribute("reference", linkedEntity.getReference());
                lEnt.setAttribute("confidence", Double.toString(linkedEntity.getConfidence()));
                Comment comment = new Comment(ReadWriteManager.cleanUnicode(linkedEntity.getSpanStr()));
                lEnt.addContent(comment);
                Element element23 = new Element("span");
                for (WF wF : linkedEntity.getWFs().getTargets()) {
                    Element element24 = new Element("target");
                    element24.setAttribute("id", wF.getId());
                    element23.addContent(element24);
                }
                lEnt.addContent(element23);
                element.addContent(lEnt);
            }
            root.addContent(element);
        }
        Element element = new Element("features");
        List<Annotation> list18 = annotationContainer.getLayer(KAFDocument.Layer.PROPERTIES);
        if (list18.size() > 0) {
            Element element25 = new Element("properties");
            for (Feature feature : list18) {
                Element element26 = new Element("property");
                element26.setAttribute("id", feature.getId());
                element26.setAttribute("lemma", feature.getLemma());
                List<Span<Term>> list19 = feature.getSpans();
                Element element27 = new Element("references");
                for (Span<Term> span5 : list19) {
                    Comment spanComment4 = new Comment(ReadWriteManager.cleanUnicode(feature.getSpanStr(span5)));
                    element27.addContent(spanComment4);
                    Element element28 = new Element("span");
                    for (Term term : span5.getTargets()) {
                        Element targetElem8 = new Element("target");
                        targetElem8.setAttribute("id", term.getId());
                        if (term == span5.getHead()) {
                            targetElem8.setAttribute("head", "yes");
                        }
                        element28.addContent(targetElem8);
                    }
                    element27.addContent(element28);
                }
                element26.addContent(element27);
                element25.addContent(element26);
            }
            element.addContent(element25);
        }
        if ((list6 = annotationContainer.getLayer(KAFDocument.Layer.CATEGORIES)).size() > 0) {
            Element categoriesElem = new Element("categories");
            for (Feature feature : list6) {
                Element element29 = new Element("category");
                element29.setAttribute("id", feature.getId());
                element29.setAttribute("lemma", feature.getLemma());
                List<Span<Term>> list20 = feature.getSpans();
                Element element30 = new Element("references");
                for (Span<Term> span6 : list20) {
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(feature.getSpanStr(span6)));
                    element30.addContent(comment);
                    Element element31 = new Element("span");
                    for (Term term : span6.getTargets()) {
                        Element targetElem9 = new Element("target");
                        targetElem9.setAttribute("id", term.getId());
                        if (term == span6.getHead()) {
                            targetElem9.setAttribute("head", "yes");
                        }
                        element31.addContent(targetElem9);
                    }
                    element30.addContent(element31);
                }
                element29.addContent(element30);
                categoriesElem.addContent(element29);
            }
            element.addContent(categoriesElem);
        }
        if (element.getChildren().size() > 0) {
            root.addContent(element);
        }
        if ((opinions = annotationContainer.getLayer(KAFDocument.Layer.OPINIONS)).size() > 0) {
            Element element32 = new Element("opinions");
            for (Opinion opinion : opinions) {
                Opinion.OpinionExpression expression;
                Opinion.OpinionTarget opTarget;
                Element element33 = new Element("opinion");
                element33.setAttribute("id", opinion.getId());
                Opinion.OpinionHolder opinionHolder = opinion.getOpinionHolder();
                if (opinionHolder != null) {
                    Element opinionHolderElem = new Element("opinion_holder");
                    if (opinionHolder.hasType()) {
                        opinionHolderElem.setAttribute("type", opinionHolder.getType());
                    }
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(opinion.getSpanStr(opinion.getOpinionHolder().getSpan())));
                    opinionHolderElem.addContent(comment);
                    List<Term> list21 = opinionHolder.getTerms();
                    Span<Term> span7 = opinionHolder.getSpan();
                    if (list21.size() > 0) {
                        Element element34 = new Element("span");
                        opinionHolderElem.addContent(element34);
                        for (Term target : list21) {
                            Element element35 = new Element("target");
                            element35.setAttribute("id", target.getId());
                            if (target == span7.getHead()) {
                                element35.setAttribute("head", "yes");
                            }
                            element34.addContent(element35);
                        }
                    }
                    element33.addContent(opinionHolderElem);
                }
                if ((opTarget = opinion.getOpinionTarget()) != null) {
                    Element opinionTargetElem = new Element("opinion_target");
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(opinion.getSpanStr(opinion.getOpinionTarget().getSpan())));
                    opinionTargetElem.addContent(comment);
                    List<Term> list22 = opTarget.getTerms();
                    Span<Term> span8 = opTarget.getSpan();
                    if (list22.size() > 0) {
                        Element spanElem9 = new Element("span");
                        opinionTargetElem.addContent(spanElem9);
                        for (Term term : list22) {
                            targetElem = new Element("target");
                            targetElem.setAttribute("id", term.getId());
                            if (term == span8.getHead()) {
                                targetElem.setAttribute("head", "yes");
                            }
                            spanElem9.addContent(targetElem);
                        }
                    }
                    element33.addContent(opinionTargetElem);
                }
                if ((expression = opinion.getOpinionExpression()) != null) {
                    Element element36 = new Element("opinion_expression");
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(opinion.getSpanStr(opinion.getOpinionExpression().getSpan())));
                    element36.addContent(comment);
                    if (expression.hasPolarity()) {
                        element36.setAttribute("polarity", expression.getPolarity());
                    }
                    if (expression.hasStrength()) {
                        element36.setAttribute("strength", expression.getStrength());
                    }
                    if (expression.hasSubjectivity()) {
                        element36.setAttribute("subjectivity", expression.getSubjectivity());
                    }
                    if (expression.hasSentimentSemanticType()) {
                        element36.setAttribute("sentiment_semantic_type", expression.getSentimentSemanticType());
                    }
                    if (expression.hasSentimentProductFeature()) {
                        element36.setAttribute("sentiment_product_feature", expression.getSentimentProductFeature());
                    }
                    List<Term> list23 = expression.getTerms();
                    span = expression.getSpan();
                    if (list23.size() > 0) {
                        Element spanElem10 = new Element("span");
                        element36.addContent(spanElem10);
                        for (Term target : list23) {
                            Element targetElem10 = new Element("target");
                            targetElem10.setAttribute("id", target.getId());
                            if (target == span.getHead()) {
                                targetElem10.setAttribute("head", "yes");
                            }
                            spanElem10.addContent(targetElem10);
                        }
                    }
                    element33.addContent(element36);
                }
                element32.addContent(element33);
            }
            root.addContent(element32);
        }
        if ((list5 = annotationContainer.getLayer(KAFDocument.Layer.RELATIONS)).size() > 0) {
            Element element37 = new Element("relations");
            for (Relation relation : list5) {
                Comment comment = new Comment(ReadWriteManager.cleanUnicode(relation.getStr()));
                element37.addContent(comment);
                Element relationElem = new Element("relation");
                relationElem.setAttribute("id", relation.getId());
                relationElem.setAttribute("from", relation.getFrom().getId());
                relationElem.setAttribute("to", relation.getTo().getId());
                if (relation.hasConfidence()) {
                    relationElem.setAttribute("confidence", String.valueOf(relation.getConfidence()));
                }
                element37.addContent(relationElem);
            }
            root.addContent(element37);
        }
        if ((list4 = annotationContainer.getLayer(KAFDocument.Layer.SRL)).size() > 0) {
            Element element38 = new Element("srl");
            for (Predicate predicate : list4) {
                List<ExternalRef> list24;
                Span<Term> span9;
                Comment predicateComment = new Comment(ReadWriteManager.cleanUnicode(predicate.getStr()));
                element38.addContent(predicateComment);
                Element predicateElem = new Element("predicate");
                predicateElem.setAttribute("id", predicate.getId());
                if (predicate.hasUri()) {
                    predicateElem.setAttribute("uri", predicate.getUri());
                }
                if (predicate.hasConfidence()) {
                    predicateElem.setAttribute("confidence", Float.toString(predicate.getConfidence()));
                }
                if ((span9 = predicate.getSpan()).getTargets().size() > 0) {
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(predicate.getSpanStr()));
                    Element element39 = new Element("span");
                    predicateElem.addContent(comment);
                    predicateElem.addContent(element39);
                    for (Term target : span9.getTargets()) {
                        Element element40 = new Element("target");
                        element40.setAttribute("id", target.getId());
                        if (target == span9.getHead()) {
                            element40.setAttribute("head", "yes");
                        }
                        element39.addContent(element40);
                    }
                }
                if ((list24 = predicate.getExternalRefs()).size() > 0) {
                    Element element41 = ReadWriteManager.externalReferencesToDOM(list24);
                    predicateElem.addContent(element41);
                }
                for (Predicate.Role role : predicate.getRoles()) {
                    List<ExternalRef> rExternalReferences;
                    Element roleElem = new Element("role");
                    roleElem.setAttribute("id", role.getId());
                    roleElem.setAttribute("semRole", role.getSemRole());
                    Span<Term> span10 = role.getSpan();
                    if (span10.getTargets().size() > 0) {
                        Comment spanComment7 = new Comment(ReadWriteManager.cleanUnicode(role.getStr()));
                        Element spanElem11 = new Element("span");
                        roleElem.addContent(spanComment7);
                        roleElem.addContent(spanElem11);
                        for (Term target : span10.getTargets()) {
                            Element targetElem11 = new Element("target");
                            targetElem11.setAttribute("id", target.getId());
                            if (target == span10.getHead()) {
                                targetElem11.setAttribute("head", "yes");
                            }
                            spanElem11.addContent(targetElem11);
                        }
                    }
                    if ((rExternalReferences = role.getExternalRefs()).size() > 0) {
                        Element externalReferencesElem4 = ReadWriteManager.externalReferencesToDOM(rExternalReferences);
                        roleElem.addContent(externalReferencesElem4);
                    }
                    predicateElem.addContent(roleElem);
                }
                element38.addContent(predicateElem);
            }
            root.addContent(element38);
        }
        if ((list3 = annotationContainer.getGroupIDs(KAFDocument.AnnotationType.TREE)).size() > 0) {
            Element element42 = new Element("constituency");
            for (String type : list3) {
                List<Annotation> trees = annotationContainer.getLayer(KAFDocument.Layer.CONSTITUENCY, type);
                for (Tree tree : trees) {
                    Element element43 = new Element("tree");
                    if (!tree.getType().equals("kaflib_default_group")) {
                        element43.setAttribute("type", tree.getType());
                    }
                    element42.addContent(element43);
                    LinkedList<NonTerminal> nonTerminals = new LinkedList<NonTerminal>();
                    LinkedList<Terminal> terminals = new LinkedList<Terminal>();
                    ArrayList<Edge> arrayList = new ArrayList<Edge>();
                    TreeNode rootNode = tree.getRoot();
                    ReadWriteManager.extractTreeNodes(rootNode, nonTerminals, terminals, arrayList);
                    Collections.sort(nonTerminals, new Comparator<NonTerminal>(){

                        @Override
                        public int compare(NonTerminal nt1, NonTerminal nt2) {
                            if (ReadWriteManager.cmpId(nt1.getId(), nt2.getId()) < 0) {
                                return -1;
                            }
                            if (nt1.getId().equals(nt2.getId())) {
                                return 0;
                            }
                            return 1;
                        }
                    });
                    Collections.sort(terminals, new Comparator<Terminal>(){

                        @Override
                        public int compare(Terminal t1, Terminal t2) {
                            if (ReadWriteManager.cmpId(t1.getId(), t2.getId()) < 0) {
                                return -1;
                            }
                            if (t1.getId().equals(t2.getId())) {
                                return 0;
                            }
                            return 1;
                        }
                    });
                    Comment ntCom = new Comment("Non-terminals");
                    element43.addContent(ntCom);
                    for (NonTerminal node : nonTerminals) {
                        Element nodeElem = new Element("nt");
                        nodeElem.setAttribute("id", node.getId());
                        nodeElem.setAttribute("label", node.getLabel());
                        element43.addContent(nodeElem);
                    }
                    Comment tCom = new Comment("Terminals");
                    element43.addContent(tCom);
                    for (Terminal node : terminals) {
                        Element nodeElem = new Element("t");
                        nodeElem.setAttribute("id", node.getId());
                        nodeElem.addContent(ReadWriteManager.createTermSpanElem(node.getSpan()));
                        Comment tStrCom = new Comment(ReadWriteManager.cleanUnicode(node.getStr()));
                        element43.addContent(tStrCom);
                        element43.addContent(nodeElem);
                    }
                    Comment edgeCom = new Comment("Tree edges");
                    element43.addContent(edgeCom);
                    for (Edge edge : arrayList) {
                        Element edgeElem = new Element("edge");
                        if (edge.id != null) {
                            edgeElem.setAttribute("id", edge.id);
                        }
                        edgeElem.setAttribute("from", edge.from);
                        edgeElem.setAttribute("to", edge.to);
                        if (edge.head) {
                            edgeElem.setAttribute("head", "yes");
                        }
                        element43.addContent(edgeElem);
                    }
                }
            }
            root.addContent(element42);
        }
        if ((list2 = annotationContainer.getLayer(KAFDocument.Layer.TEMPORAL_RELATIONS)).size() > 0) {
            Element element44 = new Element("temporalRelations");
            for (Annotation tempRel : list2) {
                if (tempRel instanceof TLink) {
                    TLink tLink = (TLink)tempRel;
                    Comment comment = new Comment(ReadWriteManager.cleanUnicode(tLink.getRelType() + "(" + tLink.getFrom().getId() + ", " + tLink.getTo().getId() + ")"));
                    element44.addContent(comment);
                    Element element45 = new Element("tlink");
                    element45.setAttribute("id", tLink.getId());
                    element45.setAttribute("from", tLink.getFrom().getId());
                    element45.setAttribute("to", tLink.getTo().getId());
                    element45.setAttribute("fromType", tLink.getFromType());
                    element45.setAttribute("toType", tLink.getToType());
                    element45.setAttribute("relType", tLink.getRelType());
                    element44.addContent(element45);
                    continue;
                }
                if (!(tempRel instanceof PredicateAnchor)) continue;
                PredicateAnchor predicateAnchor = (PredicateAnchor)tempRel;
                Element element46 = new Element("predicateAnchor");
                element46.setAttribute("id", predicateAnchor.getId());
                if (predicateAnchor.hasAnchorTime()) {
                    element46.setAttribute("anchorTime", predicateAnchor.getAnchorTime().getId());
                }
                if (predicateAnchor.hasBeginPoint()) {
                    element46.setAttribute("beginPoint", predicateAnchor.getBeginPoint().getId());
                }
                if (predicateAnchor.hasEndPoint()) {
                    element46.setAttribute("endPoint", predicateAnchor.getEndPoint().getId());
                }
                Element element47 = new Element("span");
                span = predicateAnchor.getSpan();
                for (Predicate predicate : span.getTargets()) {
                    targetElem = new Element("target");
                    targetElem.setAttribute("id", predicate.getId());
                    if (predicate == span.getHead()) {
                        targetElem.setAttribute("head", "yes");
                    }
                    element47.addContent(targetElem);
                }
                element46.addContent(element47);
                element44.addContent(element46);
            }
            root.addContent(element44);
        }
        if ((list = annotationContainer.getLayer(KAFDocument.Layer.CAUSAL_RELATIONS)).size() > 0) {
            Element cLinksElem = new Element("causalRelations");
            for (CLink cLink : list) {
                void var32_279;
                String string = "";
                if (cLink.hasRelType()) {
                    String string2 = string + cLink.getRelType();
                }
                String string3 = (String)var32_279 + "(" + cLink.getFrom().getId() + ", " + cLink.getTo().getId() + ")";
                Comment comment = new Comment(ReadWriteManager.cleanUnicode(string3));
                cLinksElem.addContent(comment);
                Element cLinkElem = new Element("clink");
                cLinkElem.setAttribute("id", cLink.getId());
                cLinkElem.setAttribute("from", cLink.getFrom().getId());
                cLinkElem.setAttribute("to", cLink.getTo().getId());
                if (cLink.hasRelType()) {
                    cLinkElem.setAttribute("relType", cLink.getRelType());
                }
                cLinksElem.addContent(cLinkElem);
            }
            root.addContent(cLinksElem);
        }
        if ((topics = annotationContainer.getLayer(KAFDocument.Layer.TOPICS)).size() > 0) {
            Element topicsElem = new Element("topics");
            for (Topic topic : topics) {
                Element element48 = new Element("topic");
                element48.setText(topic.getTopicValue());
                if (topic.hasSource()) {
                    element48.setAttribute("source", topic.getSource());
                }
                if (topic.hasMethod()) {
                    element48.setAttribute("method", topic.getMethod());
                }
                if (topic.hasURI()) {
                    element48.setAttribute("uri", topic.getURI());
                }
                if (topic.hasConfidence()) {
                    element48.setAttribute("confidence", Double.toString(topic.getConfidence().floatValue()));
                }
                topicsElem.addContent(element48);
            }
            root.addContent(topicsElem);
        }
        if ((statements = annotationContainer.getLayer(KAFDocument.Layer.ATTRIBUTION)).size() > 0) {
            Element element49 = new Element("attribution");
            for (Statement statement : statements) {
                Element statementElem = new Element("statement");
                statementElem.setAttribute("id", statement.getId());
                Statement.StatementTarget stTarget = statement.getTarget();
                Element element50 = new Element("statement_target");
                statementElem.addContent(element50);
                element50.addContent(ReadWriteManager.spanToDOM(stTarget.getSpan()));
                if (statement.hasSource().booleanValue()) {
                    Statement.StatementSource stSource = statement.getSource();
                    Element stSourceElem = new Element("statement_source");
                    statementElem.addContent(stSourceElem);
                    stSourceElem.addContent(ReadWriteManager.spanToDOM(stSource.getSpan()));
                }
                if (statement.hasCue().booleanValue()) {
                    Statement.StatementCue stCue = statement.getCue();
                    Element stCueElem = new Element("statement_cue");
                    statementElem.addContent(stCueElem);
                    stCueElem.addContent(ReadWriteManager.spanToDOM(stCue.getSpan()));
                }
                element49.addContent(statementElem);
            }
            root.addContent(element49);
        }
        Set<Element> set = annotationContainer.getUnknownLayers();
        for (Element element51 : set) {
            element51.detach();
            root.addContent(element51);
        }
        return doc;
    }

    private static <T extends IdentifiableAnnotation> Element spanToDOM(Span<T> span) {
        Element spanElem = new Element("span");
        for (IdentifiableAnnotation target : span.getTargets()) {
            Element targetElem = new Element("target");
            targetElem.setAttribute("id", target.getId());
            if (target == span.getHead()) {
                targetElem.setAttribute("head", "yes");
            }
            spanElem.addContent(targetElem);
        }
        return spanElem;
    }

    private static void termToDOM(Term term, boolean isComponent, Element termsElem) {
        List<ExternalRef> externalReferences;
        if (!isComponent) {
            Comment termComment = new Comment(ReadWriteManager.cleanUnicode(term.getStr()));
            termsElem.addContent(termComment);
        }
        String tag = isComponent ? "component" : "term";
        Element termElem = new Element(tag);
        termElem.setAttribute("id", term.getId());
        if (term.hasType()) {
            termElem.setAttribute("type", term.getType());
        }
        if (term.hasLemma()) {
            termElem.setAttribute("lemma", term.getLemma());
        }
        if (term.hasPos()) {
            termElem.setAttribute("pos", term.getPos());
        }
        if (term.hasMorphofeat()) {
            termElem.setAttribute("morphofeat", term.getMorphofeat());
        }
        if (term.hasHead()) {
            termElem.setAttribute("head", term.getHead().getId());
        }
        if (term.hasCase()) {
            termElem.setAttribute("case", term.getCase());
        }
        if (term.hasSentiment()) {
            Term.Sentiment sentiment = term.getSentiment();
            Element sentimentElem = ReadWriteManager.sentimentToDOM(sentiment);
            termElem.addContent(sentimentElem);
        }
        if (!isComponent) {
            Element spanElem = new Element("span");
            Span<WF> span = term.getSpan();
            for (WF target : term.getWFs()) {
                Element targetElem = new Element("target");
                targetElem.setAttribute("id", target.getId());
                if (target == span.getHead()) {
                    targetElem.setAttribute("head", "yes");
                }
                spanElem.addContent(targetElem);
            }
            termElem.addContent(spanElem);
            List<Term> components = term.getComponents();
            if (components.size() > 0) {
                for (Term component : components) {
                    ReadWriteManager.termToDOM(component, true, termElem);
                }
            }
        }
        if ((externalReferences = term.getExternalRefs()).size() > 0) {
            Element externalReferencesElem = ReadWriteManager.externalReferencesToDOM(externalReferences);
            termElem.addContent(externalReferencesElem);
        }
        termsElem.addContent(termElem);
    }

    private static void extractTreeNodes(TreeNode node, List<NonTerminal> nonTerminals, List<Terminal> terminals, List<Edge> edges) {
        if (node instanceof NonTerminal) {
            nonTerminals.add((NonTerminal)node);
            List<TreeNode> treeNodes = ((NonTerminal)node).getChildren();
            for (TreeNode child : treeNodes) {
                edges.add(new Edge(child, node));
                ReadWriteManager.extractTreeNodes(child, nonTerminals, terminals, edges);
            }
        } else {
            terminals.add((Terminal)node);
        }
    }

    private static Element externalReferencesToDOM(List<ExternalRef> externalRefs) {
        Element externalReferencesElem = new Element("externalReferences");
        for (ExternalRef externalRef : externalRefs) {
            Element externalRefElem = ReadWriteManager.externalRefToDOM(externalRef);
            externalReferencesElem.addContent(externalRefElem);
        }
        return externalReferencesElem;
    }

    private static Element externalRefToDOM(ExternalRef externalRef) {
        Element externalRefElem = new Element("externalRef");
        externalRefElem.setAttribute("resource", externalRef.getResource());
        if (externalRef.hasReference()) {
            externalRefElem.setAttribute("reference", externalRef.getReference());
        }
        if (externalRef.hasConfidence()) {
            externalRefElem.setAttribute("confidence", Float.toString(externalRef.getConfidence().floatValue()));
        }
        if (externalRef.hasReftype()) {
            externalRefElem.setAttribute("reftype", externalRef.getReftype());
        }
        if (externalRef.hasStatus()) {
            externalRefElem.setAttribute("status", externalRef.getStatus());
        }
        if (externalRef.hasSource()) {
            externalRefElem.setAttribute("source", externalRef.getSource());
        }
        if (externalRef.hasSentiment()) {
            Element sentimentElem = ReadWriteManager.sentimentToDOM(externalRef.getSentiment());
            externalRefElem.addContent(sentimentElem);
        }
        for (ExternalRef subExternalRef : externalRef.getExternalRefs()) {
            Element subExternalRefElem = ReadWriteManager.externalRefToDOM(subExternalRef);
            externalRefElem.addContent(subExternalRefElem);
        }
        return externalRefElem;
    }

    private static Element sentimentToDOM(Term.Sentiment sentiment) {
        Element sentimentElem = new Element("sentiment");
        if (sentiment.hasResource()) {
            sentimentElem.setAttribute("resource", sentiment.getResource());
        }
        if (sentiment.hasPolarity()) {
            sentimentElem.setAttribute("polarity", sentiment.getPolarity());
        }
        if (sentiment.hasStrength()) {
            sentimentElem.setAttribute("strength", sentiment.getStrength());
        }
        if (sentiment.hasSubjectivity()) {
            sentimentElem.setAttribute("subjectivity", sentiment.getSubjectivity());
        }
        if (sentiment.hasSentimentSemanticType()) {
            sentimentElem.setAttribute("sentiment_semantic_type", sentiment.getSentimentSemanticType());
        }
        if (sentiment.hasSentimentModifier()) {
            sentimentElem.setAttribute("sentiment_modifier", sentiment.getSentimentModifier());
        }
        if (sentiment.hasSentimentMarker()) {
            sentimentElem.setAttribute("sentiment_marker", sentiment.getSentimentMarker());
        }
        if (sentiment.hasSentimentProductFeature()) {
            sentimentElem.setAttribute("sentiment_product_feature", sentiment.getSentimentProductFeature());
        }
        return sentimentElem;
    }

    private static Element factValToDOM(Factuality.FactVal factVal) {
        Element factValElem = new Element("factVal");
        factValElem.setAttribute("value", factVal.getValue());
        factValElem.setAttribute("resource", factVal.getResource());
        if (factVal.hasSource()) {
            factValElem.setAttribute("source", factVal.getSource());
        }
        if (factVal.hasConfidence()) {
            factValElem.setAttribute("confidence", factVal.getConfidence().toString());
        }
        return factValElem;
    }

    private static int cmpId(String id1, String id2) {
        int nbr2;
        int nbr1 = ReadWriteManager.extractNumberFromId(id1);
        if (nbr1 < (nbr2 = ReadWriteManager.extractNumberFromId(id2))) {
            return -1;
        }
        if (nbr1 == nbr2) {
            return 0;
        }
        return 1;
    }

    private static int extractNumberFromId(String id) {
        Matcher matcher = Pattern.compile("^[a-z]*_?(\\d+)$").matcher(id);
        if (!matcher.find()) {
            throw new IllegalStateException("IdManager doesn't recognise the given id's (" + id + ") format. Should be [a-z]*_?[0-9]+");
        }
        return Integer.valueOf(matcher.group(1));
    }

    private static String cleanUnicode(String str) {
        return str.replaceAll("[\\x{02710}-\\x{FFFFF}]", "");
    }

    private static class Edge {
        String id;
        String from;
        String to;
        boolean head;

        Edge(TreeNode from, TreeNode to) {
            if (from.hasEdgeId()) {
                this.id = from.getEdgeId();
            }
            this.from = from.getId();
            this.to = to.getId();
            this.head = from.getHead();
        }
    }
}

