/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc;

import eus.ixa.ixa.pipe.nerc.Name;
import eus.ixa.ixa.pipe.nerc.NameFactory;
import eus.ixa.ixa.pipe.nerc.StatisticalNameFinder;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Opinion;
import ixa.kaflib.Span;
import ixa.kaflib.WF;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;

public class OpinionTargetExtractor {
    private NameFactory nameFactory;
    private StatisticalNameFinder oteExtractor;
    private String clearFeatures;

    public OpinionTargetExtractor(Properties properties) throws IOException {
        this.clearFeatures = properties.getProperty("clearFeatures");
        this.nameFactory = new NameFactory();
        this.oteExtractor = new StatisticalNameFinder(properties, this.nameFactory);
    }

    public final void annotateOTE(KAFDocument kaf) throws IOException {
        List sentences = kaf.getSentences();
        for (List sentence : sentences) {
            String[] tokens = new String[sentence.size()];
            String[] tokenIds = new String[sentence.size()];
            for (int i = 0; i < sentence.size(); ++i) {
                tokens[i] = ((WF)sentence.get(i)).getForm();
                tokenIds[i] = ((WF)sentence.get(i)).getId();
            }
            if (this.clearFeatures.equalsIgnoreCase("docstart") && tokens[0].startsWith("-DOCSTART-")) {
                this.oteExtractor.clearAdaptiveData();
            }
            List<Name> names = this.oteExtractor.getNames(tokens);
            for (Name name : names) {
                Integer startIndex = name.getSpan().getStart();
                Integer endIndex = name.getSpan().getEnd();
                List nameTerms = kaf.getTermsFromWFs(Arrays.asList(Arrays.copyOfRange(tokenIds, (int)startIndex, (int)endIndex)));
                Span neSpan = KAFDocument.newTermSpan((List)nameTerms);
                Opinion opinion = kaf.newOpinion();
                opinion.createOpinionTarget(neSpan);
            }
            if (!this.clearFeatures.equalsIgnoreCase("yes")) continue;
            this.oteExtractor.clearAdaptiveData();
        }
        this.oteExtractor.clearAdaptiveData();
    }

    public final String annotateOTEsToKAF(KAFDocument kaf) {
        return kaf.toString();
    }

    public final String annotateOTEsToOpenNLP(KAFDocument kaf) {
        StringBuilder sb = new StringBuilder();
        List sentences = kaf.getSentences();
        for (List sentence : sentences) {
            String[] tokens = new String[sentence.size()];
            String[] tokenIds = new String[sentence.size()];
            for (int i = 0; i < sentence.size(); ++i) {
                tokens[i] = ((WF)sentence.get(i)).getForm();
                tokenIds[i] = ((WF)sentence.get(i)).getId();
            }
            if (this.clearFeatures.equalsIgnoreCase("docstart") && tokens[0].startsWith("-DOCSTART-")) {
                this.oteExtractor.clearAdaptiveData();
            }
            opennlp.tools.util.Span[] statSpans = this.oteExtractor.nercToSpans(tokens);
            boolean isClearAdaptiveData = false;
            if (this.clearFeatures.equalsIgnoreCase("yes")) {
                isClearAdaptiveData = true;
            }
            opennlp.tools.util.Span[] allSpansArray = NameFinderME.dropOverlappingSpans((opennlp.tools.util.Span[])statSpans);
            NameSample nameSample = new NameSample(tokens, allSpansArray, isClearAdaptiveData);
            sb.append(nameSample.toString()).append("\n");
        }
        this.oteExtractor.clearAdaptiveData();
        return sb.toString();
    }
}

