/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.nerc.CLI;
import eus.ixa.ixa.pipe.nerc.OpinionTargetExtractor;
import ixa.kaflib.KAFDocument;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.ServerSocket;
import java.util.Properties;
import org.jdom2.JDOMException;

public class TargetExtractorServer {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    private String model = null;
    private String outputFormat = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public TargetExtractorServer(Properties properties) {
        super();
        port = Integer.parseInt(properties.getProperty("port"));
        this.model = properties.getProperty("model");
        this.outputFormat = properties.getProperty("outputFormat");
        socketServer = null;
        try {
            try {
                annotator = new OpinionTargetExtractor(properties);
                System.out.println("-> Trying to listen port... " + port);
                socketServer = new ServerSocket(port);
                while (true) lbl-1000:
                // 11 sources

                {
                    System.out.println("-> Connected and listening to port " + port);
                    activeSocket = socketServer.accept();
                    var6_8 = null;
                    try {
                        inFromClient = new DataInputStream(activeSocket.getInputStream());
                        var8_12 = null;
                        try {
                            outToClient = new DataOutputStream(new BufferedOutputStream(activeSocket.getOutputStream()));
                            var10_16 = null;
                            try {
                                System.out.println("-> Received a  connection from: " + activeSocket);
                                stringFromClient = this.getClientData(inFromClient);
                                kafToString = this.getAnnotations(annotator, stringFromClient);
                                this.sendDataToServer(outToClient, kafToString);
                            }
                            catch (Throwable var11_19) {
                                var10_16 = var11_19;
                                throw var11_19;
                            }
                            finally {
                                if (outToClient == null) ** GOTO lbl-1000
                                if (var10_16 != null) {
                                    try {
                                        outToClient.close();
                                    }
                                    catch (Throwable var11_18) {
                                        var10_16.addSuppressed(var11_18);
                                    }
                                }
                                outToClient.close();
                            }
                        }
                        catch (Throwable var9_15) {
                            var8_12 = var9_15;
                            throw var9_15;
                        }
                        finally {
                            if (inFromClient == null) ** GOTO lbl-1000
                            if (var8_12 != null) {
                                try {
                                    inFromClient.close();
                                }
                                catch (Throwable var9_14) {
                                    var8_12.addSuppressed(var9_14);
                                }
                            }
                            inFromClient.close();
                        }
                    }
                    catch (Throwable var7_11) {
                        var6_8 = var7_11;
                        throw var7_11;
                    }
                    finally {
                        if (activeSocket == null) continue;
                        if (var6_8 != null) {
                            try {
                                activeSocket.close();
                            }
                            catch (Throwable var7_10) {
                                var6_8.addSuppressed(var7_10);
                            }
                            continue;
                        }
                        activeSocket.close();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException | JDOMException e) {
                e.printStackTrace();
                System.out.println("closing tcp socket...");
                try {
                    socketServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var19_27) {
            System.out.println("closing tcp socket...");
            try {
                socketServer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw var19_27;
        }
    }

    private String getClientData(DataInputStream inFromClient) {
        StringBuilder stringFromClient = new StringBuilder();
        try {
            boolean endOfClientFile = inFromClient.readBoolean();
            String line = "";
            while (!endOfClientFile) {
                line = inFromClient.readUTF();
                stringFromClient.append(line).append("\n");
                endOfClientFile = inFromClient.readBoolean();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringFromClient.toString();
    }

    private void sendDataToServer(DataOutputStream outToClient, String kafToString) throws IOException {
        byte[] kafByteArray = kafToString.getBytes("UTF-8");
        outToClient.write(kafByteArray);
    }

    private String getAnnotations(OpinionTargetExtractor annotator, String stringFromClient) throws IOException, JDOMException {
        BufferedReader clientReader = new BufferedReader(new StringReader(stringFromClient));
        KAFDocument kaf = KAFDocument.createFromStream((Reader)clientReader);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("entities", "ixa-pipe-nerc-" + Files.getNameWithoutExtension((String)this.model), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        annotator.annotateOTE(kaf);
        newLp.setEndTimestamp();
        String kafToString = null;
        kafToString = this.outputFormat.equalsIgnoreCase("conll03") ? annotator.annotateOTEsToKAF(kaf) : (this.outputFormat.equalsIgnoreCase("conll02") ? annotator.annotateOTEsToKAF(kaf) : (this.outputFormat.equalsIgnoreCase("opennlp") ? annotator.annotateOTEsToOpenNLP(kaf) : annotator.annotateOTEsToKAF(kaf)));
        return kafToString;
    }
}

