/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.dict;

import eus.ixa.ixa.pipe.nerc.dict.ClarkCluster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class BrownCluster
implements SerializableArtifact {
    private static final Pattern tabPattern = Pattern.compile("\t");
    private Map<String, String> tokenToClusterMap = new HashMap<String, String>();

    public BrownCluster(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            String[] lineArray = tabPattern.split(line);
            if (lineArray.length == 3) {
                int freq = Integer.parseInt(lineArray[2]);
                if (freq <= 5) continue;
                String normalizedToken = ClarkCluster.dotInsideI.matcher(lineArray[1]).replaceAll("I");
                this.tokenToClusterMap.put(normalizedToken, lineArray[0].intern());
                continue;
            }
            if (lineArray.length != 2) continue;
            String normalizedToken = ClarkCluster.dotInsideI.matcher(lineArray[0]).replaceAll("I");
            this.tokenToClusterMap.put(normalizedToken, lineArray[1].intern());
        }
    }

    public String lookupToken(String string) {
        return this.tokenToClusterMap.get(string);
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<String, String> entry : this.tokenToClusterMap.entrySet()) {
            writer.write(entry.getKey() + "\t" + entry.getValue() + "\n");
        }
        ((Writer)writer).flush();
    }

    public Class<?> getArtifactSerializerClass() {
        return BrownClusterSerializer.class;
    }

    public static class BrownClusterSerializer
    implements ArtifactSerializer<BrownCluster> {
        public BrownCluster create(InputStream in) throws IOException, InvalidFormatException {
            return new BrownCluster(in);
        }

        public void serialize(BrownCluster artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

