/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.dict;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import eus.ixa.ixa.pipe.nerc.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Dictionaries {
    private static final Pattern tabPattern = Pattern.compile("\t");
    public static boolean DEBUG = false;
    private static List<String> dictNames;
    private static List<Map<String, String>> dictionaries;
    private static List<Map<String, String>> dictionariesIgnoreCase;

    public Dictionaries(String inputDir) {
        if (dictNames == null && dictionaries == null && dictionariesIgnoreCase == null) {
            try {
                this.loadDictionaries(inputDir);
            }
            catch (IOException e) {
                e.getMessage();
            }
        }
    }

    public final List<Map<String, String>> getDictionaries() {
        return dictionaries;
    }

    public final List<Map<String, String>> getIgnoreCaseDictionaries() {
        return dictionariesIgnoreCase;
    }

    public final List<String> getDictNames() {
        return dictNames;
    }

    private void loadDictionaries(String inputDir) throws IOException {
        List<File> fileList = StringUtils.getFilesInDir(new File(inputDir));
        dictNames = new ArrayList<String>(fileList.size());
        dictionaries = new ArrayList<Map<String, String>>(fileList.size());
        dictionariesIgnoreCase = new ArrayList<Map<String, String>>(fileList.size());
        System.err.println("\tloading dictionaries in " + inputDir + " directory");
        for (int i = 0; i < fileList.size(); ++i) {
            if (DEBUG) {
                System.err.println("\tloading dictionary:...." + fileList.get(i).getCanonicalPath());
            }
            dictNames.add(fileList.get(i).getCanonicalPath());
            dictionaries.add(new HashMap());
            dictionariesIgnoreCase.add(new HashMap());
            List fileLines = Files.readLines((File)fileList.get(i), (Charset)Charsets.UTF_8);
            for (String line : fileLines) {
                String[] lineArray = tabPattern.split(line);
                if (lineArray.length != 2) continue;
                dictionaries.get(i).put(lineArray[0], lineArray[1]);
                if (line.equalsIgnoreCase("in") || line.equalsIgnoreCase("on") || line.equalsIgnoreCase("us") || line.equalsIgnoreCase("or") || line.equalsIgnoreCase("am")) continue;
                dictionariesIgnoreCase.get(i).put(lineArray[0].toLowerCase(), lineArray[1]);
            }
        }
        System.err.println("found " + dictionaries.size() + " dictionaries");
    }
}

