/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.dict;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class LemmaResource
implements SerializableArtifact {
    private static final Pattern spacePattern = Pattern.compile("\t");
    private HashMap<List<String>, String> dictMap = new HashMap();

    public LemmaResource(InputStream in) throws IOException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = breader.readLine()) != null) {
                String[] elems = spacePattern.split(line);
                this.dictMap.put(Arrays.asList(elems[0], elems[2]), elems[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String lookUpLemma(String word, String postag) {
        String lemma = null;
        String constantTag = "NNP";
        List<String> keys = this.getDictKeys(word, postag);
        String keyValue = this.dictMap.get(keys);
        lemma = keyValue != null ? keyValue : (keyValue == null && postag.startsWith(String.valueOf(constantTag)) ? word : (keyValue == null && word.toUpperCase().equals(word) ? word : word.toLowerCase()));
        return lemma;
    }

    public List<String> lookUpLemmaArray(String[] tokens, String[] postags) {
        ArrayList<String> lemmas = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            String lemma = this.lookUpLemma(tokens[i], postags[i]);
            lemmas.add(lemma);
        }
        return lemmas;
    }

    private List<String> getDictKeys(String word, String postag) {
        String constantTag = "NNP";
        ArrayList<String> keys = new ArrayList<String>();
        if (postag.startsWith(String.valueOf(constantTag))) {
            keys.addAll(Arrays.asList(word, postag));
        } else {
            keys.addAll(Arrays.asList(word.toLowerCase(), postag));
        }
        return keys;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<List<String>, String> entry : this.dictMap.entrySet()) {
            writer.write(entry.getKey().get(0) + "\t" + entry.getValue() + "\t" + entry.getKey().get(1) + "\n");
        }
        ((Writer)writer).flush();
    }

    public Class<?> getArtifactSerializerClass() {
        return LemmaResourceSerializer.class;
    }

    public static class LemmaResourceSerializer
    implements ArtifactSerializer<LemmaResource> {
        public LemmaResource create(InputStream in) throws IOException, InvalidFormatException {
            return new LemmaResource(in);
        }

        public void serialize(LemmaResource artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

