/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.eval;

import eus.ixa.ixa.pipe.nerc.train.AbstractTrainer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderDetailedFMeasureListener;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;

public class Evaluate {
    private ObjectStream<NameSample> testSamples;
    private NameFinderME nameFinder;
    private static ConcurrentHashMap<String, TokenNameFinderModel> nercModels = new ConcurrentHashMap();

    public Evaluate(Properties props) throws IOException {
        String lang = props.getProperty("language");
        String clearFeatures = props.getProperty("clearFeatures");
        String model = props.getProperty("model");
        String testSet = props.getProperty("testset");
        String corpusFormat = props.getProperty("corpusFormat");
        String netypes = props.getProperty("types");
        this.testSamples = AbstractTrainer.getNameStream(testSet, clearFeatures, corpusFormat);
        if (netypes != "off") {
            String[] neTypes = netypes.split(",");
            this.testSamples = new NameSampleTypeFilter(neTypes, this.testSamples);
        }
        nercModels.putIfAbsent(lang, new TokenNameFinderModel((InputStream)new FileInputStream(model)));
        this.nameFinder = new NameFinderME(nercModels.get(lang));
    }

    public final void evaluate() throws IOException {
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator((TokenNameFinder)this.nameFinder, new TokenNameFinderEvaluationMonitor[0]);
        evaluator.evaluate(this.testSamples);
        System.out.println(evaluator.getFMeasure());
    }

    public final void detailEvaluate() throws IOException {
        LinkedList<TokenNameFinderDetailedFMeasureListener> listeners = new LinkedList<TokenNameFinderDetailedFMeasureListener>();
        TokenNameFinderDetailedFMeasureListener detailedFListener = new TokenNameFinderDetailedFMeasureListener();
        listeners.add(detailedFListener);
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator((TokenNameFinder)this.nameFinder, listeners.toArray(new TokenNameFinderEvaluationMonitor[listeners.size()]));
        evaluator.evaluate(this.testSamples);
        System.out.println(detailedFListener.toString());
    }

    public final void evalError() throws IOException {
        LinkedList<NameEvaluationErrorListener> listeners = new LinkedList<NameEvaluationErrorListener>();
        listeners.add(new NameEvaluationErrorListener());
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator((TokenNameFinder)this.nameFinder, listeners.toArray(new TokenNameFinderEvaluationMonitor[listeners.size()]));
        evaluator.evaluate(this.testSamples);
        System.out.println(evaluator.getFMeasure());
    }
}

