/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.features;

import eus.ixa.ixa.pipe.nerc.dict.LemmaResource;
import eus.ixa.ixa.pipe.nerc.dict.MFSResource;
import eus.ixa.ixa.pipe.nerc.dict.POSModelResource;
import eus.ixa.ixa.pipe.nerc.train.Flags;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class MFSFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private POSModelResource posModelResource;
    private LemmaResource lemmaDictResource;
    private MFSResource mfsDictResource;
    private String[] currentSentence;
    private String[] currentTags;
    private List<String> currentLemmas;
    private List<String> currentMFSList;
    private boolean isPos;
    private boolean isPosClass;
    private boolean isLemma;
    private boolean isMFS;
    private boolean isMonosemic;
    private boolean isBio;

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentTags = this.posModelResource.posTag(tokens);
            this.currentLemmas = this.lemmaDictResource.lookUpLemmaArray(tokens, this.currentTags);
            this.currentMFSList = this.isBio ? this.mfsDictResource.getFirstSenseBio(this.currentLemmas, this.currentTags) : this.mfsDictResource.getFirstSenseBilou(this.currentLemmas, this.currentTags);
        }
        String posTag = this.currentTags[index];
        if (this.isPos) {
            features.add("posTag=" + posTag);
        }
        if (this.isPosClass) {
            String posTagClass = posTag.substring(0, 1);
            features.add("posTagClass=" + posTagClass);
        }
        if (this.isLemma) {
            String lemma = this.currentLemmas.get(index);
            features.add("lemma=" + lemma);
        }
        if (this.isMFS) {
            String mfs = this.currentMFSList.get(index);
            features.add("mfs=" + mfs);
            features.add("mfs,lemma=" + mfs + "," + this.currentLemmas.get(index));
        }
        if (this.isMonosemic) {
            // empty if block
        }
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof POSModelResource)) {
            throw new InvalidFormatException("Not a POSModelResource for key: " + properties.get("model"));
        }
        this.posModelResource = (POSModelResource)posResource;
        Object lemmaResource = resourceProvider.getResource(properties.get("dict"));
        if (!(lemmaResource instanceof LemmaResource)) {
            throw new InvalidFormatException("Not a LemmaResource for key: " + properties.get("dict"));
        }
        this.lemmaDictResource = (LemmaResource)lemmaResource;
        Object mfsResource = resourceProvider.getResource(properties.get("mfs"));
        if (!(mfsResource instanceof MFSResource)) {
            throw new InvalidFormatException("Not a MFSResource for key: " + properties.get("mfs"));
        }
        this.mfsDictResource = (MFSResource)mfsResource;
        this.processRangeOptions(properties);
        this.isBio = !properties.get("seqCodec").equalsIgnoreCase("bilou");
    }

    private void processRangeOptions(Map<String, String> properties) {
        String featuresRange = properties.get("range");
        String[] rangeArray = Flags.processMFSFeaturesRange(featuresRange);
        if (rangeArray[0].equalsIgnoreCase("pos")) {
            this.isPos = true;
        }
        if (rangeArray[1].equalsIgnoreCase("posclass")) {
            this.isPosClass = true;
        }
        if (rangeArray[2].equalsIgnoreCase("lemma")) {
            this.isLemma = true;
        }
        if (rangeArray[3].equalsIgnoreCase("mfs")) {
            this.isMFS = true;
        }
        if (rangeArray[4].equalsIgnoreCase("monosemic")) {
            this.isMonosemic = true;
        }
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("posmodelserializer", new POSModelResource.POSModelResourceSerializer());
        mapping.put("lemmadictserializer", new LemmaResource.LemmaResourceSerializer());
        mapping.put("mfsdictserializer", new MFSResource.MFSResourceSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

