/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.features;

import eus.ixa.ixa.pipe.nerc.dict.LemmaResource;
import eus.ixa.ixa.pipe.nerc.dict.POSModelResource;
import eus.ixa.ixa.pipe.nerc.train.Flags;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class MorphoFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private POSModelResource posModelResource;
    private LemmaResource lemmaDictResource;
    private String[] currentSentence;
    private String[] currentTags;
    private List<String> currentLemmas;
    private boolean isPos;
    private boolean isPosClass;
    private boolean isLemma;

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentTags = this.posModelResource.posTag(tokens);
            this.currentLemmas = this.lemmaDictResource.lookUpLemmaArray(tokens, this.currentTags);
        }
        String posTag = this.currentTags[index];
        if (this.isPos) {
            features.add("posTag=" + posTag);
        }
        if (this.isPosClass) {
            String posTagClass = posTag.substring(0, 1);
            features.add("posTagClass=" + posTagClass);
        }
        if (this.isLemma) {
            String lemma = this.currentLemmas.get(index);
            features.add("lemma=" + lemma);
        }
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof POSModelResource)) {
            throw new InvalidFormatException("Not a POSModelResource for key: " + properties.get("model"));
        }
        this.posModelResource = (POSModelResource)posResource;
        Object lemmaResource = resourceProvider.getResource(properties.get("dict"));
        if (!(lemmaResource instanceof LemmaResource)) {
            throw new InvalidFormatException("Not a LemmaResource for key: " + properties.get("dict"));
        }
        this.lemmaDictResource = (LemmaResource)lemmaResource;
        this.processRangeOptions(properties);
    }

    private void processRangeOptions(Map<String, String> properties) {
        String featuresRange = properties.get("range");
        String[] rangeArray = Flags.processMorphoFeaturesRange(featuresRange);
        if (rangeArray[0].equalsIgnoreCase("pos")) {
            this.isPos = true;
        }
        if (rangeArray[1].equalsIgnoreCase("posclass")) {
            this.isPosClass = true;
        }
        if (rangeArray[2].equalsIgnoreCase("lemma")) {
            this.isLemma = true;
        }
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("posmodelserializer", new POSModelResource.POSModelResourceSerializer());
        mapping.put("lemmadictserializer", new LemmaResource.LemmaResourceSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

