/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.features;

import eus.ixa.ixa.pipe.nerc.dict.LemmaResource;
import eus.ixa.ixa.pipe.nerc.dict.MFSResource;
import eus.ixa.ixa.pipe.nerc.dict.POSModelResource;
import eus.ixa.ixa.pipe.nerc.features.WordShapeSuperSenseFeatureGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class SuperSenseFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private POSModelResource posModelResource;
    private LemmaResource lemmaDictResource;
    private MFSResource mfsDictResource;
    private String[] currentSentence;
    private String[] currentTags;
    private List<String> currentLemmas;
    private List<String> currentMFSList;
    private Boolean isBio = true;

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String firstCharCurTok;
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentTags = this.posModelResource.posTag(tokens);
            this.currentLemmas = this.lemmaDictResource.lookUpLemmaArray(tokens, this.currentTags);
            this.currentMFSList = this.isBio != false ? this.mfsDictResource.getFirstSenseBio(this.currentLemmas, this.currentTags) : this.mfsDictResource.getFirstSenseBilou(this.currentLemmas, this.currentTags);
        }
        String curLemma = this.currentLemmas.get(index);
        String curTok = tokens[index];
        String curPOS = this.currentTags[index];
        String curShape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index]);
        String firstSense = this.currentMFSList.get(index);
        String prevLabel = null;
        String prevShape = null;
        String prevPOS = null;
        String prevLemma = null;
        String nextShape = null;
        String nextPOS = null;
        String nextLemma = null;
        String prev2Shape = null;
        String prev2POS = null;
        String prev2Lemma = null;
        String next2Shape = null;
        String next2POS = null;
        String next2Lemma = null;
        if (index - 2 >= 0) {
            prev2Shape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index - 2]);
            prev2Lemma = this.currentLemmas.get(index - 2);
            prev2POS = this.currentTags[index - 2];
        }
        if (index - 1 >= 0) {
            prevShape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index - 1]);
            prevLemma = this.currentLemmas.get(index - 1);
            prevPOS = this.currentTags[index - 1];
            prevLabel = previousOutcomes[index - 1];
        }
        if (index + 1 < tokens.length) {
            nextShape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index + 1]);
            nextLemma = this.currentLemmas.get(index + 1);
            nextPOS = this.currentTags[index + 1];
        }
        if (index + 2 < tokens.length) {
            next2Shape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index + 2]);
            next2Lemma = this.currentLemmas.get(index + 2);
            next2POS = this.currentTags[index + 2];
        }
        features.add("bias");
        if (firstSense == null) {
            firstSense = "O";
        }
        features.add("firstSense=" + firstSense);
        features.add("firstSense,curTok=" + firstSense + "," + curLemma);
        if (prevLabel != null) {
            features.add("prevLabel=" + prevLabel);
        }
        if (curPOS.equals("NN") || curPOS.equals("NNS")) {
            features.add("curPOS_common");
        }
        if (curPOS.equals("NNP") || curPOS.equals("NNPS")) {
            features.add("curPOS_proper");
        }
        features.add("curTok=" + curLemma);
        features.add("curPOS=" + curPOS);
        features.add("curPOS_0" + curPOS.charAt(0));
        if (prevPOS != null) {
            features.add("prevTok=" + prevLemma);
            features.add("prevPOS=" + prevPOS);
            features.add("prevPOS_0=" + prevPOS.charAt(0));
        }
        if (nextPOS != null) {
            features.add("nextTok=" + nextLemma);
            features.add("nextPOS=" + nextPOS);
            features.add("nextPOS_0" + nextPOS.charAt(0));
        }
        if (prev2POS != null) {
            features.add("prev2Tok=" + prev2Lemma);
            features.add("prev2POS=" + prev2POS);
            features.add("prev2POS_0=" + prev2POS.charAt(0));
        }
        if (next2POS != null) {
            features.add("next2Tok=" + next2Lemma);
            features.add("next2POS=" + next2POS);
            features.add("next2POS_0=" + next2POS.charAt(0));
        }
        features.add("curShape=" + curShape);
        if (prevPOS != null) {
            features.add("prevShape=" + prevShape);
        }
        if (nextPOS != null) {
            features.add("nextShape=" + nextShape);
        }
        if (prev2POS != null) {
            features.add("prev2Shape=" + prev2Shape);
        }
        if (next2POS != null) {
            features.add("next2Shape=" + next2Shape);
        }
        if ((firstCharCurTok = curTok.substring(0, 1)).toLowerCase().equals(firstCharCurTok)) {
            features.add("curTokLowercase");
        } else if (index == 0) {
            features.add("curTokUpperCaseFirstChar");
        } else {
            features.add("curTokUpperCaseOther");
        }
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof POSModelResource)) {
            throw new InvalidFormatException("Not a POSModelResource for key: " + properties.get("model"));
        }
        this.posModelResource = (POSModelResource)posResource;
        Object lemmaResource = resourceProvider.getResource(properties.get("dict"));
        if (!(lemmaResource instanceof LemmaResource)) {
            throw new InvalidFormatException("Not a LemmaResource for key: " + properties.get("dict"));
        }
        this.lemmaDictResource = (LemmaResource)lemmaResource;
        Object mfsResource = resourceProvider.getResource(properties.get("mfs"));
        if (!(mfsResource instanceof MFSResource)) {
            throw new InvalidFormatException("Not a MFSResource for key: " + properties.get("mfs"));
        }
        this.mfsDictResource = (MFSResource)mfsResource;
        this.isBio = properties.get("seqCodec").equalsIgnoreCase("bilou") ? Boolean.valueOf(false) : Boolean.valueOf(true);
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("posmodelserializer", new POSModelResource.POSModelResourceSerializer());
        mapping.put("lemmadictserializer", new LemmaResource.LemmaResourceSerializer());
        mapping.put("mfsdictserializer", new MFSResource.MFSResourceSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

