/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.features;

import eus.ixa.ixa.pipe.nerc.StringUtils;
import eus.ixa.ixa.pipe.nerc.features.BigramClassFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.BrownBigramFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.BrownTokenClassFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.BrownTokenFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.CharacterNgramFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.ClarkFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.DictionaryFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.FivegramClassFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.FourgramClassFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.MFSFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.MorphoFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.OutcomePriorFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.Prefix34FeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.Prev2MapFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.PreviousMapFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.PreviousMapTokenFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.SentenceFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.SuffixFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.SuperSenseFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.TokenClassFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.TokenFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.TrigramClassFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.Word2VecClusterFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.features.WordShapeSuperSenseFeatureGenerator;
import eus.ixa.ixa.pipe.nerc.train.Flags;
import eus.ixa.ixa.pipe.nerc.train.InputOutputUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.TrainingParameters;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class XMLFeatureDescriptor {
    private static int leftWindow = -1;
    private static int rightWindow = -1;
    private static int minCharNgram = -1;
    private static int maxCharNgram = -1;

    private XMLFeatureDescriptor() {
    }

    public static int getLeftWindow() {
        return leftWindow;
    }

    public static int getRightWindow() {
        return rightWindow;
    }

    public static int getMinCharNgram() {
        return minCharNgram;
    }

    public static int getMaxCharNgram() {
        return maxCharNgram;
    }

    public static String createXMLFeatureDescriptor(TrainingParameters params) throws IOException {
        Element mfsClassFeatureElement;
        String seqCodec;
        String mfsRange;
        String[] mfsResources;
        String mfsPath;
        Element aggGenerators = new Element("generators");
        Document doc = new Document(aggGenerators);
        Element cached = new Element("cache");
        Element generators = new Element("generators");
        if (Flags.isTokenFeature(params)) {
            XMLFeatureDescriptor.setWindow(params);
            Element tokenFeature = new Element("custom");
            tokenFeature.setAttribute("class", TokenFeatureGenerator.class.getName());
            Element tokenWindow = new Element("window");
            tokenWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            tokenWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            tokenWindow.addContent((Content)tokenFeature);
            generators.addContent((Content)tokenWindow);
            System.err.println("-> Token features added!: Window range " + leftWindow + ":" + rightWindow);
        }
        if (Flags.isTokenClassFeature(params)) {
            XMLFeatureDescriptor.setWindow(params);
            Element tokenClassFeature = new Element("custom");
            tokenClassFeature.setAttribute("class", TokenClassFeatureGenerator.class.getName());
            Element tokenClassWindow = new Element("window");
            tokenClassWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            tokenClassWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            tokenClassWindow.addContent((Content)tokenClassFeature);
            generators.addContent((Content)tokenClassWindow);
            System.err.println("-> Token Class Features added!: Window range " + leftWindow + ":" + rightWindow);
        }
        if (Flags.isWordShapeSuperSenseFeature(params)) {
            XMLFeatureDescriptor.setWindow(params);
            Element wordShapeSuperSenseFeature = new Element("custom");
            wordShapeSuperSenseFeature.setAttribute("class", WordShapeSuperSenseFeatureGenerator.class.getName());
            Element wordShapeWindow = new Element("window");
            wordShapeWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            wordShapeWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            wordShapeWindow.addContent((Content)wordShapeSuperSenseFeature);
            generators.addContent((Content)wordShapeWindow);
            System.err.println("-> Word Shape SuperSense Features added!: Window range " + leftWindow + ":" + rightWindow);
        }
        if (Flags.isOutcomePriorFeature(params)) {
            Element outcomePriorFeature = new Element("custom");
            outcomePriorFeature.setAttribute("class", OutcomePriorFeatureGenerator.class.getName());
            generators.addContent((Content)outcomePriorFeature);
            System.err.println("-> Outcome Prior Features added!");
        }
        if (Flags.isPreviousMapFeature(params)) {
            Element previousMapFeature = new Element("custom");
            previousMapFeature.setAttribute("class", PreviousMapFeatureGenerator.class.getName());
            generators.addContent((Content)previousMapFeature);
            System.err.println("-> Previous Map Features added!");
        }
        if (Flags.isSentenceFeature(params)) {
            Element sentenceFeature = new Element("custom");
            sentenceFeature.setAttribute("class", SentenceFeatureGenerator.class.getName());
            sentenceFeature.setAttribute("begin", "true");
            sentenceFeature.setAttribute("end", "false");
            generators.addContent((Content)sentenceFeature);
            System.err.println("-> Sentence Features added!");
        }
        if (Flags.isPrefixFeature(params)) {
            Element prefixFeature = new Element("custom");
            prefixFeature.setAttribute("class", Prefix34FeatureGenerator.class.getName());
            generators.addContent((Content)prefixFeature);
            System.err.println("-> Prefix Features added!");
        }
        if (Flags.isSuffixFeature(params)) {
            Element suffixFeature = new Element("custom");
            suffixFeature.setAttribute("class", SuffixFeatureGenerator.class.getName());
            generators.addContent((Content)suffixFeature);
            System.err.println("-> Suffix Features added!");
        }
        if (Flags.isBigramClassFeature(params)) {
            Element bigramFeature = new Element("custom");
            bigramFeature.setAttribute("class", BigramClassFeatureGenerator.class.getName());
            generators.addContent((Content)bigramFeature);
            System.err.println("-> Bigram Class Features added!");
        }
        if (Flags.isTrigramClassFeature(params)) {
            Element trigramFeature = new Element("custom");
            trigramFeature.setAttribute("class", TrigramClassFeatureGenerator.class.getName());
            generators.addContent((Content)trigramFeature);
            System.err.println("-> Trigram Class Features added!");
        }
        if (Flags.isFourgramClassFeature(params)) {
            Element fourgramFeature = new Element("custom");
            fourgramFeature.setAttribute("class", FourgramClassFeatureGenerator.class.getName());
            generators.addContent((Content)fourgramFeature);
            System.err.println("-> Fourgram Class Features added!");
        }
        if (Flags.isFivegramClassFeature(params)) {
            Element fivegramFeature = new Element("custom");
            fivegramFeature.setAttribute("class", FivegramClassFeatureGenerator.class.getName());
            generators.addContent((Content)fivegramFeature);
            System.err.println("-> Fivegram Class Features added!");
        }
        if (Flags.isCharNgramClassFeature(params)) {
            XMLFeatureDescriptor.setNgramRange(params);
            Element charngramFeature = new Element("custom");
            charngramFeature.setAttribute("class", CharacterNgramFeatureGenerator.class.getName());
            charngramFeature.setAttribute("minLength", Integer.toString(minCharNgram));
            charngramFeature.setAttribute("maxLength", Integer.toString(maxCharNgram));
            generators.addContent((Content)charngramFeature);
            System.err.println("-> CharNgram Class Features added!");
        }
        if (Flags.isDictionaryFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String dictPath = Flags.getDictionaryFeatures(params);
            String seqCodec2 = Flags.getSequenceCodec(params);
            List<File> fileList = StringUtils.getFilesInDir(new File(dictPath));
            for (File dictFile : fileList) {
                Element dictFeatures = new Element("custom");
                dictFeatures.setAttribute("class", DictionaryFeatureGenerator.class.getName());
                dictFeatures.setAttribute("dict", InputOutputUtils.normalizeLexiconName(dictFile.getName()));
                dictFeatures.setAttribute("seqCodec", seqCodec2);
                Element dictWindow = new Element("window");
                dictWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                dictWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                dictWindow.addContent((Content)dictFeatures);
                generators.addContent((Content)dictWindow);
            }
            System.err.println("-> Dictionary Features added!");
        }
        if (Flags.isBrownFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            Element prev2MapFeature = new Element("custom");
            prev2MapFeature.setAttribute("class", Prev2MapFeatureGenerator.class.getName());
            generators.addContent((Content)prev2MapFeature);
            Element prevMapTokenFeature = new Element("custom");
            prevMapTokenFeature.setAttribute("class", PreviousMapTokenFeatureGenerator.class.getName());
            Element prevMapTokenWindow = new Element("window");
            prevMapTokenWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            prevMapTokenWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            prevMapTokenWindow.addContent((Content)prevMapTokenFeature);
            generators.addContent((Content)prevMapTokenWindow);
            String brownClusterPath = Flags.getBrownFeatures(params);
            List<File> brownClusterFiles = Flags.getClusterLexiconFiles(brownClusterPath);
            for (File brownClusterFile : brownClusterFiles) {
                Element brownBigramFeatures = new Element("custom");
                brownBigramFeatures.setAttribute("class", BrownBigramFeatureGenerator.class.getName());
                brownBigramFeatures.setAttribute("dict", InputOutputUtils.normalizeLexiconName(brownClusterFile.getName()));
                generators.addContent((Content)brownBigramFeatures);
                Element brownTokenFeature = new Element("custom");
                brownTokenFeature.setAttribute("class", BrownTokenFeatureGenerator.class.getName());
                brownTokenFeature.setAttribute("dict", InputOutputUtils.normalizeLexiconName(brownClusterFile.getName()));
                Element brownTokenWindow = new Element("window");
                brownTokenWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                brownTokenWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                brownTokenWindow.addContent((Content)brownTokenFeature);
                generators.addContent((Content)brownTokenWindow);
                Element brownTokenClassFeature = new Element("custom");
                brownTokenClassFeature.setAttribute("class", BrownTokenClassFeatureGenerator.class.getName());
                brownTokenClassFeature.setAttribute("dict", InputOutputUtils.normalizeLexiconName(brownClusterFile.getName()));
                Element brownTokenClassWindow = new Element("window");
                brownTokenClassWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                brownTokenClassWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                brownTokenClassWindow.addContent((Content)brownTokenClassFeature);
                generators.addContent((Content)brownTokenClassWindow);
            }
            System.err.println("-> Brown Cluster Features added!");
        }
        if (Flags.isClarkFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String clarkClusterPath = Flags.getClarkFeatures(params);
            List<File> clarkClusterFiles = Flags.getClusterLexiconFiles(clarkClusterPath);
            for (File clarkCluster : clarkClusterFiles) {
                Element clarkFeatures = new Element("custom");
                clarkFeatures.setAttribute("class", ClarkFeatureGenerator.class.getName());
                clarkFeatures.setAttribute("dict", InputOutputUtils.normalizeLexiconName(clarkCluster.getName()));
                Element clarkWindow = new Element("window");
                clarkWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                clarkWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                clarkWindow.addContent((Content)clarkFeatures);
                generators.addContent((Content)clarkWindow);
            }
            System.err.println("-> Clark Cluster Features added!");
        }
        if (Flags.isWord2VecClusterFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String word2vecClusterPath = Flags.getWord2VecClusterFeatures(params);
            List<File> word2vecClusterFiles = Flags.getClusterLexiconFiles(word2vecClusterPath);
            for (File word2vecFile : word2vecClusterFiles) {
                Element word2vecClusterFeatures = new Element("custom");
                word2vecClusterFeatures.setAttribute("class", Word2VecClusterFeatureGenerator.class.getName());
                word2vecClusterFeatures.setAttribute("dict", InputOutputUtils.normalizeLexiconName(word2vecFile.getName()));
                Element word2vecClusterWindow = new Element("window");
                word2vecClusterWindow.setAttribute("prevLength", Integer.toString(leftWindow));
                word2vecClusterWindow.setAttribute("nextLength", Integer.toString(rightWindow));
                word2vecClusterWindow.addContent((Content)word2vecClusterFeatures);
                generators.addContent((Content)word2vecClusterWindow);
            }
            System.err.println("-> Word2Vec Clusters Features added!");
        }
        if (Flags.isMorphoFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            String morphoPath = Flags.getMorphoFeatures(params);
            String[] morphoResources = Flags.getMorphoResources(morphoPath);
            String morphoRange = Flags.getMorphoFeaturesRange(params);
            Element morphoClassFeatureElement = new Element("custom");
            morphoClassFeatureElement.setAttribute("class", MorphoFeatureGenerator.class.getName());
            morphoClassFeatureElement.setAttribute("model", InputOutputUtils.normalizeLexiconName(new File(morphoResources[0]).getName()));
            morphoClassFeatureElement.setAttribute("dict", InputOutputUtils.normalizeLexiconName(new File(morphoResources[1]).getName()));
            morphoClassFeatureElement.setAttribute("range", morphoRange);
            Element morphoClassFeatureWindow = new Element("window");
            morphoClassFeatureWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            morphoClassFeatureWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            morphoClassFeatureWindow.addContent((Content)morphoClassFeatureElement);
            generators.addContent((Content)morphoClassFeatureWindow);
            System.err.println("-> Morphological Features added!");
        }
        if (Flags.isMFSFeatures(params)) {
            XMLFeatureDescriptor.setWindow(params);
            mfsPath = Flags.getMFSFeatures(params);
            mfsResources = Flags.getMFSResources(mfsPath);
            mfsRange = Flags.getMFSFeaturesRange(params);
            seqCodec = Flags.getSequenceCodec(params);
            mfsClassFeatureElement = new Element("custom");
            mfsClassFeatureElement.setAttribute("class", MFSFeatureGenerator.class.getName());
            mfsClassFeatureElement.setAttribute("model", InputOutputUtils.normalizeLexiconName(new File(mfsResources[0]).getName()));
            mfsClassFeatureElement.setAttribute("dict", InputOutputUtils.normalizeLexiconName(new File(mfsResources[1]).getName()));
            mfsClassFeatureElement.setAttribute("mfs", InputOutputUtils.normalizeLexiconName(new File(mfsResources[2]).getName()));
            mfsClassFeatureElement.setAttribute("range", mfsRange);
            mfsClassFeatureElement.setAttribute("seqCodec", seqCodec);
            Element mfsClassFeatureWindow = new Element("window");
            mfsClassFeatureWindow.setAttribute("prevLength", Integer.toString(leftWindow));
            mfsClassFeatureWindow.setAttribute("nextLength", Integer.toString(rightWindow));
            mfsClassFeatureWindow.addContent((Content)mfsClassFeatureElement);
            generators.addContent((Content)mfsClassFeatureWindow);
            System.err.println("-> MFS Features added");
        }
        if (Flags.isSuperSenseFeatures(params)) {
            mfsPath = Flags.getSuperSenseFeatures(params);
            mfsResources = Flags.getSuperSenseResources(mfsPath);
            mfsRange = Flags.getSuperSenseFeaturesRange(params);
            seqCodec = Flags.getSequenceCodec(params);
            mfsClassFeatureElement = new Element("custom");
            mfsClassFeatureElement.setAttribute("class", SuperSenseFeatureGenerator.class.getName());
            mfsClassFeatureElement.setAttribute("model", InputOutputUtils.normalizeLexiconName(new File(mfsResources[0]).getName()));
            mfsClassFeatureElement.setAttribute("dict", InputOutputUtils.normalizeLexiconName(new File(mfsResources[1]).getName()));
            mfsClassFeatureElement.setAttribute("mfs", InputOutputUtils.normalizeLexiconName(new File(mfsResources[2]).getName()));
            mfsClassFeatureElement.setAttribute("range", mfsRange);
            mfsClassFeatureElement.setAttribute("seqCodec", seqCodec);
            generators.addContent((Content)mfsClassFeatureElement);
            System.err.println("-> SuperSense Features added!");
        }
        aggGenerators.addContent((Content)cached);
        cached.addContent((Content)generators);
        XMLOutputter xmlOutput = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        xmlOutput.setFormat(format);
        return xmlOutput.outputString(doc);
    }

    public static void setWindow(TrainingParameters params) {
        if (leftWindow == -1 || rightWindow == -1) {
            leftWindow = XMLFeatureDescriptor.getWindowRange(params).get(0);
            rightWindow = XMLFeatureDescriptor.getWindowRange(params).get(1);
        }
    }

    private static List<Integer> getWindowRange(TrainingParameters params) {
        ArrayList<Integer> windowRange = new ArrayList<Integer>();
        String windowParam = Flags.getWindow(params);
        String[] windowArray = windowParam.split("[ :-]");
        if (windowArray.length == 2) {
            windowRange.add(Integer.parseInt(windowArray[0]));
            windowRange.add(Integer.parseInt(windowArray[1]));
        }
        return windowRange;
    }

    public static void setNgramRange(TrainingParameters params) {
        if (minCharNgram == -1 || maxCharNgram == -1) {
            minCharNgram = XMLFeatureDescriptor.getNgramRange(params).get(0);
            maxCharNgram = XMLFeatureDescriptor.getNgramRange(params).get(1);
        }
    }

    public static List<Integer> getNgramRange(TrainingParameters params) {
        ArrayList<Integer> ngramRange = new ArrayList<Integer>();
        String charNgramParam = Flags.getCharNgramFeaturesRange(params);
        String[] charngramArray = charNgramParam.split("[ :-]");
        if (charngramArray.length == 2) {
            ngramRange.add(Integer.parseInt(charngramArray[0]));
            ngramRange.add(Integer.parseInt(charngramArray[1]));
        }
        return ngramRange;
    }
}

