/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.train;

import eus.ixa.ixa.pipe.nerc.formats.CoNLL02Format;
import eus.ixa.ixa.pipe.nerc.formats.CoNLL03Format;
import eus.ixa.ixa.pipe.nerc.train.Flags;
import eus.ixa.ixa.pipe.nerc.train.InputOutputUtils;
import eus.ixa.ixa.pipe.nerc.train.Trainer;
import java.io.IOException;
import opennlp.tools.namefind.BilouCodec;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractTrainer
implements Trainer {
    private String lang;
    private String trainData;
    private String testData;
    private ObjectStream<NameSample> trainSamples;
    private ObjectStream<NameSample> testSamples;
    private String corpusFormat;
    private int beamSize;
    private String sequenceCodec;
    private String clearTrainingFeatures;
    private String clearEvaluationFeatures;
    private TokenNameFinderFactory nameClassifierFactory;

    public AbstractTrainer(TrainingParameters params) throws IOException {
        this.lang = Flags.getLanguage(params);
        this.clearTrainingFeatures = Flags.getClearTrainingFeatures(params);
        this.clearEvaluationFeatures = Flags.getClearEvaluationFeatures(params);
        this.corpusFormat = Flags.getCorpusFormat(params);
        this.trainData = (String)params.getSettings().get("TrainSet");
        this.testData = (String)params.getSettings().get("TestSet");
        this.trainSamples = AbstractTrainer.getNameStream(this.trainData, this.clearTrainingFeatures, this.corpusFormat);
        this.testSamples = AbstractTrainer.getNameStream(this.testData, this.clearEvaluationFeatures, this.corpusFormat);
        this.beamSize = Flags.getBeamsize(params);
        this.sequenceCodec = Flags.getSequenceCodec(params);
        if (params.getSettings().get("Types") != null) {
            String netypes = (String)params.getSettings().get("Types");
            String[] neTypes = netypes.split(",");
            this.trainSamples = new NameSampleTypeFilter(neTypes, this.trainSamples);
            this.testSamples = new NameSampleTypeFilter(neTypes, this.testSamples);
        }
    }

    @Override
    public final TokenNameFinderModel train(TrainingParameters params) {
        if (this.getNameClassifierFactory() == null) {
            throw new IllegalStateException("Classes derived from AbstractNameFinderTrainer must create and fill the AdaptiveFeatureGenerator features!");
        }
        TokenNameFinderModel trainedModel = null;
        TokenNameFinderEvaluator nerEvaluator = null;
        try {
            trainedModel = NameFinderME.train((String)this.lang, null, this.trainSamples, (TrainingParameters)params, (TokenNameFinderFactory)this.nameClassifierFactory);
            NameFinderME nerTagger = new NameFinderME(trainedModel);
            nerEvaluator = new TokenNameFinderEvaluator((TokenNameFinder)nerTagger, new TokenNameFinderEvaluationMonitor[0]);
            nerEvaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            System.err.println("IO error while loading traing and test sets!");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Final Result: \n" + nerEvaluator.getFMeasure());
        return trainedModel;
    }

    public static ObjectStream<NameSample> getNameStream(String inputData, String clearFeatures, String aCorpusFormat) throws IOException {
        Object samples = null;
        if (aCorpusFormat.equalsIgnoreCase("conll03")) {
            ObjectStream<String> nameStream = InputOutputUtils.readFileIntoMarkableStreamFactory(inputData);
            samples = new CoNLL03Format(clearFeatures, nameStream);
        } else if (aCorpusFormat.equalsIgnoreCase("conll02")) {
            ObjectStream<String> nameStream = InputOutputUtils.readFileIntoMarkableStreamFactory(inputData);
            samples = new CoNLL02Format(clearFeatures, nameStream);
        } else if (aCorpusFormat.equalsIgnoreCase("opennlp")) {
            ObjectStream<String> nameStream = InputOutputUtils.readFileIntoMarkableStreamFactory(inputData);
            samples = new NameSampleDataStream(nameStream);
        } else {
            System.err.println("Test set corpus format not valid!!");
            System.exit(1);
        }
        return samples;
    }

    public final TokenNameFinderFactory getNameClassifierFactory() {
        return this.nameClassifierFactory;
    }

    public final TokenNameFinderFactory setNameClassifierFactory(TokenNameFinderFactory tokenNameFinderFactory) {
        this.nameClassifierFactory = tokenNameFinderFactory;
        return this.nameClassifierFactory;
    }

    public final String getLanguage() {
        return this.lang;
    }

    public final void setLanguage(String aLang) {
        this.lang = aLang;
    }

    public final String getSequenceCodec() {
        String seqCodec = null;
        if ("BIO".equals(this.sequenceCodec)) {
            seqCodec = BioCodec.class.getName();
        } else if ("BILOU".equals(this.sequenceCodec)) {
            seqCodec = BilouCodec.class.getName();
        }
        return seqCodec;
    }

    public final void setSequenceCodec(String aSeqCodec) {
        this.sequenceCodec = aSeqCodec;
    }

    public final int getBeamSize() {
        return this.beamSize;
    }
}

