/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.opinion;

import eus.ixa.ixa.pipe.ml.StatisticalDocumentClassifier;
import eus.ixa.ixa.pipe.ml.StatisticalSequenceLabeler;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabel;
import eus.ixa.ixa.pipe.opinion.Annotate;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Opinion;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import ixa.kaflib.WF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class AnnotateAbsa
implements Annotate {
    private StatisticalSequenceLabeler oteExtractor;
    private StatisticalDocumentClassifier polTagger;
    private String clearFeatures;

    public AnnotateAbsa(Properties oteProperties, Properties polProperties) throws IOException {
        this.clearFeatures = oteProperties.getProperty("clearFeatures");
        this.oteExtractor = new StatisticalSequenceLabeler(oteProperties);
        this.polTagger = new StatisticalDocumentClassifier(polProperties);
    }

    @Override
    public final void annotate(KAFDocument kaf) {
        List sentences = kaf.getSentences();
        for (List sentence : sentences) {
            String[] tokens = new String[sentence.size()];
            String[] tokenIds = new String[sentence.size()];
            for (int i = 0; i < sentence.size(); ++i) {
                tokens[i] = ((WF)sentence.get(i)).getForm();
                tokenIds[i] = ((WF)sentence.get(i)).getId();
            }
            if (this.clearFeatures.equalsIgnoreCase("docstart") && tokens[0].startsWith("-DOCSTART-")) {
                this.oteExtractor.clearAdaptiveData();
                this.polTagger.clearFeatureData();
            }
            List names = this.oteExtractor.getSequences(tokens);
            for (SequenceLabel name : names) {
                Integer startIndex = name.getSpan().getStart();
                Integer endIndex = name.getSpan().getEnd();
                List nameTerms = kaf.getTermsFromWFs(Arrays.asList(Arrays.copyOfRange(tokenIds, (int)startIndex, (int)endIndex)));
                Span oteSpan = KAFDocument.newTermSpan((List)nameTerms);
                String polarity = this.polTagger.classify(tokens);
                List polarityTerms = kaf.getTermsFromWFs(Arrays.asList(Arrays.copyOfRange(tokenIds, 0, tokens.length)));
                Span polaritySpan = KAFDocument.newTermSpan((List)polarityTerms);
                Opinion opinion = kaf.newOpinion();
                opinion.createOpinionTarget(oteSpan);
                Opinion.OpinionExpression opExpression = opinion.createOpinionExpression(polaritySpan);
                opExpression.setSentimentProductFeature(name.getType());
                opExpression.setPolarity(polarity);
            }
            if (!this.clearFeatures.equalsIgnoreCase("yes")) continue;
            this.oteExtractor.clearAdaptiveData();
            this.polTagger.clearFeatureData();
        }
        this.oteExtractor.clearAdaptiveData();
        this.polTagger.clearFeatureData();
    }

    @Override
    public final String annotateToNAF(KAFDocument kaf) {
        return kaf.toString();
    }

    private String[] getTokensFromTerms(List<Term> terms) {
        ArrayList<String> tokensList = new ArrayList<String>();
        for (Term term : terms) {
            tokensList.add(term.getForm());
        }
        return tokensList.toArray(new String[tokensList.size()]);
    }
}

