/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.opinion;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.ml.StatisticalDocumentClassifier;
import eus.ixa.ixa.pipe.ml.polarity.DictionaryPolarityTagger;
import eus.ixa.ixa.pipe.opinion.Annotate;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Opinion;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import ixa.kaflib.WF;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class AnnotatePolarity
implements Annotate {
    private StatisticalDocumentClassifier polTagger;
    private DictionaryPolarityTagger dictTagger;
    private Boolean isDict = false;
    private String dictionary = null;
    private String clearFeatures;

    public AnnotatePolarity(Properties properties) throws IOException {
        this.clearFeatures = properties.getProperty("clearFeatures");
        this.dictionary = properties.getProperty("dictionary");
        if (!this.dictionary.equalsIgnoreCase("off")) {
            this.dictTagger = new DictionaryPolarityTagger((InputStream)new FileInputStream(this.dictionary));
            this.isDict = true;
        }
        this.polTagger = new StatisticalDocumentClassifier(properties);
    }

    @Override
    public final void annotate(KAFDocument kaf) {
        List sentences = kaf.getSentences();
        List terms = kaf.getTerms();
        for (List sentence : sentences) {
            String[] tokens = new String[sentence.size()];
            String[] tokenIds = new String[sentence.size()];
            for (int i = 0; i < sentence.size(); ++i) {
                tokens[i] = ((WF)sentence.get(i)).getForm();
                tokenIds[i] = ((WF)sentence.get(i)).getId();
            }
            if (this.isDict.booleanValue()) {
                for (Term term : terms) {
                    String polarity = this.dictTagger.tag(term.getForm());
                    if (polarity.equalsIgnoreCase("O")) {
                        polarity = this.dictTagger.tag(term.getLemma());
                    }
                    if (polarity.equalsIgnoreCase("O")) continue;
                    Term.Sentiment sentiment = term.createSentiment();
                    sentiment.setPolarity(polarity);
                    sentiment.setResource(Files.getNameWithoutExtension((String)this.dictionary));
                }
            }
            if (this.clearFeatures.equalsIgnoreCase("docstart") && tokens[0].startsWith("-DOCSTART-")) {
                this.polTagger.clearFeatureData();
            }
            String polarity = this.polTagger.classify(tokens);
            List polarityTerms = kaf.getTermsFromWFs(Arrays.asList(Arrays.copyOfRange(tokenIds, 0, tokens.length)));
            Span polaritySpan = KAFDocument.newTermSpan((List)polarityTerms);
            Opinion opinion = kaf.newOpinion();
            Opinion.OpinionExpression opExpression = opinion.createOpinionExpression(polaritySpan);
            opExpression.setPolarity(polarity);
            if (!this.clearFeatures.equalsIgnoreCase("yes")) continue;
            this.polTagger.clearFeatureData();
        }
        this.polTagger.clearFeatureData();
    }

    @Override
    public final String annotateToNAF(KAFDocument kaf) {
        return kaf.toString();
    }

    public final String annotatePolarityToTabulated(KAFDocument kaf) {
        return kaf.toString();
    }
}

