/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.opinion;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.opinion.Annotate;
import eus.ixa.ixa.pipe.opinion.AnnotateAbsa;
import eus.ixa.ixa.pipe.opinion.AnnotatePolarity;
import eus.ixa.ixa.pipe.opinion.AnnotateTargets;
import eus.ixa.ixa.pipe.opinion.DocAnnotateAspects;
import eus.ixa.ixa.pipe.opinion.OpinionTaggerServer;
import eus.ixa.ixa.pipe.opinion.SeqAnnotateAspects;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.jdom2.JDOMException;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    private Namespace parsedArguments = null;
    private ArgumentParser argParser = ArgumentParsers.newArgumentParser((String)("ixa-pipe-opinion-" + this.version + "-exec.jar")).description("ixa-pipe-opinion-" + this.version + " is a multilingual opinion tagger developed by IXA NLP Group.\n");
    private Subparsers subParsers = this.argParser.addSubparsers().help("sub-command help");
    private Subparser absaParser = this.subParsers.addParser("absa").help("ABSA Tagging CLI");
    private Subparser oteParser;
    private Subparser aspectParser;
    private Subparser polarityParser;
    private Subparser serverParser;
    private Subparser clientParser;
    private static final String ABSA_PARSER_NAME = "absa";
    private static final String OTE_PARSER_NAME = "ote";
    private static final String ASPECT_PARSER_NAME = "aspect";
    private static final String POLARITY_PARSER_NAME = "pol";
    private static final String SERVER_PARSER_NAME = "server";
    private static final String CLIENT_PARSER_NAME = "client";

    public CLI() {
        this.loadAbsaParameters();
        this.oteParser = this.subParsers.addParser(OTE_PARSER_NAME).help("OTE Tagging CLI");
        this.loadOteParameters();
        this.aspectParser = this.subParsers.addParser(ASPECT_PARSER_NAME).help("Aspect Tagging CLI");
        this.loadAspectParameters();
        this.polarityParser = this.subParsers.addParser(POLARITY_PARSER_NAME).help("Polarity tagging parser");
        this.loadPolarityParameters();
        this.serverParser = this.subParsers.addParser(SERVER_PARSER_NAME).help("Start TCP socket server");
        this.loadServerParameters();
        this.clientParser = this.subParsers.addParser(CLIENT_PARSER_NAME).help("Send queries to the TCP socket server");
        this.loadClientParameters();
    }

    public static void main(String[] args) throws IOException, JDOMException {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    public final void parseCLI(String[] args) throws IOException, JDOMException {
        try {
            this.parsedArguments = this.argParser.parseArgs(args);
            System.err.println("CLI options: " + this.parsedArguments);
            switch (args[0]) {
                case "absa": {
                    this.absa(System.in, System.out);
                    break;
                }
                case "ote": {
                    this.extractOte(System.in, System.out);
                    break;
                }
                case "aspect": {
                    this.extractAspects(System.in, System.out);
                    break;
                }
                case "pol": {
                    this.extractPolarity(System.in, System.out);
                    break;
                }
                case "server": {
                    this.server();
                    break;
                }
                case "client": {
                    this.client(System.in, System.out);
                }
            }
        }
        catch (ArgumentParserException e) {
            this.argParser.handleError(e);
            System.out.println("Run java -jar target/ixa-pipe-opinion-" + this.version + ".jar (absa|aspect|ote|pol|server|client) -help for details");
            System.exit(1);
        }
    }

    public final void absa(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream((Reader)breader);
        String targetModel = this.parsedArguments.getString("targetModel");
        String polarityModel = this.parsedArguments.getString("polarityModel");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String dictionary = this.parsedArguments.getString("dictionary");
        String lang = null;
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
                System.exit(1);
            }
        } else {
            lang = kaf.getLang();
        }
        Properties oteProperties = this.setOteProperties(targetModel, lang, clearFeatures);
        Properties polProperties = this.setPolarityProperties(polarityModel, dictionary, lang, clearFeatures);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("opinions", "ixa-pipe-opinion-" + Files.getNameWithoutExtension((String)targetModel), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        AnnotateAbsa absaAnnotator = new AnnotateAbsa(oteProperties, polProperties);
        absaAnnotator.annotate(kaf);
        newLp.setEndTimestamp();
        String kafToString = null;
        kafToString = outputFormat.equalsIgnoreCase("tabulated") ? absaAnnotator.annotateToNAF(kaf) : absaAnnotator.annotateToNAF(kaf);
        bwriter.write(kafToString);
        bwriter.close();
        breader.close();
    }

    public final void extractOte(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream((Reader)breader);
        String model = this.parsedArguments.getString("model");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String lang = null;
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
                System.exit(1);
            }
        } else {
            lang = kaf.getLang();
        }
        Properties properties = this.setOteProperties(model, lang, clearFeatures);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("opinions", "ixa-pipe-opinion-" + Files.getNameWithoutExtension((String)model), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        AnnotateTargets oteExtractor = new AnnotateTargets(properties);
        oteExtractor.annotate(kaf);
        newLp.setEndTimestamp();
        String kafToString = null;
        kafToString = outputFormat.equalsIgnoreCase("tabulated") ? oteExtractor.annotateToNAF(kaf) : oteExtractor.annotateToNAF(kaf);
        bwriter.write(kafToString);
        bwriter.close();
        breader.close();
    }

    public final void extractAspects(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream((Reader)breader);
        String tagger = this.parsedArguments.getString("tagger");
        String model = this.parsedArguments.getString("model");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String lang = null;
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
                System.exit(1);
            }
        } else {
            lang = kaf.getLang();
        }
        Properties properties = this.setAspectProperties(tagger, model, lang, clearFeatures);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("opinions", "ixa-pipe-opinion-" + Files.getNameWithoutExtension((String)model), this.version + "-" + this.commit);
        Annotate aspectExtractor = null;
        aspectExtractor = tagger.equalsIgnoreCase("doc") ? new DocAnnotateAspects(properties) : new SeqAnnotateAspects(properties);
        newLp.setBeginTimestamp();
        aspectExtractor.annotate(kaf);
        newLp.setEndTimestamp();
        String kafToString = null;
        kafToString = outputFormat.equalsIgnoreCase("tabulated") ? aspectExtractor.annotateToNAF(kaf) : aspectExtractor.annotateToNAF(kaf);
        bwriter.write(kafToString);
        bwriter.close();
        breader.close();
    }

    public final void extractPolarity(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream((Reader)breader);
        String model = this.parsedArguments.getString("model");
        String dictionary = this.parsedArguments.getString("dictionary");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String lang = null;
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
                System.exit(1);
            }
        } else {
            lang = kaf.getLang();
        }
        Properties properties = this.setPolarityProperties(model, dictionary, lang, clearFeatures);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("opinions", "ixa-pipe-opinion-" + Files.getNameWithoutExtension((String)model), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        AnnotatePolarity polarityExtractor = new AnnotatePolarity(properties);
        polarityExtractor.annotate(kaf);
        newLp.setEndTimestamp();
        String kafToString = null;
        kafToString = outputFormat.equalsIgnoreCase("tabulated") ? polarityExtractor.annotatePolarityToTabulated(kaf) : polarityExtractor.annotateToNAF(kaf);
        bwriter.write(kafToString);
        bwriter.close();
        breader.close();
    }

    public final void server() throws IOException {
        String port = this.parsedArguments.getString("port");
        String model = this.parsedArguments.getString("model");
        String clearFeatures = this.parsedArguments.getString("clearFeatures");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String lang = this.parsedArguments.getString("language");
        Properties serverproperties = this.setAbsaServerProperties(port, model, lang, clearFeatures, outputFormat);
        new OpinionTaggerServer(serverproperties);
    }

    public final void client(InputStream inputStream, OutputStream outputStream) {
        String host = this.parsedArguments.getString("host");
        String port = this.parsedArguments.getString("port");
        try (Socket socketClient = new Socket(host, Integer.parseInt(port));
             BufferedReader inFromUser = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
             BufferedWriter outToUser = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
             BufferedWriter outToServer = new BufferedWriter(new OutputStreamWriter(socketClient.getOutputStream(), "UTF-8"));
             BufferedReader inFromServer = new BufferedReader(new InputStreamReader(socketClient.getInputStream(), "UTF-8"));){
            String kafString;
            String line;
            StringBuilder inText = new StringBuilder();
            while ((line = inFromUser.readLine()) != null) {
                inText.append(line).append("\n");
            }
            inText.append("<ENDOFDOCUMENT>").append("\n");
            outToServer.write(inText.toString());
            outToServer.flush();
            StringBuilder sb = new StringBuilder();
            while ((kafString = inFromServer.readLine()) != null) {
                sb.append(kafString).append("\n");
            }
            outToUser.write(sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (UnknownHostException e) {
            System.err.println("ERROR: Unknown hostname or IP address!");
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println("Port number not correct!");
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadAbsaParameters() {
        this.absaParser.addArgument(new String[]{"-t", "--targetModel"}).required(true).help("Pass the Opinion Target model.\n");
        this.absaParser.addArgument(new String[]{"-p", "--polarityModel"}).required(true).help("Pass the polarity classification model.\n");
        this.absaParser.addArgument(new String[]{"--clearFeatures"}).required(false).choices((Object[])new String[]{"yes", "no", "docstart"}).setDefault((Object)"no").help("Reset the adaptive features every sentence; defaults to 'no'; if -DOCSTART- marks are present, choose 'docstart'.\n");
        this.absaParser.addArgument(new String[]{"-l", "--language"}).required(false).choices((Object[])new String[]{"en", "es", "fr", "nl", "ru", "tr"}).help("Choose language; it defaults to the language value in incoming NAF file.\n");
        this.absaParser.addArgument(new String[]{"-o", "--outputFormat"}).required(false).choices((Object[])new String[]{"naf", "tabulated"}).setDefault((Object)"naf").help("Choose output format; it defaults to NAF.\n");
        this.absaParser.addArgument(new String[]{"-d", "--dictionary"}).required(false).setDefault((Object)"off").help("Provide polarity lexicon to tag polarity at token/lemma level.\n");
    }

    private void loadOteParameters() {
        this.oteParser.addArgument(new String[]{"-m", "--model"}).required(true).help("Pass the model to do the tagging as a parameter.\n");
        this.oteParser.addArgument(new String[]{"--clearFeatures"}).required(false).choices((Object[])new String[]{"yes", "no", "docstart"}).setDefault((Object)"no").help("Reset the adaptive features every sentence; defaults to 'no'; if -DOCSTART- marks are present, choose 'docstart'.\n");
        this.oteParser.addArgument(new String[]{"-l", "--language"}).required(false).choices((Object[])new String[]{"en"}).help("Choose language; it defaults to the language value in incoming NAF file.\n");
        this.oteParser.addArgument(new String[]{"-o", "--outputFormat"}).required(false).choices((Object[])new String[]{"naf", "tabulated"}).setDefault((Object)"naf").help("Choose output format; it defaults to NAF.\n");
    }

    private void loadAspectParameters() {
        this.aspectParser.addArgument(new String[]{"-t", "--tagger"}).required(true).choices((Object[])new String[]{"doc", "seq"}).help("Choose type the of aspect classifier: using a sequence labeler model or a document classifier model.\n");
        this.aspectParser.addArgument(new String[]{"-m", "--model"}).required(true).help("Pass the model to do the tagging as a parameter.\n");
        this.aspectParser.addArgument(new String[]{"--clearFeatures"}).required(false).choices((Object[])new String[]{"yes", "no", "docstart"}).setDefault((Object)"no").help("Reset the adaptive features every sentence; defaults to 'no'; if -DOCSTART- marks are present, choose 'docstart'.\n");
        this.aspectParser.addArgument(new String[]{"-l", "--language"}).required(false).choices((Object[])new String[]{"en"}).help("Choose language; it defaults to the language value in incoming NAF file.\n");
        this.aspectParser.addArgument(new String[]{"-o", "--outputFormat"}).required(false).choices((Object[])new String[]{"naf", "tabulated"}).setDefault((Object)"naf").help("Choose output format; it defaults to NAF.\n");
    }

    private void loadPolarityParameters() {
        this.polarityParser.addArgument(new String[]{"-m", "--model"}).required(true).help("Pass the model to do the tagging as a parameter.\n");
        this.polarityParser.addArgument(new String[]{"--clearFeatures"}).required(false).choices((Object[])new String[]{"yes", "no", "docstart"}).setDefault((Object)"no").help("Reset the adaptive features every sentence; defaults to 'no'; if -DOCSTART- marks are present, choose 'docstart'.\n");
        this.polarityParser.addArgument(new String[]{"-l", "--language"}).required(false).choices((Object[])new String[]{"en"}).help("Choose language; it defaults to the language value in incoming NAF file.\n");
        this.polarityParser.addArgument(new String[]{"-o", "--outputFormat"}).required(false).choices((Object[])new String[]{"naf", "tabulated"}).setDefault((Object)"naf").help("Choose output format; it defaults to NAF.\n");
        this.polarityParser.addArgument(new String[]{"-d", "--dictionary"}).required(false).setDefault((Object)"off").help("Provide polarity lexicon to tag polarity at token/lemma level.\n");
    }

    private void loadServerParameters() {
        this.serverParser.addArgument(new String[]{"-t", "--task"}).required(true).choices((Object[])new String[]{ABSA_PARSER_NAME, OTE_PARSER_NAME, ASPECT_PARSER_NAME, "polarity"}).help("Choose the task.\n");
        this.serverParser.addArgument(new String[]{"-c", "--tagger"}).required(true).choices((Object[])new String[]{"doc", "seq"}).help("Choose type the of aspect classifier: using a sequence labeler model or a document classifier model.\n");
        this.serverParser.addArgument(new String[]{"-p", "--port"}).required(true).help("Port to be assigned to the server.\n");
        this.serverParser.addArgument(new String[]{"-m", "--model"}).required(true).help("Pass the model to do the tagging as a parameter.\n");
        this.serverParser.addArgument(new String[]{"--clearFeatures"}).required(false).choices((Object[])new String[]{"yes", "no", "docstart"}).setDefault((Object)"no").help("Reset the adaptive features every sentence; defaults to 'no'; if -DOCSTART- marks are present, choose 'docstart'.\n");
        this.serverParser.addArgument(new String[]{"-l", "--language"}).required(true).choices((Object[])new String[]{"en", "es", "fr", "tr", "ru"}).help("Choose language.\n");
        this.serverParser.addArgument(new String[]{"-o", "--outputFormat"}).required(false).choices((Object[])new String[]{"tabulated", "naf"}).setDefault((Object)"naf").help("Choose output format; it defaults to NAF.\n");
    }

    private void loadClientParameters() {
        this.clientParser.addArgument(new String[]{"-p", "--port"}).required(true).help("Port of the TCP server.\n");
        this.clientParser.addArgument(new String[]{"--host"}).required(false).setDefault((Object)"localhost").help("Hostname or IP where the TCP server is running.\n");
    }

    private Properties setOteProperties(String model, String language, String clearFeatures) {
        Properties oteProperties = new Properties();
        oteProperties.setProperty("model", model);
        oteProperties.setProperty("language", language);
        oteProperties.setProperty("clearFeatures", clearFeatures);
        return oteProperties;
    }

    private Properties setAspectProperties(String tagger, String model, String language, String clearFeatures) {
        Properties aspectProperties = new Properties();
        aspectProperties.setProperty("tagger", tagger);
        aspectProperties.setProperty("model", model);
        aspectProperties.setProperty("language", language);
        aspectProperties.setProperty("clearFeatures", clearFeatures);
        return aspectProperties;
    }

    private Properties setPolarityProperties(String model, String dictionary, String language, String clearFeatures) {
        Properties polarityProperties = new Properties();
        polarityProperties.setProperty("model", model);
        polarityProperties.setProperty("dictionary", dictionary);
        polarityProperties.setProperty("language", language);
        polarityProperties.setProperty("clearFeatures", clearFeatures);
        return polarityProperties;
    }

    private Properties setAbsaServerProperties(String port, String model, String language, String clearFeatures, String outputFormat) {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("port", port);
        serverProperties.setProperty("model", model);
        serverProperties.setProperty("language", language);
        serverProperties.setProperty("clearFeatures", clearFeatures);
        serverProperties.setProperty("outputFormat", outputFormat);
        return serverProperties;
    }
}

