/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.opinion;

import eus.ixa.ixa.pipe.ml.StatisticalDocumentClassifier;
import eus.ixa.ixa.pipe.opinion.Annotate;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Opinion;
import ixa.kaflib.Span;
import ixa.kaflib.WF;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class DocAnnotateAspects
implements Annotate {
    private StatisticalDocumentClassifier aspectExtractor;
    private String clearFeatures;

    public DocAnnotateAspects(Properties properties) throws IOException {
        this.clearFeatures = properties.getProperty("clearFeatures");
        this.aspectExtractor = new StatisticalDocumentClassifier(properties);
    }

    @Override
    public final void annotate(KAFDocument kaf) {
        List sentences = kaf.getSentences();
        for (List sentence : sentences) {
            String[] tokens = new String[sentence.size()];
            String[] tokenIds = new String[sentence.size()];
            for (int i = 0; i < sentence.size(); ++i) {
                tokens[i] = ((WF)sentence.get(i)).getForm();
                tokenIds[i] = ((WF)sentence.get(i)).getId();
            }
            if (this.clearFeatures.equalsIgnoreCase("docstart") && tokens[0].startsWith("-DOCSTART-")) {
                this.aspectExtractor.clearFeatureData();
            }
            String aspect = this.aspectExtractor.classify(tokens);
            List aspectTerms = kaf.getTermsFromWFs(Arrays.asList(Arrays.copyOfRange(tokenIds, 0, tokens.length)));
            Span aspectSpan = KAFDocument.newTermSpan((List)aspectTerms);
            Opinion opinion = kaf.newOpinion();
            Opinion.OpinionExpression opExpression = opinion.createOpinionExpression(aspectSpan);
            opExpression.setSentimentProductFeature(aspect);
            if (!this.clearFeatures.equalsIgnoreCase("yes")) continue;
            this.aspectExtractor.clearFeatureData();
        }
        this.aspectExtractor.clearFeatureData();
    }

    @Override
    public final String annotateToNAF(KAFDocument kaf) {
        return kaf.toString();
    }

    public final String annotateAspectsToTabulated(KAFDocument kaf) {
        return kaf.toString();
    }
}

