/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.opinion;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.opinion.Annotate;
import eus.ixa.ixa.pipe.opinion.AnnotateTargets;
import eus.ixa.ixa.pipe.opinion.CLI;
import eus.ixa.ixa.pipe.opinion.DocAnnotateAspects;
import eus.ixa.ixa.pipe.opinion.SeqAnnotateAspects;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.jdom2.JDOMException;

public class OpinionTaggerServer {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    private String model = null;
    private String outputFormat = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpinionTaggerServer(Properties properties) throws IOException {
        Integer port = Integer.parseInt(properties.getProperty("port"));
        this.model = properties.getProperty("model");
        this.outputFormat = properties.getProperty("outputFormat");
        String task = properties.getProperty("task");
        Annotate annotator = null;
        if (task.equalsIgnoreCase("ote")) {
            annotator = new AnnotateTargets(properties);
        } else if (task.equalsIgnoreCase("aspect")) {
            String tagger = properties.getProperty("tagger");
            annotator = tagger.equalsIgnoreCase("doc") ? new DocAnnotateAspects(properties) : new SeqAnnotateAspects(properties);
        } else if (task.equalsIgnoreCase("polarity")) {
            annotator = new DocAnnotateAspects(properties);
        }
        ServerSocket socketServer = null;
        BufferedReader inFromClient = null;
        BufferedWriter outToClient = null;
        try {
            try {
                System.out.println("-> Trying to listen port... " + port);
                socketServer = new ServerSocket(port);
                System.out.println("-> Connected and listening to port " + port);
                while (true) {
                    String kafToString;
                    Socket activeSocket;
                    try {
                        activeSocket = socketServer.accept();
                        inFromClient = new BufferedReader(new InputStreamReader(activeSocket.getInputStream(), "UTF-8"));
                        outToClient = new BufferedWriter(new OutputStreamWriter(activeSocket.getOutputStream(), "UTF-8"));
                        String stringFromClient = this.getClientData(inFromClient);
                        kafToString = this.getAnnotations(annotator, stringFromClient);
                    }
                    catch (JDOMException e) {
                        kafToString = "\n-> ERROR: Badly formatted NAF document!!\n";
                        this.sendDataToClient(outToClient, kafToString);
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        kafToString = "\n-> ERROR: UTF-8 not supported!!\n";
                        this.sendDataToClient(outToClient, kafToString);
                        continue;
                    }
                    catch (IOException e) {
                        kafToString = "\n -> ERROR: Input data not correct!!\n";
                        this.sendDataToClient(outToClient, kafToString);
                        continue;
                    }
                    this.sendDataToClient(outToClient, kafToString);
                    inFromClient.close();
                    activeSocket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("-> IOException due to failing to create the TCP socket or to wrongly provided model path.");
                System.out.println("closing tcp socket...");
                try {
                    socketServer.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("closing tcp socket...");
            try {
                socketServer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    private String getClientData(BufferedReader inFromClient) {
        StringBuilder stringFromClient = new StringBuilder();
        try {
            String line;
            while ((line = inFromClient.readLine()) != null && !line.matches("<ENDOFDOCUMENT>")) {
                stringFromClient.append(line).append("\n");
                if (!line.matches("</NAF>")) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringFromClient.toString();
    }

    private void sendDataToClient(BufferedWriter outToClient, String kafToString) throws IOException {
        outToClient.write(kafToString);
        outToClient.close();
    }

    private String getAnnotations(Annotate annotator, String stringFromClient) throws IOException, JDOMException {
        BufferedReader clientReader = new BufferedReader(new StringReader(stringFromClient));
        KAFDocument kaf = KAFDocument.createFromStream((Reader)clientReader);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("opinions", "ixa-pipe-opinion-" + Files.getNameWithoutExtension((String)this.model), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        annotator.annotate(kaf);
        newLp.setEndTimestamp();
        String kafToString = null;
        kafToString = this.outputFormat.equalsIgnoreCase("tabulated") ? annotator.annotateToNAF(kaf) : annotator.annotateToNAF(kaf);
        return kafToString;
    }
}

