/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.opinion;

import eus.ixa.ixa.pipe.ml.StatisticalSequenceLabeler;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabel;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelFactory;
import eus.ixa.ixa.pipe.opinion.Annotate;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Opinion;
import ixa.kaflib.Span;
import ixa.kaflib.WF;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class SeqAnnotateAspects
implements Annotate {
    private SequenceLabelFactory nameFactory;
    private StatisticalSequenceLabeler seqExtractor;
    private String clearFeatures;

    public SeqAnnotateAspects(Properties properties) throws IOException {
        this.clearFeatures = properties.getProperty("clearFeatures");
        this.nameFactory = new SequenceLabelFactory();
        this.seqExtractor = new StatisticalSequenceLabeler(properties);
    }

    @Override
    public final void annotate(KAFDocument kaf) {
        List sentences = kaf.getSentences();
        for (List sentence : sentences) {
            String[] tokens = new String[sentence.size()];
            String[] tokenIds = new String[sentence.size()];
            for (int i = 0; i < sentence.size(); ++i) {
                tokens[i] = ((WF)sentence.get(i)).getForm();
                tokenIds[i] = ((WF)sentence.get(i)).getId();
            }
            if (this.clearFeatures.equalsIgnoreCase("docstart") && tokens[0].startsWith("-DOCSTART-")) {
                this.seqExtractor.clearAdaptiveData();
            }
            List names = this.seqExtractor.getSequences(tokens);
            for (SequenceLabel name : names) {
                Integer startIndex = name.getSpan().getStart();
                Integer endIndex = name.getSpan().getEnd();
                List nameTerms = kaf.getTermsFromWFs(Arrays.asList(Arrays.copyOfRange(tokenIds, (int)startIndex, (int)endIndex)));
                Span oteSpan = KAFDocument.newTermSpan((List)nameTerms);
                Opinion opinion = kaf.newOpinion();
                opinion.createOpinionTarget(oteSpan);
                Opinion.OpinionExpression opExpression = opinion.createOpinionExpression(oteSpan);
                opExpression.setSentimentProductFeature(name.getType());
            }
            if (!this.clearFeatures.equalsIgnoreCase("yes")) continue;
            this.seqExtractor.clearAdaptiveData();
        }
        this.seqExtractor.clearAdaptiveData();
    }

    @Override
    public final String annotateToNAF(KAFDocument kaf) {
        return kaf.toString();
    }

    public final String annotateAspectsToTabulated(KAFDocument kaf) {
        return kaf.toString();
    }
}

