/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.parse;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import opennlp.tools.cmdline.parser.ParserTool;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;

public class ConstituentParsing {
    private static ConcurrentHashMap<String, ParserModel> parseModels = new ConcurrentHashMap();
    private final Parser parser;

    public ConstituentParsing(Properties properties) {
        String lang = properties.getProperty("language");
        String model = properties.getProperty("model");
        ParserModel parserModel = this.loadModel(lang, model);
        this.parser = ParserFactory.create(parserModel);
    }

    private final ParserModel loadModel(String lang, String model) {
        long lStartTime = new Date().getTime();
        try {
            parseModels.putIfAbsent(lang, new ParserModel(new FileInputStream(model)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long lEndTime = new Date().getTime();
        long difference = lEndTime - lStartTime;
        System.err.println("ixa-pipe-parse model loaded in: " + difference + " miliseconds ... [DONE]");
        return parseModels.get(lang);
    }

    public Parse[] parse(String sentence, int numParses) {
        Parse[] parsedSentence = ParserTool.parseLine(sentence, this.parser, numParses);
        return parsedSentence;
    }
}

