/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class IdManager
implements Serializable {
    private static final String WF_PREFIX = "w";
    private static final String TERM_PREFIX = "t";
    private static final String MARK_PREFIX = "m";
    private static final String MW_PREFIX = "t.mw";
    private static final String COMPONENT_PREFIX = ".";
    private static final String CHUNK_PREFIX = "c";
    private static final String ENTITY_PREFIX = "e";
    private static final String COREF_PREFIX = "co";
    private static final String TIMEX3_PREFIX = "tx";
    private static final String TLINK_PREFIX = "tlink";
    private static final String CLINK_PREFIX = "clink";
    private static final String LINKEDENTITY_PREFIX = "le";
    private static final String PROPERTY_PREFIX = "p";
    private static final String CATEGORY_PREFIX = "c";
    private static final String OPINION_PREFIX = "o";
    private static final String RELATION_PREFIX = "r";
    private static final String PREDICATE_PREFIX = "pr";
    private static final String ROLE_PREFIX = "rl";
    private static final String TERMINAL_PREFIX = "ter";
    private static final String NONTERMINAL_PREFIX = "nter";
    private static final String EDGE_PREFIX = "tre";
    private int wfCounter = 0;
    private int termCounter = 0;
    private int markCounter = 0;
    private int chunkCounter = 0;
    private int entityCounter = 0;
    private int corefCounter = 0;
    private int timex3Counter = 0;
    private int tlinkCounter = 0;
    private int clinkCounter = 0;
    private int linkedEntitiesCounter = 0;
    private int propertyCounter = 0;
    private int categoryCounter = 0;
    private int opinionCounter = 0;
    private int relationCounter = 0;
    private int predicateCounter = 0;
    private int terminalCounter = 0;
    private int nonterminalCounter = 0;
    private int edgeCounter = 0;
    private HashMap<String, Integer> componentCounter = new HashMap();
    private int roleCounter = 0;
    private boolean inconsistentIdText = false;
    private boolean inconsistentIdTerm = false;
    private boolean inconsistentIdMark = false;
    private boolean inconsistentIdComponent = false;
    private boolean inconsistentIdChunk = false;
    private boolean inconsistentIdEntity = false;
    private boolean inconsistentIdCoref = false;
    private boolean inconsistentIdTimex3 = false;
    private boolean inconsistentIdTLink = false;
    private boolean inconsistentIdCLink = false;
    private boolean inconsistentIdLinkedEntities = false;
    private boolean inconsistentIdProperty = false;
    private boolean inconsistentIdCategory = false;
    private boolean inconsistentIdOpinion = false;
    private boolean inconsistentIdRelation = false;
    private boolean inconsistentIdPredicate = false;
    private boolean inconsistentIdRole = false;
    private boolean inconsistentIdTerminal = false;
    private boolean inconsistentIdNonTerminal = false;
    private boolean inconsistentIdEdge = false;

    IdManager() {
    }

    String getNextWFId() {
        if (this.inconsistentIdText) {
            throw new IllegalStateException("Inconsistent WF IDs. Can't create new WF IDs.");
        }
        return WF_PREFIX + Integer.toString(++this.wfCounter);
    }

    String getNextTermId() {
        if (this.inconsistentIdTerm) {
            throw new IllegalStateException("Inconsistent term IDs. Can't create new term IDs.");
        }
        return TERM_PREFIX + Integer.toString(++this.termCounter);
    }

    String getNextMarkId() {
        if (this.inconsistentIdMark) {
            throw new IllegalStateException("Inconsistent mark IDs. Can't create new mark IDs.");
        }
        return MARK_PREFIX + Integer.toString(++this.markCounter);
    }

    String getNextMwId() {
        return MW_PREFIX + Integer.toString(++this.termCounter);
    }

    String getNextChunkId() {
        if (this.inconsistentIdChunk) {
            throw new IllegalStateException("Inconsistent chunk IDs. Can't create new chunk IDs.");
        }
        return "c" + Integer.toString(++this.chunkCounter);
    }

    String getNextEntityId() {
        if (this.inconsistentIdEntity) {
            throw new IllegalStateException("Inconsistent entity IDs. Can't create new entity IDs.");
        }
        return ENTITY_PREFIX + Integer.toString(++this.entityCounter);
    }

    String getNextCorefId() {
        if (this.inconsistentIdCoref) {
            throw new IllegalStateException("Inconsistent coref IDs. Can't create new coref IDs.");
        }
        return COREF_PREFIX + Integer.toString(++this.corefCounter);
    }

    String getNextTimex3Id() {
        if (this.inconsistentIdTimex3) {
            throw new IllegalStateException("Inconsistent timex3 IDs. Can't create new timex3 IDs.");
        }
        return TIMEX3_PREFIX + Integer.toString(++this.timex3Counter);
    }

    String getNextTLinkId() {
        if (this.inconsistentIdTLink) {
            throw new IllegalStateException("Inconsistent tlink IDs. Can't create new tlink IDs.");
        }
        return TLINK_PREFIX + Integer.toString(++this.tlinkCounter);
    }

    String getNextCLinkId() {
        if (this.inconsistentIdCLink) {
            throw new IllegalStateException("Inconsistent clink IDs. Can't create new clink IDs.");
        }
        return CLINK_PREFIX + Integer.toString(++this.clinkCounter);
    }

    String getNextLinkedEntityId() {
        if (this.inconsistentIdLinkedEntities) {
            throw new IllegalStateException("Inconsistent linked entity IDs. Can't create new timex3 IDs.");
        }
        return LINKEDENTITY_PREFIX + Integer.toString(++this.linkedEntitiesCounter);
    }

    String getNextPropertyId() {
        if (this.inconsistentIdProperty) {
            throw new IllegalStateException("Inconsistent property IDs. Can't create new property IDs.");
        }
        return PROPERTY_PREFIX + Integer.toString(++this.propertyCounter);
    }

    String getNextCategoryId() {
        if (this.inconsistentIdCategory) {
            throw new IllegalStateException("Inconsistent category IDs. Can't create new category IDs.");
        }
        return "c" + Integer.toString(++this.categoryCounter);
    }

    String getNextOpinionId() {
        if (this.inconsistentIdOpinion) {
            throw new IllegalStateException("Inconsistent opinion IDs. Can't create new opinion IDs.");
        }
        return OPINION_PREFIX + Integer.toString(++this.opinionCounter);
    }

    String getNextRelationId() {
        if (this.inconsistentIdRelation) {
            throw new IllegalStateException("Inconsistent relation IDs. Can't create new relation IDs.");
        }
        return RELATION_PREFIX + Integer.toString(++this.relationCounter);
    }

    String getNextPredicateId() {
        if (this.inconsistentIdPredicate) {
            throw new IllegalStateException("Inconsistent predicate IDs. Can't create new predicate IDs.");
        }
        return PREDICATE_PREFIX + Integer.toString(++this.predicateCounter);
    }

    String getNextTerminalId() {
        if (this.inconsistentIdTerminal) {
            throw new IllegalStateException("Inconsistent terminal IDs. Can't create new terminal IDs.");
        }
        return TERMINAL_PREFIX + Integer.toString(++this.terminalCounter);
    }

    String getNextNonterminalId() {
        if (this.inconsistentIdNonTerminal) {
            throw new IllegalStateException("Inconsistent non-terminal IDs. Can't create new non-terminal IDs.");
        }
        return NONTERMINAL_PREFIX + Integer.toString(++this.nonterminalCounter);
    }

    String getNextEdgeId() {
        if (this.inconsistentIdEdge) {
            throw new IllegalStateException("Inconsistent edge IDs. Can't create new edge IDs.");
        }
        return EDGE_PREFIX + Integer.toString(++this.edgeCounter);
    }

    String getNextComponentId(String termId) {
        if (this.inconsistentIdComponent) {
            throw new IllegalStateException("Inconsistent component IDs. Can't create new component IDs.");
        }
        int nextIndex = !this.componentCounter.containsKey(termId) ? 1 : this.componentCounter.get(termId) + 1;
        String newId = termId + COMPONENT_PREFIX + Integer.toString(nextIndex);
        this.componentCounter.put(termId, nextIndex);
        return newId;
    }

    String getNextRoleId() {
        if (this.inconsistentIdRole) {
            throw new IllegalStateException("Inconsistent role IDs. Can't create new role IDs.");
        }
        return ROLE_PREFIX + Integer.toString(++this.roleCounter);
    }

    private int extractCounterFromId(String id) {
        Matcher matcher = Pattern.compile("\\d+$").matcher(id);
        if (!matcher.find()) {
            throw new IllegalStateException("IdManager doesn't recognise the given id's (" + id + ") format.");
        }
        return Integer.valueOf(matcher.group(0));
    }

    void updateWFCounter(String id) {
        try {
            this.wfCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdText = true;
        }
    }

    void updateTermCounter(String id) {
        try {
            Integer idNum = this.extractCounterFromId(id);
            if (this.termCounter < idNum) {
                this.termCounter = idNum;
            }
        }
        catch (IllegalStateException e) {
            this.inconsistentIdTerm = true;
        }
    }

    void updateMarkCounter(String id) {
        try {
            Integer idNum = this.extractCounterFromId(id);
            if (this.markCounter < idNum) {
                this.markCounter = idNum;
            }
        }
        catch (IllegalStateException e) {
            this.inconsistentIdMark = true;
        }
    }

    void updateMwCounter(String id) {
        try {
            Integer idNum = this.extractCounterFromId(id);
            if (this.termCounter < idNum) {
                this.termCounter = idNum;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    void updateChunkCounter(String id) {
        try {
            this.chunkCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdChunk = true;
        }
    }

    void updateEntityCounter(String id) {
        try {
            this.entityCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdEntity = true;
        }
    }

    void updateCorefCounter(String id) {
        try {
            this.corefCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdCoref = true;
        }
    }

    void updateTimex3Counter(String id) {
        try {
            this.timex3Counter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdTimex3 = true;
        }
    }

    void updateTLinkCounter(String id) {
        try {
            this.tlinkCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdTLink = true;
        }
    }

    void updateCLinkCounter(String id) {
        try {
            this.clinkCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdCLink = true;
        }
    }

    void updateLinkedEntitiesCounter(String id) {
        try {
            this.linkedEntitiesCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdLinkedEntities = true;
        }
    }

    void updatePropertyCounter(String id) {
        try {
            this.propertyCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdProperty = true;
        }
    }

    void updateCategoryCounter(String id) {
        try {
            this.categoryCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdCategory = true;
        }
    }

    void updateOpinionCounter(String id) {
        try {
            this.opinionCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdOpinion = true;
        }
    }

    void updateRelationCounter(String id) {
        try {
            this.relationCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdRelation = true;
        }
    }

    void updatePredicateCounter(String id) {
        try {
            this.predicateCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdPredicate = true;
        }
    }

    void updateTerminalCounter(String id) {
        try {
            this.terminalCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdTerminal = true;
        }
    }

    void updateNonterminalCounter(String id) {
        try {
            this.nonterminalCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdNonTerminal = true;
        }
    }

    void updateEdgeCounter(String id) {
        try {
            this.edgeCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdEdge = true;
        }
    }

    void updateComponentCounter(String id, String termId) {
        Matcher matcher = Pattern.compile("^t_?\\d+\\.(\\d+)$").matcher(id);
        if (!matcher.find()) {
            this.inconsistentIdComponent = true;
            return;
        }
        int componentInd = Integer.valueOf(matcher.group(1));
        this.componentCounter.put(termId, componentInd);
    }

    void updateRoleCounter(String id) {
        try {
            this.roleCounter = this.extractCounterFromId(id);
        }
        catch (IllegalStateException e) {
            this.inconsistentIdRole = true;
        }
    }
}

