/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.ExternalRef;
import ixa.kaflib.Span;
import ixa.kaflib.TLinkReferable;
import ixa.kaflib.Term;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Predicate
implements TLinkReferable,
Serializable {
    private String id;
    private String uri;
    private float confidence;
    private Span<Term> span;
    private List<Role> roles;
    private List<ExternalRef> externalReferences;

    Predicate(String id, Span<Term> span) {
        this.id = id;
        this.span = span;
        this.roles = new ArrayList<Role>();
        this.confidence = -1.0f;
        this.externalReferences = new ArrayList<ExternalRef>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean hasConfidence() {
        return this.confidence != -1.0f;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public void setConfidence(float confidence) {
        this.confidence = confidence;
    }

    public Span<Term> getSpan() {
        return this.span;
    }

    public void setSpan(Span<Term> span) {
        this.span = span;
    }

    public List<Term> getTerms() {
        return this.span.getTargets();
    }

    public void addTerm(Term term) {
        this.span.addTarget(term);
    }

    public void addTerm(Term term, boolean isHead) {
        this.span.addTarget(term, isHead);
    }

    public String getStr() {
        String str = "";
        if (!this.span.isEmpty()) {
            Term target = this.span.getFirstTarget();
            str = str + target.getId() + " " + target.getStr() + " ";
        }
        str = str + ":";
        for (Role role : this.roles) {
            if (role.span.isEmpty()) continue;
            Term roleTarget = role.getSpan().getFirstTarget();
            str = str + " " + role.getSemRole() + "[" + roleTarget.getId() + " " + roleTarget.getStr() + "]";
        }
        return str;
    }

    public String getSpanStr() {
        String str = "";
        for (Term term : this.span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + term.getStr();
        }
        return str;
    }

    public List<ExternalRef> getExternalRefs() {
        return this.externalReferences;
    }

    public void addExternalRef(ExternalRef externalRef) {
        this.externalReferences.add(externalRef);
    }

    public void addExternalRefs(List<ExternalRef> externalRefs) {
        this.externalReferences.addAll(externalRefs);
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    public static class Role
    implements Serializable {
        private String rid;
        private String semRole;
        private Span<Term> span;
        private List<ExternalRef> externalReferences;

        Role(String id, String semRole, Span span) {
            this.rid = id;
            this.semRole = semRole;
            this.span = span;
            this.externalReferences = new ArrayList<ExternalRef>();
        }

        public String getId() {
            return this.rid;
        }

        public void setId(String id) {
            this.rid = id;
        }

        public String getSemRole() {
            return this.semRole;
        }

        public void setSemRole(String semRole) {
            this.semRole = semRole;
        }

        public Span<Term> getSpan() {
            return this.span;
        }

        public void setSpan(Span<Term> span) {
            this.span = span;
        }

        public List<Term> getTerms() {
            return this.span.getTargets();
        }

        public void addTerm(Term term) {
            this.span.addTarget(term);
        }

        public void addTerm(Term term, boolean isHead) {
            this.span.addTarget(term, isHead);
        }

        public String getStr() {
            String str = "";
            for (Term term : this.span.getTargets()) {
                if (!str.isEmpty()) {
                    str = str + " ";
                }
                str = str + term.getStr();
            }
            return str;
        }

        public List<ExternalRef> getExternalRefs() {
            return this.externalReferences;
        }

        public void addExternalRef(ExternalRef externalRef) {
            this.externalReferences.add(externalRef);
        }

        public void addExternalRefs(List<ExternalRef> externalRefs) {
            this.externalReferences.addAll(externalRefs);
        }
    }
}

