/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Relational;
import java.io.Serializable;
import java.util.HashMap;

public class Relation
implements Serializable {
    private String id;
    private Relational from;
    private Relational to;
    private float confidence;

    Relation(String id, Relational from, Relational to) {
        this.id = id;
        this.from = from;
        this.to = to;
        this.confidence = -1.0f;
    }

    Relation(Relation relation, HashMap<String, Relational> relational) {
        this.id = this.id;
        if (relation.from != null) {
            this.from = relational.get(relation.from.getId());
            if (this.from == null) {
                throw new IllegalStateException("Couldn't find relational " + relation.from.getId() + " when copying " + relation.getId());
            }
        }
        if (relation.to != null) {
            this.to = relational.get(relation.to.getId());
            if (this.to == null) {
                throw new IllegalStateException("Couldn't find relational " + relation.to.getId() + " when copying " + relation.getId());
            }
        }
        this.confidence = relation.confidence;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Relational getFrom() {
        return this.from;
    }

    public void setFrom(Relational obj) {
        this.from = obj;
    }

    public Relational getTo() {
        return this.to;
    }

    public void setTo(Relational obj) {
        this.to = obj;
    }

    public boolean hasConfidence() {
        return this.confidence >= 0.0f;
    }

    public float getConfidence() {
        if (this.confidence < 0.0f) {
            return 1.0f;
        }
        return this.confidence;
    }

    public void setConfidence(float confidence) {
        if (confidence < 0.0f || confidence > 1.0f) {
            throw new IllegalStateException("Confidence's value in a relation must be >=0 and <=1. [0, 1].");
        }
        this.confidence = confidence;
    }

    public String getStr() {
        String str = "(" + this.from.getStr() + ", " + this.to.getStr() + ")";
        if (this.hasConfidence()) {
            str = str + " [" + this.getConfidence() + "]";
        }
        return str;
    }
}

