/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnnotationConfiguration {
    public static final String SPAN_TYPE = "Span";
    public static final String ENTITY_TYPE = "Entity";
    public static final String RELATION_TYPE = "Relation";
    private final Map<String, String> typeToClassMap;

    public AnnotationConfiguration(Map<String, String> typeToClassMap) {
        this.typeToClassMap = Collections.unmodifiableMap(new HashMap<String, String>(typeToClassMap));
    }

    public String getTypeClass(String type) {
        return this.typeToClassMap.get(type);
    }

    public static AnnotationConfiguration parse(InputStream in) throws IOException {
        HashMap<String, String> typeToClassMap = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        String line = null;
        String sectionType = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                sectionType = line.substring(line.indexOf(91) + 1, line.indexOf(93));
                continue;
            }
            if ("entities".equals(sectionType)) {
                typeToClassMap.put(line, ENTITY_TYPE);
                continue;
            }
            if (!"relations".equals(sectionType)) continue;
            typeToClassMap.put(line.substring(0, line.indexOf(32)), RELATION_TYPE);
        }
        return new AnnotationConfiguration(typeToClassMap);
    }
}

