/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.heads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import opennlp.tools.parser.Constituent;
import opennlp.tools.parser.GapLabeler;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;

public class SpanishHeadRules
implements HeadRules,
GapLabeler {
    private Map<String, HeadRule> headRules;
    private final Set<String> punctSet;

    public SpanishHeadRules(Reader rulesReader) throws IOException {
        BufferedReader in = new BufferedReader(rulesReader);
        this.readHeadRules(in);
        this.punctSet = new HashSet<String>();
        this.punctSet.add(".");
        this.punctSet.add(",");
        this.punctSet.add("``");
        this.punctSet.add("''");
    }

    @Override
    public Set<String> getPunctuationTags() {
        return this.punctSet;
    }

    @Override
    public Parse getHead(Parse[] constituents, String type) {
        if (constituents[0].getType() == "TK") {
            return null;
        }
        if (type.startsWith("SN") || type.startsWith("GRUP.NOM")) {
            String[] tags1 = new String[]{"NCMS000", "NCFS000", "NCCS000", "NCMS00D", "NCMS00A", "NCFS00D", "NCFS00A", "NCCS00A", "NCCS00D", "NP0000", "NCMP000", "NCFP000", "NCCP000", "NCMP00D", "NCMP00A", "NCFP00D", "NCFP00A", "NCCP00A", "NCCP00D", "GRUP.NOM", "AQAMS0", "AQAFS0", "AQACS0", "AQAMN0", "AQAFN0", "AQACN0", "AQAMP0", "AQAFP0", "AQACP0", "AQCMS0", "AQCFS0", "AQCCS0", "AQCMN0", "AQCFN0", "AQCCN0", "AQCMP0", "AQCFP0", "AQCCP0"};
            for (int ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags1.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().equals(tags1[ti])) continue;
                    return constituents[ci];
                }
            }
            for (Parse constituent : constituents) {
                if (!constituent.getType().startsWith("SN") && !constituent.getType().startsWith("GRUP.NOM")) continue;
                return constituent;
            }
            String[] tags2 = new String[]{"$", "SA", "S.A", "GRUP.A"};
            for (int ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags2.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().equals(tags2[ti])) continue;
                    return constituents[ci];
                }
            }
            String[] tags4 = new String[]{"COORD", "CONJ", "CS"};
            for (int ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags4.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().equals(tags4[ti])) continue;
                    return constituents[ci];
                }
            }
            String[] tags3 = new String[]{"AQ0MS0", "AQ0FS0", "AQ0CS0", "AQ0MSP", "AQ0FSP", "AQ0CSP", "AQ0CNP", "AQ0MP0", "AQ0FP0", "AQ0CP0", "AQ0MPP", "AQ0FPP", "AQ0CPP", "AQ0MN0", "AQ0FN0", "AQ0CN0", "AQ0MNP", "AQ0FNP", "AQ0CNP", "AQSMS0", "AQSFS0", "AQSCS0", "AQSMN0", "AQSFN0", "AQSCN0", "AQSMP0", "AQSFP0", "AQSCP0", "RG", "RN", "GRUP.NOM"};
            for (int ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags3.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().equals(tags3[ti])) continue;
                    return constituents[ci];
                }
            }
            return constituents[constituents.length - 1];
        }
        HeadRule hr = this.headRules.get(type);
        if (hr != null) {
            String[] tags = hr.tags;
            int cl = constituents.length;
            int tl = tags.length;
            if (hr.leftToRight) {
                for (int ti = 0; ti < tl; ++ti) {
                    for (int ci = 0; ci < cl; ++ci) {
                        if (!constituents[ci].getType().equals(tags[ti]) && !constituents[ci].getType().startsWith(tags[ti])) continue;
                        return constituents[ci];
                    }
                }
                return constituents[0];
            }
            for (int ti = 0; ti < tl; ++ti) {
                for (int ci = cl - 1; ci >= 0; --ci) {
                    if (!constituents[ci].getType().equals(tags[ti])) continue;
                    return constituents[ci];
                }
            }
            return constituents[cl - 1];
        }
        return constituents[constituents.length - 1];
    }

    private void readHeadRules(BufferedReader str) throws IOException {
        String line;
        this.headRules = new HashMap<String, HeadRule>(60);
        while ((line = str.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            String num = st.nextToken();
            String type = st.nextToken();
            String dir = st.nextToken();
            String[] tags = new String[Integer.parseInt(num) - 2];
            int ti = 0;
            while (st.hasMoreTokens()) {
                tags[ti] = st.nextToken();
                ++ti;
            }
            this.headRules.put(type, new HeadRule(dir.equals("1"), tags));
        }
    }

    @Override
    public void labelGaps(Stack<Constituent> stack) {
        if (stack.size() > 4) {
            Constituent con1 = (Constituent)stack.get(stack.size() - 2);
            Constituent con2 = (Constituent)stack.get(stack.size() - 3);
            Constituent con3 = (Constituent)stack.get(stack.size() - 4);
            Constituent con4 = (Constituent)stack.get(stack.size() - 5);
            if (con1.getLabel().equals("SN") && con2.getLabel().equals("S") && con3.getLabel().equals("GRUP.NOM")) {
                con1.setLabel(con1.getLabel() + "-G");
                con2.setLabel(con2.getLabel() + "-G");
                con3.setLabel(con3.getLabel() + "-G");
            } else if (con1.getLabel().equals("SN") && con2.getLabel().equals("GRUP.VERB") && con3.getLabel().equals("S") && con4.getLabel().equals("GRUP.NOM")) {
                con1.setLabel(con1.getLabel() + "-G");
                con2.setLabel(con2.getLabel() + "-G");
                con3.setLabel(con3.getLabel() + "-G");
                con4.setLabel(con4.getLabel() + "-G");
            }
        }
    }

    public void serialize(Writer writer) throws IOException {
        for (String type : this.headRules.keySet()) {
            HeadRule headRule = this.headRules.get(type);
            writer.write(Integer.toString(headRule.tags.length + 2));
            writer.write(32);
            writer.write(type);
            writer.write(32);
            if (headRule.leftToRight) {
                writer.write("1");
            } else {
                writer.write("0");
            }
            for (String tag : headRule.tags) {
                writer.write(32);
                writer.write(tag);
            }
            writer.write(10);
        }
        writer.flush();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SpanishHeadRules) {
            SpanishHeadRules rules = (SpanishHeadRules)obj;
            return rules.headRules.equals(this.headRules) && rules.punctSet.equals(this.punctSet);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    private static class HeadRule {
        public boolean leftToRight;
        public String[] tags;

        public HeadRule(boolean l2r, String[] tags) {
            this.leftToRight = l2r;
            for (String tag : tags) {
                if (tag != null) continue;
                throw new IllegalArgumentException("tags must not contain null values!");
            }
            this.tags = tags;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof HeadRule) {
                HeadRule rule = (HeadRule)obj;
                return rule.leftToRight == this.leftToRight && Arrays.equals(rule.tags, this.tags);
            }
            return false;
        }
    }
}

