/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.parse;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import eus.ixa.ixa.pipe.heads.CollinsHeadFinder;
import eus.ixa.ixa.pipe.heads.HeadFinder;
import eus.ixa.ixa.pipe.parse.ConstituentParsing;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.WF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import opennlp.tools.parser.Parse;

public class Annotate {
    private boolean markHeads;
    private final ConstituentParsing parser;
    private HeadFinder headFinder;

    public Annotate(Properties properties) {
        this.parser = new ConstituentParsing(properties);
        this.annotateOptions(properties);
    }

    private void annotateOptions(Properties properties) {
        if (!properties.getProperty("headFinder").equalsIgnoreCase("no")) {
            this.markHeads = true;
            this.loadHeadFinder(properties);
        } else {
            this.markHeads = false;
        }
    }

    private void loadHeadFinder(Properties properties) {
        String headFinderOption = properties.getProperty("headFinder");
        if (headFinderOption.equalsIgnoreCase("collins")) {
            this.headFinder = new CollinsHeadFinder(properties);
        } else if (headFinderOption.equalsIgnoreCase("sem")) {
            this.headFinder = new CollinsHeadFinder(properties);
        } else {
            System.err.println("HeadFinder option not recognized!");
            System.exit(1);
        }
    }

    private String getSentenceFromTokens(String[] tokens) {
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            sb.append(token).append(" ");
        }
        String sentence = sb.toString();
        return sentence;
    }

    private StringBuffer getParse(KAFDocument kaf) throws IOException {
        StringBuffer parsingDoc = new StringBuffer();
        List<List<WF>> sentences = kaf.getSentences();
        for (List<WF> sentence : sentences) {
            String[] tokens = new String[sentence.size()];
            for (int i = 0; i < sentence.size(); ++i) {
                tokens[i] = sentence.get(i).getForm();
            }
            String sent = this.getSentenceFromTokens(tokens);
            Parse[] parsedSentence = this.parser.parse(sent, 1);
            if (this.markHeads) {
                for (Parse parse : parsedSentence) {
                    this.headFinder.printHeads(parse);
                }
            }
            for (Parse parsedSent : parsedSentence) {
                parsedSent.show(parsingDoc);
                parsingDoc.append("\n");
            }
        }
        return parsingDoc;
    }

    public void parseToKAF(KAFDocument kaf) throws IOException {
        StringBuffer parsingDoc = this.getParse(kaf);
        try {
            kaf.addConstituencyFromParentheses(parsingDoc.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String parseToOneline(KAFDocument kaf) throws IOException {
        StringBuffer parsingDoc = this.getParse(kaf);
        return parsingDoc.toString();
    }

    public void parseForTesting(File inputText) throws IOException {
        StringBuffer parsingDoc = new StringBuffer();
        if (inputText.isFile()) {
            List<String> inputTrees = Files.readLines(inputText, Charsets.UTF_8);
            for (String sentence : inputTrees) {
                Parse parsedSentence = this.parser.parse(sentence, 1)[0];
                parsedSentence.show(parsingDoc);
                parsingDoc.append("\n");
            }
            File outfile = new File(Files.getNameWithoutExtension(inputText.getPath()) + ".test");
            System.err.println("Writing test parse file to " + outfile);
            Files.write(parsingDoc.toString(), outfile, Charsets.UTF_8);
        } else {
            System.out.println("Choose a correct file!");
            System.exit(1);
        }
    }

    public void processTreebankWithHeadWords(File dir) throws IOException {
        if (dir.isFile()) {
            List<String> inputTrees = Files.readLines(new File(dir.getCanonicalPath()), Charsets.UTF_8);
            File outfile = new File(Files.getNameWithoutExtension(dir.getPath()) + ".head");
            String outTree = this.addHeadWordsToTreebank(inputTrees);
            Files.write(outTree, outfile, Charsets.UTF_8);
            System.err.println(">> Wrote headWords to " + outfile);
        } else {
            File[] listFile = dir.listFiles();
            if (listFile != null) {
                for (File element : listFile) {
                    if (element.isDirectory()) {
                        this.processTreebankWithHeadWords(element);
                        continue;
                    }
                    try {
                        List<String> inputTrees = Files.readLines(new File(Files.getNameWithoutExtension(element.getCanonicalPath())), Charsets.UTF_8);
                        File outfile = new File(Files.getNameWithoutExtension(element.getPath()) + ".head");
                        String outTree = this.addHeadWordsToTreebank(inputTrees);
                        Files.write(outTree, outfile, Charsets.UTF_8);
                        System.err.println(">> Wrote headWords to " + outfile);
                    }
                    catch (FileNotFoundException noFile) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private String addHeadWordsToTreebank(List<String> inputTrees) {
        StringBuffer parsedDoc = new StringBuffer();
        for (String parseSent : inputTrees) {
            Parse parsedSentence = Parse.parseParse(parseSent);
            this.headFinder.printHeads(parsedSentence);
            parsedSentence.show(parsedDoc);
            parsedDoc.append("\n");
        }
        return parsedDoc.toString();
    }
}

