/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.parse;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.parse.Annotate;
import eus.ixa.ixa.pipe.parse.ConstituentParserServer;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.jdom2.JDOMException;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    Namespace parsedArguments = null;
    ArgumentParser argParser = ArgumentParsers.newArgumentParser("ixa-pipe-parse-" + this.version + ".jar").description("ixa-pipe-parse is a multilingual Constituent Parsing module developed by IXA NLP Group.\n");
    private final Subparsers subParsers = this.argParser.addSubparsers().help("sub-command help");
    private final Subparser annotateParser = this.subParsers.addParser("parse").help("Parsing CLI");
    private final Subparser trainParser;
    private final Subparser evalParser;
    private Subparser serverParser;
    private Subparser clientParser;

    public CLI() {
        this.loadAnnotateParameters();
        this.trainParser = this.subParsers.addParser("train").help("Training CLI");
        this.loadTrainingParameters();
        this.evalParser = this.subParsers.addParser("eval").help("Evaluation CLI");
        this.loadEvalParameters();
        this.serverParser = this.subParsers.addParser("server").help("Start TCP socket server");
        this.loadServerParameters();
        this.clientParser = this.subParsers.addParser("client").help("Send queries to the TCP socket server");
        this.loadClientParameters();
    }

    public static void main(String[] args) throws IOException, JDOMException {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    public final void parseCLI(String[] args) throws IOException, JDOMException {
        try {
            this.parsedArguments = this.argParser.parseArgs(args);
            System.err.println("CLI options: " + this.parsedArguments);
            if (args[0].equals("parse")) {
                this.annotate(System.in, System.out);
            } else if (args[0].equals("eval")) {
                this.eval();
            } else if (args[0].equals("train")) {
                this.train();
            } else if (args[0].equals("server")) {
                this.server();
            } else if (args[0].equals("client")) {
                this.client(System.in, System.out);
            }
        }
        catch (ArgumentParserException e) {
            this.argParser.handleError(e);
            System.out.println("Run java -jar target/ixa-pipe-parse-" + this.version + ".jar" + " (parse|train|eval|server|client) -help for details");
            System.exit(1);
        }
    }

    public final void annotate(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream(breader);
        String model = this.parsedArguments.getString("model");
        String headFinderOption = this.parsedArguments.getString("headFinder");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String lang = null;
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
                System.exit(1);
            }
        } else {
            lang = kaf.getLang();
        }
        Properties properties = this.setAnnotateProperties(model, lang, headFinderOption);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("constituency", "ixa-pipe-parse-" + Files.getNameWithoutExtension(model), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        Annotate annotator = new Annotate(properties);
        String kafToString = null;
        if (outputFormat.equalsIgnoreCase("oneline")) {
            kafToString = annotator.parseToOneline(kaf);
        } else {
            annotator.parseToKAF(kaf);
            newLp.setEndTimestamp();
            kafToString = kaf.toString();
        }
        bwriter.write(kafToString);
        bwriter.close();
        breader.close();
    }

    public final void train() {
        System.err.println("Not yet ready!");
    }

    public final void eval() throws IOException {
        String lang = this.parsedArguments.getString("language");
        String model = this.parsedArguments.getString("model");
        String headFinderOption = this.parsedArguments.getString("headFinder");
        Properties properties = this.setEvaluateProperties(model, lang, headFinderOption);
        Annotate annotator = new Annotate(properties);
        if (this.parsedArguments.getString("addHeads") != null) {
            File inputTree = new File(this.parsedArguments.getString("addHeads"));
            annotator.processTreebankWithHeadWords(inputTree);
        } else if (this.parsedArguments.get("test") != null) {
            File inputTree = new File(this.parsedArguments.getString("test"));
            annotator.parseForTesting(inputTree);
        }
    }

    public final void server() {
        String port = this.parsedArguments.getString("port");
        String model = this.parsedArguments.getString("model");
        String headFinder = this.parsedArguments.getString("headFinder");
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String lang = this.parsedArguments.getString("language");
        Properties serverproperties = this.setServerProperties(port, model, lang, headFinder, outputFormat);
        new ConstituentParserServer(serverproperties);
    }

    public final void client(InputStream inputStream, OutputStream outputStream) {
        String host = this.parsedArguments.getString("host");
        String port = this.parsedArguments.getString("port");
        try (Socket socketClient = new Socket(host, Integer.parseInt(port));
             BufferedReader inFromUser = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
             BufferedWriter outToUser = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
             BufferedWriter outToServer = new BufferedWriter(new OutputStreamWriter(socketClient.getOutputStream(), "UTF-8"));
             BufferedReader inFromServer = new BufferedReader(new InputStreamReader(socketClient.getInputStream(), "UTF-8"));){
            String kafString;
            String line;
            StringBuilder inText = new StringBuilder();
            while ((line = inFromUser.readLine()) != null) {
                inText.append(line).append("\n");
            }
            inText.append("<ENDOFDOCUMENT>").append("\n");
            outToServer.write(inText.toString());
            outToServer.flush();
            StringBuilder sb = new StringBuilder();
            while ((kafString = inFromServer.readLine()) != null) {
                sb.append(kafString).append("\n");
            }
            outToUser.write(sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (UnknownHostException e) {
            System.err.println("ERROR: Unknown hostname or IP address!");
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println("Port number not correct!");
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadAnnotateParameters() {
        this.annotateParser.addArgument("-m", "--model").required(true).help("Choose parsing model.\n");
        this.annotateParser.addArgument("-l", "--language").choices("en", "es").required(false).help("Choose language; it defaults to the language value in incoming NAF file.\n");
        this.annotateParser.addArgument("-g", "--headFinder").choices("collins", "sem", "no").setDefault("no").required(false).help("Choose between Collins or Semantic HeadFinder.\n");
        this.annotateParser.addArgument("-o", "--outputFormat").choices("oneline", "naf").setDefault("naf").required(false).help("Choose outputFormat; it defaults to NAF.\n");
    }

    private void loadTrainingParameters() {
    }

    private void loadEvalParameters() {
        this.evalParser.addArgument("-m", "--model").required(true).help("Choose parsing model.\n");
        this.evalParser.addArgument("-l", "--language").choices("en", "es").required(true).help("Choose language.\n");
        this.evalParser.addArgument("-g", "--headFinder").choices("collins", "sem", "no").setDefault("no").required(false).help("Choose between Collins or Semantic HeadFinder.\n");
        this.evalParser.addArgument("--addHeads").help("Takes a file or a directory as argument containing a parse tree in penn treebank (one line per sentence) format; this option requires --lang and --headFinder options.\n");
        this.evalParser.addArgument("--test").help("Takes a file as argument containing the tokenized text of a gold standard Penn Treebank file to process it; It produces a test file for its parseval evaluation with EVALB.\n");
    }

    private void loadServerParameters() {
        this.serverParser.addArgument("-p", "--port").required(true).help("Port to be assigned to the server.\n");
        this.serverParser.addArgument("-m", "--model").required(true).help("Choose parsing model.\n");
        this.serverParser.addArgument("-l", "--language").choices("en", "es").required(true).help("Choose language.\n");
        this.serverParser.addArgument("-g", "--headFinder").choices("collins", "sem", "no").setDefault("no").required(false).help("Choose between Collins or Semantic HeadFinder.\n");
        this.serverParser.addArgument("-o", "--outputFormat").choices("oneline", "naf").setDefault("naf").required(false).help("Choose outputFormat; it defaults to NAF.\n");
    }

    private void loadClientParameters() {
        this.clientParser.addArgument("-p", "--port").required(true).help("Port of the TCP server.\n");
        this.clientParser.addArgument("--host").required(false).setDefault("localhost").help("Hostname or IP where the TCP server is running.\n");
    }

    private Properties setAnnotateProperties(String model, String language, String headFinder) {
        Properties annotateProperties = new Properties();
        annotateProperties.setProperty("model", model);
        annotateProperties.setProperty("language", language);
        annotateProperties.setProperty("headFinder", headFinder);
        return annotateProperties;
    }

    private Properties setEvaluateProperties(String model, String language, String headFinder) {
        Properties annotateProperties = new Properties();
        annotateProperties.setProperty("model", model);
        annotateProperties.setProperty("language", language);
        annotateProperties.setProperty("headFinder", headFinder);
        return annotateProperties;
    }

    private Properties setServerProperties(String port, String model, String language, String headFinder, String outputFormat) {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("port", port);
        serverProperties.setProperty("model", model);
        serverProperties.setProperty("language", language);
        serverProperties.setProperty("headFinder", headFinder);
        serverProperties.setProperty("outputFormat", outputFormat);
        return serverProperties;
    }
}

