/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chunk
extends IdentifiableAnnotation
implements SentenceLevelAnnotation {
    private String phrase;
    private String chunkcase;
    private Span<Term> span;

    Chunk(String id, Span<Term> span) {
        super(id);
        if (span.size() < 1) {
            throw new IllegalStateException("Chunks must contain at least one term target");
        }
        this.span = span;
    }

    Chunk(Chunk chunk, HashMap<String, Term> terms) {
        super(chunk.getId());
        this.phrase = chunk.phrase;
        this.chunkcase = chunk.chunkcase;
        String id = chunk.getId();
        Span<Term> span = chunk.span;
        List<Term> targets = span.getTargets();
        ArrayList<Term> copiedTargets = new ArrayList<Term>();
        for (Term term : targets) {
            Term copiedTerm = terms.get(term.getId());
            if (copiedTerm == null) {
                throw new IllegalStateException("Term not found when copying " + id);
            }
            copiedTargets.add(copiedTerm);
        }
        if (span.hasHead()) {
            Term copiedHead = terms.get(span.getHead().getId());
            this.span = new Span<Term>(copiedTargets, copiedHead);
        } else {
            this.span = new Span(copiedTargets);
        }
    }

    public boolean hasHead() {
        return this.span.getHead() != null;
    }

    public Term getHead() {
        return this.span.getHead();
    }

    public boolean hasPhrase() {
        return this.phrase != null;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public boolean hasCase() {
        return this.chunkcase != null;
    }

    public String getCase() {
        return this.chunkcase;
    }

    public void setCase(String chunkcase) {
        this.chunkcase = chunkcase;
    }

    public List<Term> getTerms() {
        return this.span.getTargets();
    }

    public void addTerm(Term term) {
        this.span.addTarget(term);
    }

    public void addTerm(Term term, boolean isHead) {
        this.span.addTarget(term, isHead);
    }

    public Span<Term> getSpan() {
        return this.span;
    }

    public void setSpan(Span<Term> span) {
        this.span = span;
    }

    public String getStr() {
        String str = "";
        for (Term term : this.span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + term.getStr();
        }
        return str;
    }

    @Override
    Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.AnnotationType, List<Annotation>> referenced = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
        referenced.put(KAFDocument.AnnotationType.TERM, this.getSpan().getTargets());
        return referenced;
    }

    @Override
    public Integer getSent() {
        return this.span.getFirstTarget().getSent();
    }

    @Override
    public Integer getPara() {
        return this.span.getFirstTarget().getPara();
    }

    public void setHead(Term term) {
        this.span.setHead(term);
    }
}

