/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkSampleSequenceStream;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.ChunkerEventStream;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.ml.model.TrainUtil;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;

public class ChunkerME
implements Chunker {
    public static final int DEFAULT_BEAM_SIZE = 10;
    private Sequence bestSequence;
    protected SequenceClassificationModel<String> model;
    private ChunkerContextGenerator contextGenerator;
    private SequenceValidator<String> sequenceValidator;

    @Deprecated
    public ChunkerME(ChunkerModel model, int beamSize, SequenceValidator<String> sequenceValidator, ChunkerContextGenerator contextGenerator) {
        this.sequenceValidator = sequenceValidator;
        this.contextGenerator = contextGenerator;
        this.model = model.getChunkerSequenceModel() != null ? model.getChunkerSequenceModel() : new BeamSearch<String>(beamSize, model.getChunkerModel(), 0);
    }

    @Deprecated
    public ChunkerME(ChunkerModel model, int beamSize, SequenceValidator<String> sequenceValidator) {
        this(model, beamSize, sequenceValidator, new DefaultChunkerContextGenerator());
    }

    @Deprecated
    public ChunkerME(ChunkerModel model, int beamSize) {
        this.contextGenerator = model.getFactory().getContextGenerator();
        this.sequenceValidator = model.getFactory().getSequenceValidator();
        this.model = model.getChunkerSequenceModel() != null ? model.getChunkerSequenceModel() : new BeamSearch<String>(beamSize, model.getChunkerModel(), 0);
    }

    public ChunkerME(ChunkerModel model) {
        this(model, 10);
    }

    @Override
    @Deprecated
    public List<String> chunk(List<String> toks, List<String> tags) {
        this.bestSequence = this.model.bestSequence((String[])toks.toArray(new String[toks.size()]), new Object[]{tags.toArray(new String[tags.size()])}, this.contextGenerator, this.sequenceValidator);
        return this.bestSequence.getOutcomes();
    }

    @Override
    public String[] chunk(String[] toks, String[] tags) {
        this.bestSequence = this.model.bestSequence((String[])toks, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
        List<String> c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    @Override
    public Span[] chunkAsSpans(String[] toks, String[] tags) {
        String[] preds = this.chunk(toks, tags);
        return ChunkSample.phrasesAsSpanList(toks, tags, preds);
    }

    @Override
    @Deprecated
    public Sequence[] topKSequences(List<String> sentence, List<String> tags) {
        return this.topKSequences(sentence.toArray(new String[sentence.size()]), tags.toArray(new String[tags.size()]));
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        return this.model.bestSequences(10, (String[])sentence, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.model.bestSequences(10, (String[])sentence, new Object[]{tags}, minSequenceScore, this.contextGenerator, this.sequenceValidator);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, TrainingParameters mlParams, ChunkerFactory factory) throws IOException {
        String beamSizeString = mlParams.getSettings().get("BeamSize");
        int beamSize = 3;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(mlParams.getSettings());
        MaxentModel chunkerModel = null;
        SequenceClassificationModel<String> seqChunkerModel = null;
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            ChunkerEventStream es = new ChunkerEventStream(in, factory.getContextGenerator());
            EventTrainer trainer = TrainerFactory.getEventTrainer(mlParams.getSettings(), manifestInfoEntries);
            chunkerModel = trainer.train(es);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer(mlParams.getSettings(), manifestInfoEntries);
            ChunkSampleSequenceStream ss = new ChunkSampleSequenceStream(in, factory.getContextGenerator());
            seqChunkerModel = trainer.train(ss);
        } else {
            throw new IllegalArgumentException("Trainer type is not supported: " + (Object)((Object)trainerType));
        }
        if (chunkerModel != null) {
            return new ChunkerModel(lang, chunkerModel, manifestInfoEntries, factory);
        }
        return new ChunkerModel(lang, seqChunkerModel, manifestInfoEntries, factory);
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, ChunkerContextGenerator contextGenerator, TrainingParameters mlParams) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        ChunkerEventStream es = new ChunkerEventStream(in, contextGenerator);
        MaxentModel maxentModel = TrainUtil.train(es, mlParams.getSettings(), manifestInfoEntries);
        return new ChunkerModel(lang, maxentModel, manifestInfoEntries);
    }
}

