/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.W2VClassesDictionary;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public class TokenNameFinderModel
extends BaseModel {
    private static final String COMPONENT_NAME = "NameFinderME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "nameFinder.model";
    static final String GENERATOR_DESCRIPTOR_ENTRY_NAME = "generator.featuregen";
    static final String SEQUENCE_CODEC_CLASS_NAME_PARAMETER = "sequenceCodecImplName";

    public TokenNameFinderModel(String languageCode, SequenceClassificationModel<String> nameFinderModel, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries, SequenceCodec<String> seqCodec) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        this.init(nameFinderModel, generatorDescriptor, resources, manifestInfoEntries, seqCodec);
        if (!seqCodec.areOutcomesCompatible(nameFinderModel.getOutcomes())) {
            throw new IllegalArgumentException("Model not compatible with name finder!");
        }
    }

    public TokenNameFinderModel(String languageCode, MaxentModel nameFinderModel, int beamSize, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries, SequenceCodec<String> seqCodec) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.put("BeamSize", Integer.toString(beamSize));
        this.init(nameFinderModel, generatorDescriptor, resources, manifestInfoEntries, seqCodec);
        if (!this.isModelValid(nameFinderModel)) {
            throw new IllegalArgumentException("Model not compatible with name finder!");
        }
    }

    public TokenNameFinderModel(String languageCode, MaxentModel nameFinderModel, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries) {
        this(languageCode, nameFinderModel, 3, generatorDescriptor, resources, manifestInfoEntries, new BioCodec());
    }

    public TokenNameFinderModel(String languageCode, MaxentModel nameFinderModel, Map<String, Object> resources, Map<String, String> manifestInfoEntries) {
        this(languageCode, nameFinderModel, null, resources, manifestInfoEntries);
    }

    public TokenNameFinderModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public TokenNameFinderModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public TokenNameFinderModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    private void init(Object nameFinderModel, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries, SequenceCodec<String> seqCodec) {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.put(SEQUENCE_CODEC_CLASS_NAME_PARAMETER, seqCodec.getClass().getName());
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, nameFinderModel);
        if (generatorDescriptor != null && generatorDescriptor.length > 0) {
            this.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, generatorDescriptor);
        }
        if (resources != null) {
            if (resources.containsKey(MAXENT_MODEL_ENTRY_NAME) || resources.containsKey(GENERATOR_DESCRIPTOR_ENTRY_NAME)) {
                throw new IllegalArgumentException();
            }
            this.artifactMap.putAll(resources);
        }
        this.checkArtifactMap();
    }

    @Deprecated
    public MaxentModel getNameFinderModel() {
        if (this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            return (MaxentModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
        }
        return null;
    }

    public SequenceClassificationModel<String> getNameFinderSequenceModel() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        if (this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            String beamSizeString = manifest.getProperty("BeamSize");
            int beamSize = 3;
            if (beamSizeString != null) {
                beamSize = Integer.parseInt(beamSizeString);
            }
            return new BeamSearch<String>(beamSize, (MaxentModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME));
        }
        if (this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel) {
            return (SequenceClassificationModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
        }
        return null;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return TokenNameFinderFactory.class;
    }

    public TokenNameFinderFactory getFactory() {
        return (TokenNameFinderFactory)this.toolFactory;
    }

    @Deprecated
    public AdaptiveFeatureGenerator createFeatureGenerators() {
        return this.getFactory().createFeatureGenerators();
    }

    public TokenNameFinderModel updateFeatureGenerator(byte[] descriptor) {
        TokenNameFinderModel model = this.getNameFinderModel() != null ? new TokenNameFinderModel(this.getLanguage(), this.getNameFinderModel(), 1, descriptor, Collections.emptyMap(), Collections.emptyMap(), this.getFactory().createSequenceCodec()) : new TokenNameFinderModel(this.getLanguage(), this.getNameFinderSequenceModel(), descriptor, Collections.emptyMap(), Collections.emptyMap(), this.getFactory().createSequenceCodec());
        model.artifactMap.clear();
        model.artifactMap.putAll(this.artifactMap);
        model.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, descriptor);
        return model;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
        serializers.put("featuregen", new ByteArraySerializer());
    }

    public static Map<String, ArtifactSerializer> createArtifactSerializers() {
        Map<String, ArtifactSerializer> serializers = BaseModel.createArtifactSerializers();
        serializers.put("featuregen", new ByteArraySerializer());
        serializers.put("w2vwordcluster", new W2VClassesDictionary.W2VClassesDictionarySerializer());
        return serializers;
    }

    boolean isModelValid(MaxentModel model) {
        String[] outcomes = new String[model.getNumOutcomes()];
        for (int i = 0; i < model.getNumOutcomes(); ++i) {
            outcomes[i] = model.getOutcome(i);
        }
        return this.getFactory().createSequenceCodec().areOutcomesCompatible(outcomes);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof MaxentModel) && !(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel)) {
            throw new InvalidFormatException("Token Name Finder model is incomplete!");
        }
    }

    private static class ByteArraySerializer
    implements ArtifactSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public byte[] create(InputStream in) throws IOException, InvalidFormatException {
            return ModelUtil.read(in);
        }

        @Override
        public void serialize(byte[] artifact, OutputStream out) throws IOException {
            out.write(artifact);
        }
    }

    public static class FeatureGeneratorCreationError
    extends RuntimeException {
        FeatureGeneratorCreationError(Throwable t) {
            super(t);
        }
    }
}

