/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma;

import eus.ixa.ixa.pipe.lemma.DictionaryLemmatizer;
import eus.ixa.ixa.pipe.pos.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SimpleLemmatizer
implements DictionaryLemmatizer {
    private final HashMap<List<String>, String> dictMap;
    private final Resources tagRetriever = new Resources();
    private final String lang;

    public SimpleLemmatizer(InputStream dictionary, String aLang) {
        this.dictMap = new HashMap();
        BufferedReader breader = new BufferedReader(new InputStreamReader(dictionary));
        try {
            String line;
            while ((line = breader.readLine()) != null) {
                String[] elems = line.split("\t");
                this.dictMap.put(Arrays.asList(elems[0], elems[2]), elems[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lang = aLang;
    }

    public HashMap<List<String>, String> getDictMap() {
        return this.dictMap;
    }

    private List<String> getDictKeys(String word, String postag) {
        String constantTag = this.tagRetriever.setTagConstant(this.lang, postag);
        ArrayList<String> keys = new ArrayList<String>();
        if (postag.startsWith(String.valueOf(constantTag))) {
            keys.addAll(Arrays.asList(word, postag));
        } else {
            keys.addAll(Arrays.asList(word.toLowerCase(), postag));
        }
        return keys;
    }

    @Override
    public String lemmatize(String word, String postag) {
        String lemma = null;
        String constantTag = this.tagRetriever.setTagConstant(this.lang, postag);
        List<String> keys = this.getDictKeys(word, postag);
        String keyValue = this.dictMap.get(keys);
        lemma = keyValue != null ? keyValue : (keyValue == null && postag.startsWith(String.valueOf(constantTag)) ? word : (keyValue == null && word.toUpperCase().equals(word) ? word : word.toLowerCase()));
        return lemma;
    }
}

