/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos.train;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;

public final class InputOutputUtils {
    private InputOutputUtils() {
    }

    private static void checkInputFile(String name, File inFile) {
        String isFailure = null;
        if (inFile.isDirectory()) {
            isFailure = "The " + name + " file is a directory!";
        } else if (!inFile.exists()) {
            isFailure = "The " + name + " file does not exist!";
        } else if (!inFile.canRead()) {
            isFailure = "No permissions to read the " + name + " file!";
        }
        if (null != isFailure) {
            throw new TerminateToolException(-1, isFailure + " Path: " + inFile.getAbsolutePath());
        }
    }

    public static TrainingParameters loadTrainingParameters(String paramFile) {
        return InputOutputUtils.loadTrainingParameters(paramFile, false);
    }

    private static TrainingParameters loadTrainingParameters(String paramFile, boolean supportSequenceTraining) {
        TrainingParameters params = null;
        if (paramFile != null) {
            InputOutputUtils.checkInputFile("Training Parameter", new File(paramFile));
            InputStream paramsIn = null;
            try {
                paramsIn = new FileInputStream(new File(paramFile));
                params = new TrainingParameters(paramsIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Error during parameters loading: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (paramsIn != null) {
                        paramsIn.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("Error closing the input stream");
                }
            }
            if (!TrainerFactory.isValid(params.getSettings())) {
                throw new TerminateToolException(1, "Training parameters file '" + paramFile + "' is invalid!");
            }
        }
        return params;
    }

    public static ObjectStream<String> readFileIntoMarkableStreamFactory(String infile) {
        MarkableFileInputStreamFactory inputStreamFactory = null;
        try {
            inputStreamFactory = new MarkableFileInputStreamFactory(new File(infile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8");
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
        }
        return lineStream;
    }
}

