/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.MultiLayerAnnotation;
import ixa.kaflib.ParagraphLevelAnnotation;
import ixa.kaflib.SentenceLevelAnnotation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

class AnnotationContainer
implements Serializable {
    private String rawText = new String();
    private Map<KAFDocument.Layer, Map<String, List<Annotation>>> layers = new HashMap<KAFDocument.Layer, Map<String, List<Annotation>>>();
    private Set<Element> unknownLayers = new HashSet<Element>();
    private Map<Annotation, Map<KAFDocument.Layer, List<Annotation>>> invRefIndex = new HashMap<Annotation, Map<KAFDocument.Layer, List<Annotation>>>();
    private Map<KAFDocument.Layer, Map<String, Map<Integer, List<Annotation>>>> sentIndex = new HashMap<KAFDocument.Layer, Map<String, Map<Integer, List<Annotation>>>>();
    private Map<KAFDocument.Layer, Map<String, Map<Integer, List<Annotation>>>> paraIndex = new HashMap<KAFDocument.Layer, Map<String, Map<Integer, List<Annotation>>>>();
    private Map<Integer, Set<Integer>> paraSentIndex = new HashMap<Integer, Set<Integer>>();
    private Set<Integer> indexedSents = new HashSet<Integer>();
    static final String DEFAULT_GROUP = "kaflib_default_group";

    AnnotationContainer() {
    }

    String getRawText() {
        return this.rawText;
    }

    List<Annotation> get(KAFDocument.Layer layer) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (String group : this.getGroupIDs(layer)) {
            annotations.addAll(this.get(layer, group));
        }
        return annotations;
    }

    List<Annotation> get(KAFDocument.Layer layer, String group) {
        Map<String, List<Annotation>> layerGroups = this.layers.get((Object)layer);
        if (layerGroups == null) {
            return new ArrayList<Annotation>();
        }
        ArrayList annotations = layerGroups.get(group);
        return annotations == null ? new ArrayList() : annotations;
    }

    List<Annotation> getInverse(Annotation ann) {
        return Helper.getInvReferences(ann, this.invRefIndex);
    }

    List<Annotation> getInverse(Annotation ann, KAFDocument.Layer layer) {
        return Helper.getInvReferences(ann, layer, this.invRefIndex);
    }

    List<Annotation> getInverse(List<Annotation> anns, KAFDocument.Layer layer) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            result.addAll(Helper.getInvReferences(ann, layer, this.invRefIndex));
        }
        return result;
    }

    List<String> getGroupIDs(KAFDocument.Layer layer) {
        Map<String, List<Annotation>> layerGroups = this.layers.get((Object)layer);
        return layerGroups == null ? new ArrayList<String>() : new ArrayList<String>(layerGroups.keySet());
    }

    Set<Element> getUnknownLayers() {
        return this.unknownLayers;
    }

    void setRawText(String str) {
        this.rawText = str;
    }

    void add(Annotation ann, KAFDocument.Layer layer) {
        this.add(ann, layer, null);
    }

    void add(Annotation ann, KAFDocument.Layer layer, Integer position) {
        Helper.addAnnotation(ann, layer, AnnotationContainer.getGroupID(ann), position, this.layers);
        this.indexAnnotation(ann, layer);
    }

    void add(Element layer) {
        this.unknownLayers.add(layer);
    }

    private void indexAnnotation(Annotation ann, KAFDocument.Layer layer) {
        Map<KAFDocument.Layer, List<Annotation>> invReferences = ann.getReferencedAnnotations();
        for (Map.Entry<KAFDocument.Layer, List<Annotation>> pair : invReferences.entrySet()) {
            for (Annotation ref : pair.getValue()) {
                Helper.addInvReference(ann, ref, layer, this.invRefIndex);
            }
        }
        this.indexAnnotationParaSent(ann, layer);
    }

    private void indexAnnotationParaSent(Annotation ann, KAFDocument.Layer layer) {
        Integer para;
        String groupID = AnnotationContainer.getGroupID(ann);
        if (ann instanceof SentenceLevelAnnotation) {
            Integer sent = ((SentenceLevelAnnotation)((Object)ann)).getSent();
            Integer para2 = ((ParagraphLevelAnnotation)((Object)ann)).getPara();
            Helper.addToIndex(ann, layer, groupID, sent, this.sentIndex);
            if (para2 > 0) {
                Helper.addToIndex(ann, layer, groupID, para2, this.paraIndex);
                if (!this.indexedSents.contains(sent)) {
                    this.addSentToPara(sent, para2);
                    this.indexedSents.add(sent);
                }
            }
        } else if (ann instanceof ParagraphLevelAnnotation && (para = ((ParagraphLevelAnnotation)((Object)ann)).getPara()) > 0) {
            Helper.addToIndex(ann, layer, groupID, para, this.paraIndex);
        }
    }

    void reindexAnnotationParaSent(Annotation ann, KAFDocument.Layer layer, Integer oldSent, Integer oldPara) {
        String groupID = AnnotationContainer.getGroupID(ann);
        Helper.removeFromIndex(ann, layer, groupID, oldSent, this.sentIndex);
        Helper.removeFromIndex(ann, layer, groupID, oldPara, this.paraIndex);
        this.indexAnnotationParaSent(ann, layer);
    }

    void remove(Annotation ann, KAFDocument.Layer layer) {
        Map<String, List<Annotation>> layerGroups = this.layers.get((Object)layer);
        if (layerGroups != null) {
            layerGroups.remove(ann);
        }
        if (ann instanceof SentenceLevelAnnotation) {
            String groupID = AnnotationContainer.getGroupID(ann);
            Integer sent = ((SentenceLevelAnnotation)((Object)ann)).getSent();
            List<Annotation> sentAnnotations = this.getSentAnnotations(sent, layer, groupID);
            sentAnnotations.remove(ann);
            if (ann instanceof ParagraphLevelAnnotation) {
                Integer para = ((ParagraphLevelAnnotation)((Object)ann)).getPara();
                List<Annotation> paraAnnotations = this.getParaAnnotations(para, layer, groupID);
                paraAnnotations.remove(ann);
            }
        }
    }

    void removeLayer(KAFDocument.Layer layerName) {
        this.layers.remove((Object)layerName);
    }

    void removeLayer(KAFDocument.Layer layerName, String groupID) {
        Map<String, List<Annotation>> layer = this.layers.get((Object)layerName);
        if (layer != null) {
            layer.remove(groupID);
        }
    }

    List<Integer> getParaSents(Integer para) {
        ArrayList<Integer> sentList = new ArrayList<Integer>((Collection)this.paraSentIndex.get(para));
        Collections.sort(sentList);
        return sentList;
    }

    List<Annotation> getSentAnnotations(Integer sent, KAFDocument.Layer layer) {
        return this.getSentAnnotations(sent, layer, DEFAULT_GROUP);
    }

    List<Annotation> getSentAnnotations(Integer sent, KAFDocument.Layer layer, String groupID) {
        return Helper.getIndexedAnnotations(layer, groupID, sent, this.sentIndex);
    }

    List<Annotation> getParaAnnotations(Integer para, KAFDocument.Layer layer) {
        return this.getParaAnnotations(para, layer, DEFAULT_GROUP);
    }

    List<Annotation> getParaAnnotations(Integer para, KAFDocument.Layer layer, String groupID) {
        return Helper.getIndexedAnnotations(layer, groupID, para, this.paraIndex);
    }

    Integer getNumSentences() {
        return this.sentIndex.size();
    }

    Integer getNumParagraphs() {
        if (this.paraIndex.get((Object)KAFDocument.Layer.TEXT) == null) {
            return 0;
        }
        return this.paraIndex.get((Object)KAFDocument.Layer.TEXT).get(DEFAULT_GROUP).size();
    }

    List<List<Annotation>> getSentences(KAFDocument.Layer layer) {
        return this.getSentences(layer, DEFAULT_GROUP);
    }

    List<List<Annotation>> getSentences(KAFDocument.Layer layer, String groupID) {
        ArrayList<List<Annotation>> sentences = new ArrayList<List<Annotation>>();
        for (int sent : Helper.getIndexKeys(layer, groupID, this.sentIndex)) {
            sentences.add(this.getSentAnnotations(sent, layer));
        }
        return sentences;
    }

    List<List<Annotation>> getParagraphs(KAFDocument.Layer layer) {
        return this.getParagraphs(layer, DEFAULT_GROUP);
    }

    List<List<Annotation>> getParagraphs(KAFDocument.Layer layer, String groupID) {
        ArrayList<List<Annotation>> paragraphs = new ArrayList<List<Annotation>>();
        for (int para : Helper.getIndexKeys(layer, groupID, this.paraIndex)) {
            paragraphs.add(this.getParaAnnotations(para, layer));
        }
        return paragraphs;
    }

    private static String getGroupID(Annotation ann) {
        return ann instanceof MultiLayerAnnotation ? ((MultiLayerAnnotation)((Object)ann)).getGroupID() : DEFAULT_GROUP;
    }

    Integer getPosition(KAFDocument.Layer layer, Annotation ann) {
        return this.layers.get((Object)layer).get(DEFAULT_GROUP).indexOf(ann);
    }

    void addSentToPara(Integer sent, Integer para) {
        Set<Integer> paraSents = this.paraSentIndex.get(para);
        if (paraSents == null) {
            paraSents = new HashSet<Integer>();
            this.paraSentIndex.put(para, paraSents);
        }
        paraSents.add(sent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationContainer)) {
            return false;
        }
        AnnotationContainer ac = (AnnotationContainer)o;
        return KAFDocument.Utils.areEquals(this.layers, ac.layers) && KAFDocument.Utils.areEquals(this.rawText, ac.rawText) && KAFDocument.Utils.areEquals(this.unknownLayers, ac.unknownLayers);
    }

    private static class Helper {
        private Helper() {
        }

        static void addToIndex(Annotation ann, KAFDocument.Layer layer, String groupID, Integer key, Map<KAFDocument.Layer, Map<String, Map<Integer, List<Annotation>>>> index) {
            if (key != null) {
                List<Annotation> annotations;
                Map<Integer, List<Annotation>> groupIndex;
                Map<String, Map<Integer, List<Annotation>>> layerIndex = index.get((Object)layer);
                if (layerIndex == null) {
                    layerIndex = new HashMap<String, Map<Integer, List<Annotation>>>();
                    index.put(layer, layerIndex);
                }
                if ((groupIndex = layerIndex.get(groupID)) == null) {
                    groupIndex = new HashMap<Integer, List<Annotation>>();
                    layerIndex.put(groupID, groupIndex);
                }
                if ((annotations = groupIndex.get(key)) == null) {
                    annotations = new ArrayList<Annotation>();
                    groupIndex.put(key, annotations);
                }
                annotations.add(ann);
            }
        }

        static void removeFromIndex(Annotation ann, KAFDocument.Layer layer, String groupID, Integer key, Map<KAFDocument.Layer, Map<String, Map<Integer, List<Annotation>>>> index) {
            List<Annotation> annotations;
            Map<Integer, List<Annotation>> groupIndex;
            Map<String, Map<Integer, List<Annotation>>> layerIndex;
            if (key != null && (layerIndex = index.get((Object)layer)) != null && (groupIndex = layerIndex.get(groupID)) != null && (annotations = groupIndex.get(key)) != null) {
                annotations.remove(ann);
            }
        }

        static void addAnnotation(Annotation ann, KAFDocument.Layer layer, String groupID, Integer position, Map<KAFDocument.Layer, Map<String, List<Annotation>>> layers) {
            List<Annotation> annotations;
            Map<String, List<Annotation>> layerGroups = layers.get((Object)layer);
            if (layerGroups == null) {
                layerGroups = new HashMap<String, List<Annotation>>();
                layers.put(layer, layerGroups);
            }
            if ((annotations = layerGroups.get(groupID)) == null) {
                annotations = new ArrayList<Annotation>();
                layerGroups.put(groupID, annotations);
            }
            if (position == null || position > annotations.size()) {
                annotations.add(ann);
            } else {
                annotations.add(position, ann);
            }
        }

        static List<Annotation> getIndexedAnnotations(KAFDocument.Layer layer, String groupID, Integer key, Map<KAFDocument.Layer, Map<String, Map<Integer, List<Annotation>>>> index) {
            Map<String, Map<Integer, List<Annotation>>> layerIndex = index.get((Object)layer);
            if (layerIndex == null) {
                return new ArrayList<Annotation>();
            }
            Map<Integer, List<Annotation>> groupIndex = layerIndex.get(groupID);
            if (groupIndex == null) {
                return new ArrayList<Annotation>();
            }
            ArrayList annotations = groupIndex.get(key);
            return annotations == null ? new ArrayList() : annotations;
        }

        static List<Integer> getIndexKeys(KAFDocument.Layer layer, String groupID, Map<KAFDocument.Layer, Map<String, Map<Integer, List<Annotation>>>> index) {
            Map<Integer, List<Annotation>> groupIndex;
            Map<String, Map<Integer, List<Annotation>>> layerIndex = index.get((Object)layer);
            if (layerIndex != null && (groupIndex = layerIndex.get(groupID)) != null) {
                ArrayList<Integer> keys = new ArrayList<Integer>(groupIndex.keySet());
                Collections.sort(keys);
                return keys;
            }
            return new ArrayList<Integer>();
        }

        static void addInvReference(Annotation src, Annotation ref, KAFDocument.Layer layer, Map<Annotation, Map<KAFDocument.Layer, List<Annotation>>> index) {
            List<Annotation> refAnnotations;
            Map<KAFDocument.Layer, List<Annotation>> annIndex = index.get(ref);
            if (annIndex == null) {
                annIndex = new HashMap<KAFDocument.Layer, List<Annotation>>();
                index.put(ref, annIndex);
            }
            if ((refAnnotations = annIndex.get((Object)layer)) == null) {
                refAnnotations = new ArrayList<Annotation>();
                annIndex.put(layer, refAnnotations);
            }
            refAnnotations.add(src);
        }

        static List<Annotation> getInvReferences(Annotation ann, KAFDocument.Layer layer, Map<Annotation, Map<KAFDocument.Layer, List<Annotation>>> index) {
            Map<KAFDocument.Layer, List<Annotation>> annIndex = index.get(ann);
            if (annIndex == null) {
                return new ArrayList<Annotation>();
            }
            ArrayList annotations = annIndex.get((Object)layer);
            return annotations == null ? new ArrayList() : annotations;
        }

        static List<Annotation> getInvReferences(Annotation ann, Map<Annotation, Map<KAFDocument.Layer, List<Annotation>>> index) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            Map<KAFDocument.Layer, List<Annotation>> annIndex = index.get(ann);
            if (annIndex == null) {
                return new ArrayList<Annotation>();
            }
            for (KAFDocument.Layer layer : annIndex.keySet()) {
                annotations.addAll((Collection<Annotation>)annIndex.get((Object)layer));
            }
            return annotations;
        }
    }
}

