/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Span;
import ixa.kaflib.Target;
import ixa.kaflib.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Coref
extends IdentifiableAnnotation {
    private String type;
    private List<Span<Term>> mentions;
    private List<ExternalRef> externalReferences;

    Coref(String id, List<Span<Term>> mentions) {
        super(id);
        if (mentions.size() < 1) {
            throw new IllegalStateException("Coreferences must contain at least one reference span");
        }
        if (mentions.get(0).size() < 1) {
            throw new IllegalStateException("Coreferences' reference's spans must contain at least one target");
        }
        this.mentions = mentions;
        this.externalReferences = new ArrayList<ExternalRef>();
    }

    Coref(Coref coref, HashMap<String, Term> terms) {
        super(coref.getId());
        String id = coref.getId();
        this.mentions = new ArrayList<Span<Term>>();
        for (Span<Term> span : coref.getSpans()) {
            List<Term> targets = span.getTargets();
            ArrayList<Term> copiedTargets = new ArrayList<Term>();
            for (Term term : targets) {
                Term copiedTerm = terms.get(term.getId());
                if (copiedTerm == null) {
                    throw new IllegalStateException("Term not found when copying " + id);
                }
                copiedTargets.add(copiedTerm);
            }
            if (span.hasHead()) {
                Term copiedHead = terms.get(span.getHead().getId());
                this.mentions.add(new Span<Term>(copiedTargets, copiedHead));
                continue;
            }
            this.mentions.add(new Span(copiedTargets));
        }
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<ExternalRef> getExternalRefs() {
        return this.externalReferences;
    }

    public void addExternalRef(ExternalRef externalRef) {
        this.externalReferences.add(externalRef);
    }

    public void addExternalRefs(List<ExternalRef> externalRefs) {
        this.externalReferences.addAll(externalRefs);
    }

    public List<Term> getTerms() {
        return this.mentions.get(0).getTargets();
    }

    public void addTerm(Term term) {
        this.mentions.get(0).addTarget(term);
    }

    public void addTerm(Term term, boolean isHead) {
        this.mentions.get(0).addTarget(term, isHead);
    }

    public List<Span<Term>> getSpans() {
        return this.mentions;
    }

    public void addSpan(Span<Term> span) {
        this.mentions.add(span);
    }

    public String getSpanStr(Span<Term> span) {
        String str = "";
        for (Term term : span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + term.getStr();
        }
        return str;
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Span<Term> span : this.getSpans()) {
            terms.addAll(span.getTargets());
        }
        referenced.put(KAFDocument.Layer.TERMS, terms);
        return referenced;
    }

    public List<List<Target>> getReferences() {
        ArrayList<List<Target>> list = new ArrayList<List<Target>>();
        for (Span<Term> span : this.mentions) {
            list.add(KAFDocument.span2TargetList(span));
        }
        return list;
    }

    public void addReference(List<Target> span) {
        this.mentions.add(KAFDocument.targetList2Span(span));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Coref)) {
            return false;
        }
        Coref ann = (Coref)o;
        return KAFDocument.Utils.areEquals(this.type, ann.type) && KAFDocument.Utils.areEquals(this.mentions, ann.mentions) && KAFDocument.Utils.areEquals(this.externalReferences, ann.externalReferences);
    }
}

