/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Relational;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Entity
extends IdentifiableAnnotation
implements Relational,
SentenceLevelAnnotation {
    private String type;
    private String source;
    private List<Span<Term>> references;
    private List<ExternalRef> externalReferences;

    Entity(String id, List<Span<Term>> references) {
        super(id);
        if (references.size() < 1) {
            throw new IllegalStateException("Entities must contain at least one reference span");
        }
        if (references.get(0).size() < 1) {
            throw new IllegalStateException("Entities' reference's spans must contain at least one target");
        }
        this.references = references;
        this.externalReferences = new ArrayList<ExternalRef>();
    }

    Entity(Entity entity, HashMap<String, Term> terms) {
        super(entity.getId());
        this.type = entity.type;
        String id = entity.getId();
        this.references = new ArrayList<Span<Term>>();
        for (Span<Term> span : entity.getSpans()) {
            List<Term> targets = span.getTargets();
            ArrayList<Term> copiedTargets = new ArrayList<Term>();
            for (Term term : targets) {
                Term copiedTerm = terms.get(term.getId());
                if (copiedTerm == null) {
                    throw new IllegalStateException("Term not found when copying " + id);
                }
                copiedTargets.add(copiedTerm);
            }
            if (span.hasHead()) {
                Term copiedHead = terms.get(span.getHead().getId());
                this.references.add(new Span<Term>(copiedTargets, copiedHead));
                continue;
            }
            this.references.add(new Span(copiedTargets));
        }
        this.externalReferences = new ArrayList<ExternalRef>();
        for (ExternalRef externalRef : entity.getExternalRefs()) {
            this.externalReferences.add(new ExternalRef(externalRef));
        }
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<Term> getTerms() {
        return this.references.get(0).getTargets();
    }

    public void addTerm(Term term) {
        this.references.get(0).addTarget(term);
    }

    public void addTerm(Term term, boolean isHead) {
        this.references.get(0).addTarget(term, isHead);
    }

    public List<Span<Term>> getSpans() {
        return this.references;
    }

    public void addSpan(Span<Term> span) {
        this.references.add(span);
    }

    public List<ExternalRef> getExternalRefs() {
        return this.externalReferences;
    }

    public void addExternalRef(ExternalRef externalRef) {
        this.externalReferences.add(externalRef);
    }

    public void addExternalRefs(List<ExternalRef> externalRefs) {
        this.externalReferences.addAll(externalRefs);
    }

    public String getSpanStr(Span<Term> span) {
        String str = "";
        for (Term term : span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + term.getStr();
        }
        return str;
    }

    @Override
    public String getStr() {
        return this.getSpanStr(this.getSpans().get(0));
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Span<Term> span : this.getSpans()) {
            terms.addAll(span.getTargets());
        }
        referenced.put(KAFDocument.Layer.TERMS, terms);
        return referenced;
    }

    @Override
    public Integer getSent() {
        return this.getSpans().get(0).getFirstTarget().getSent();
    }

    @Override
    public Integer getPara() {
        return this.getSpans().get(0).getFirstTarget().getPara();
    }

    public List<List<Term>> getReferences() {
        ArrayList<List<Term>> list = new ArrayList<List<Term>>();
        for (Span<Term> span : this.references) {
            list.add(span.getTargets());
        }
        return list;
    }

    public void addReference(List<Term> span) {
        this.references.add(KAFDocument.list2Span(span));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity ann = (Entity)o;
        return KAFDocument.Utils.areEquals(this.type, ann.type) && KAFDocument.Utils.areEquals(this.source, ann.source) && KAFDocument.Utils.areEquals(this.references, ann.references) && KAFDocument.Utils.areEquals(this.externalReferences, ann.externalReferences);
    }
}

