/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Factuality
extends IdentifiableAnnotation
implements SentenceLevelAnnotation {
    private Span<Term> span;
    private List<FactVal> factVals;

    Factuality(String id, Span<Term> span) {
        super(id);
        this.span = span;
        this.factVals = new ArrayList<FactVal>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Span<Term> getSpan() {
        return this.span;
    }

    public List<FactVal> getFactVals() {
        return this.factVals;
    }

    public void addFactVal(FactVal factVal) {
        this.factVals.add(factVal);
    }

    @Override
    public Integer getPara() {
        return this.span.getFirstTarget().getPara();
    }

    @Override
    public Integer getSent() {
        return this.span.getFirstTarget().getSent();
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> references = new HashMap<KAFDocument.Layer, List<Annotation>>();
        references.put(KAFDocument.Layer.TERMS, this.span.getTargets());
        return references;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Factuality)) {
            return false;
        }
        Factuality ann = (Factuality)o;
        return KAFDocument.Utils.areEquals(this.span, ann.span) && KAFDocument.Utils.areEquals(this.factVals, ann.factVals);
    }

    public String getSpanStr(Span<Term> span) {
        String str = "";
        for (Term term : span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + term.getStr();
        }
        return str;
    }

    public static class FactVal
    extends Annotation {
        private String value;
        private String resource;
        private String source;
        private Float confidence;

        FactVal(String value, String resource) {
            this.value = value;
            this.resource = resource;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public boolean hasSource() {
            return this.source != null;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public boolean hasConfidence() {
            return this.confidence != null;
        }

        public Float getConfidence() {
            return this.confidence;
        }

        public void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
            return new HashMap<KAFDocument.Layer, List<Annotation>>();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FactVal)) {
                return false;
            }
            FactVal ann = (FactVal)o;
            return KAFDocument.Utils.areEquals(this.value, ann.value) && KAFDocument.Utils.areEquals(this.resource, ann.resource) && KAFDocument.Utils.areEquals(this.source, ann.source) && KAFDocument.Utils.areEquals(this.confidence, ann.confidence);
        }
    }
}

