/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.KAFDocument;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class IdManager
implements Serializable {
    private Map<KAFDocument.AnnotationType, String> prefixes = new HashMap<KAFDocument.AnnotationType, String>();
    private static final String WF_PREFIX = "w";
    private static final String TERM_PREFIX = "t";
    private static final String MARK_PREFIX = "m";
    private static final String MW_PREFIX = "t.mw";
    private static final String COMPONENT_PREFIX = ".";
    private static final String CHUNK_PREFIX = "c";
    private static final String ENTITY_PREFIX = "e";
    private static final String COREF_PREFIX = "co";
    private static final String TIMEX3_PREFIX = "tx";
    private static final String TLINK_PREFIX = "tlink";
    private static final String PREDICATE_ANCHOR_PREFIX = "an";
    private static final String CLINK_PREFIX = "clink";
    private static final String LINKED_ENTITY_PREFIX = "le";
    private static final String PROPERTY_PREFIX = "p";
    private static final String CATEGORY_PREFIX = "c";
    private static final String OPINION_PREFIX = "o";
    private static final String RELATION_PREFIX = "r";
    private static final String PREDICATE_PREFIX = "pr";
    private static final String ROLE_PREFIX = "rl";
    private static final String TERMINAL_PREFIX = "ter";
    private static final String NONTERMINAL_PREFIX = "nter";
    private static final String EDGE_PREFIX = "tre";
    private static final String FACTUALITY_PREFIX = "f";
    private static final String STATEMENT_PREFIX = "a";
    private HashSet<String> ids;
    private Map<KAFDocument.AnnotationType, Integer> counters;
    private Map<KAFDocument.AnnotationType, Boolean> inconsistentId;

    IdManager() {
        this.prefixes.put(KAFDocument.AnnotationType.WF, WF_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.TERM, TERM_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.COMPONENT, COMPONENT_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.ENTITY, ENTITY_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.CHUNK, "c");
        this.prefixes.put(KAFDocument.AnnotationType.NON_TERMINAL, NONTERMINAL_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.TERMINAL, TERMINAL_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.EDGE, EDGE_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.COREF, COREF_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.OPINION, OPINION_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.CLINK, CLINK_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.TLINK, TLINK_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.PREDICATE_ANCHOR, PREDICATE_ANCHOR_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.PREDICATE, PREDICATE_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.ROLE, ROLE_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.TIMEX3, TIMEX3_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.MARK, MARK_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.LINKED_ENTITY, LINKED_ENTITY_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.PROPERTY, PROPERTY_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.CATEGORY, "c");
        this.prefixes.put(KAFDocument.AnnotationType.RELATION, RELATION_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.FACTUALITY, FACTUALITY_PREFIX);
        this.prefixes.put(KAFDocument.AnnotationType.STATEMENT, STATEMENT_PREFIX);
        this.ids = new HashSet();
        this.counters = new HashMap<KAFDocument.AnnotationType, Integer>();
        for (KAFDocument.AnnotationType ann : KAFDocument.AnnotationType.values()) {
            this.counters.put(ann, 0);
        }
        this.inconsistentId = new HashMap<KAFDocument.AnnotationType, Boolean>();
        for (KAFDocument.AnnotationType ann : KAFDocument.AnnotationType.values()) {
            this.inconsistentId.put(ann, false);
        }
    }

    Boolean idExists(String id) {
        return this.ids.contains(id);
    }

    private void insertId(String id) {
        this.ids.add(id);
    }

    private int extractCounterFromId(String id) {
        Matcher matcher = Pattern.compile("\\d+$").matcher(id);
        if (!matcher.find()) {
            throw new IllegalStateException("IdManager doesn't recognise the given id's (" + id + ") format.");
        }
        return Integer.valueOf(matcher.group(0));
    }

    String getNextId(KAFDocument.AnnotationType ann) {
        if (this.inconsistentId.get((Object)ann).booleanValue()) {
            throw new IllegalStateException("Inconsistent " + (Object)((Object)ann) + "IDs. Can't create new " + (Object)((Object)ann) + " IDs.");
        }
        Integer nextCount = this.counters.get((Object)ann) + 1;
        this.counters.put(ann, nextCount);
        String id = this.prefixes.get((Object)ann) + Integer.toString(nextCount);
        this.insertId(id);
        return id;
    }

    void updateCounter(KAFDocument.AnnotationType ann, String id) {
        this.insertId(id);
        try {
            Integer currentCounter = this.counters.get((Object)ann);
            Integer newCounter = this.extractCounterFromId(id);
            if (currentCounter < newCounter) {
                this.counters.put(ann, newCounter);
            }
        }
        catch (IllegalStateException e) {
            this.inconsistentId.put(ann, true);
        }
    }
}

