/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import ixa.kaflib.WF;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Mark
extends IdentifiableAnnotation
implements SentenceLevelAnnotation {
    private String source;
    private String type;
    private String lemma;
    private String pos;
    private String morphofeat;
    private String markcase;
    private Span<WF> span;
    private Term.Sentiment sentiment;
    private List<ExternalRef> externalReferences;

    Mark(String id, Span<WF> span) {
        super(id);
        this.span = span;
        this.externalReferences = new ArrayList<ExternalRef>();
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasLemma() {
        return this.lemma != null;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    public boolean hasPos() {
        return this.pos != null;
    }

    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public boolean hasMorphofeat() {
        return this.morphofeat != null;
    }

    public String getMorphofeat() {
        return this.morphofeat;
    }

    public void setMorphofeat(String morphofeat) {
        this.morphofeat = morphofeat;
    }

    public boolean hasCase() {
        return this.markcase != null;
    }

    public String getCase() {
        return this.markcase;
    }

    public void setCase(String markcase) {
        this.markcase = markcase;
    }

    public String getStr() {
        String str = "";
        for (WF wf : this.span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + wf.getForm();
        }
        return str;
    }

    public Span<WF> getSpan() {
        return this.span;
    }

    public void setSpan(Span<WF> span) {
        this.span = span;
    }

    public boolean hasSentiment() {
        return this.sentiment != null;
    }

    public Term.Sentiment getSentiment() {
        return this.sentiment;
    }

    public void setSentiment(Term.Sentiment sentiment) {
        this.sentiment = sentiment;
    }

    public List<ExternalRef> getExternalRefs() {
        return this.externalReferences;
    }

    public void addExternalRef(ExternalRef externalRef) {
        this.externalReferences.add(externalRef);
    }

    public void addExternalRefs(List<ExternalRef> externalRefs) {
        this.externalReferences.addAll(externalRefs);
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
        referenced.put(KAFDocument.Layer.TEXT, this.getSpan().getTargets());
        return referenced;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mark)) {
            return false;
        }
        Mark ann = (Mark)o;
        return KAFDocument.Utils.areEquals(this.source, ann.source) && KAFDocument.Utils.areEquals(this.type, ann.type) && KAFDocument.Utils.areEquals(this.lemma, ann.lemma) && KAFDocument.Utils.areEquals(this.pos, ann.pos) && KAFDocument.Utils.areEquals(this.morphofeat, ann.morphofeat) && KAFDocument.Utils.areEquals(this.markcase, ann.markcase) && KAFDocument.Utils.areEquals(this.span, ann.span) && KAFDocument.Utils.areEquals(this.externalReferences, ann.externalReferences);
    }

    @Override
    public Integer getSent() {
        return this.span.getFirstTarget().getSent();
    }

    @Override
    public Integer getPara() {
        return this.span.getFirstTarget().getPara();
    }
}

