/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NonTerminal
extends TreeNode
implements SentenceLevelAnnotation {
    private String label;
    private List<TreeNode> children;

    NonTerminal(String id, String label) {
        super(id, false, false);
        this.label = label;
        this.children = new ArrayList<TreeNode>();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void addChild(TreeNode tn) throws Exception {
        this.children.add(tn);
    }

    @Override
    public List<TreeNode> getChildren() {
        return this.children;
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
        ArrayList terms = new ArrayList();
        for (TreeNode node : this.children) {
            terms.addAll(node.getReferencedAnnotations().get((Object)KAFDocument.Layer.TERMS));
        }
        referenced.put(KAFDocument.Layer.TERMS, terms);
        return referenced;
    }

    @Override
    public Integer getSent() {
        return this.children.get(0).getSent();
    }

    @Override
    public Integer getPara() {
        return this.children.get(0).getPara();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonTerminal)) {
            return false;
        }
        NonTerminal ann = (NonTerminal)o;
        return KAFDocument.Utils.areEquals(this.label, ann.label) && KAFDocument.Utils.areEquals(this.children, ann.children);
    }
}

