/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.TLinkReferable;
import ixa.kaflib.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Predicate
extends IdentifiableAnnotation
implements SentenceLevelAnnotation,
TLinkReferable {
    private String uri;
    private float confidence;
    private Span<Term> span;
    private List<Role> roles;
    private List<ExternalRef> externalReferences;

    Predicate(String id, Span<Term> span) {
        super(id);
        this.span = span;
        this.roles = new ArrayList<Role>();
        this.confidence = -1.0f;
        this.externalReferences = new ArrayList<ExternalRef>();
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean hasConfidence() {
        return this.confidence != -1.0f;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public void setConfidence(float confidence) {
        this.confidence = confidence;
    }

    public Span<Term> getSpan() {
        return this.span;
    }

    public void setSpan(Span<Term> span) {
        this.span = span;
    }

    public List<Term> getTerms() {
        return this.span.getTargets();
    }

    public void addTerm(Term term) {
        this.span.addTarget(term);
    }

    public void addTerm(Term term, boolean isHead) {
        this.span.addTarget(term, isHead);
    }

    @Override
    public Integer getSent() {
        return this.span.getFirstTarget().getSent();
    }

    @Override
    public Integer getPara() {
        return this.span.getFirstTarget().getPara();
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.addAll(this.span.getTargets());
        referenced.put(KAFDocument.Layer.TERMS, terms);
        return referenced;
    }

    public String getStr() {
        String str = "";
        if (!this.span.isEmpty()) {
            Term target = this.span.getFirstTarget();
            str = str + target.getId() + " " + target.getStr() + " ";
        }
        str = str + ":";
        for (Role role : this.roles) {
            if (role.span.isEmpty()) continue;
            Term roleTarget = role.getSpan().getFirstTarget();
            str = str + " " + role.getSemRole() + "[" + roleTarget.getId() + " " + roleTarget.getStr() + "]";
        }
        return str;
    }

    public String getSpanStr() {
        String str = "";
        for (Term term : this.span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + term.getStr();
        }
        return str;
    }

    public List<ExternalRef> getExternalRefs() {
        return this.externalReferences;
    }

    public void addExternalRef(ExternalRef externalRef) {
        this.externalReferences.add(externalRef);
    }

    public void addExternalRefs(List<ExternalRef> externalRefs) {
        this.externalReferences.addAll(externalRefs);
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Predicate)) {
            return false;
        }
        Predicate ann = (Predicate)o;
        return KAFDocument.Utils.areEquals(this.uri, ann.uri) && KAFDocument.Utils.areEquals(Float.valueOf(this.confidence), Float.valueOf(ann.confidence)) && KAFDocument.Utils.areEquals(this.span, ann.span) && KAFDocument.Utils.areEquals(this.roles, ann.roles) && KAFDocument.Utils.areEquals(this.externalReferences, ann.externalReferences);
    }

    public static class Role
    extends IdentifiableAnnotation {
        private String semRole;
        private Span<Term> span;
        private List<ExternalRef> externalReferences;

        Role(String id, String semRole, Span span) {
            super(id);
            this.semRole = semRole;
            this.span = span;
            this.externalReferences = new ArrayList<ExternalRef>();
        }

        public String getSemRole() {
            return this.semRole;
        }

        public void setSemRole(String semRole) {
            this.semRole = semRole;
        }

        public Span<Term> getSpan() {
            return this.span;
        }

        public void setSpan(Span<Term> span) {
            this.span = span;
        }

        public List<Term> getTerms() {
            return this.span.getTargets();
        }

        public void addTerm(Term term) {
            this.span.addTarget(term);
        }

        public void addTerm(Term term, boolean isHead) {
            this.span.addTarget(term, isHead);
        }

        @Override
        Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
            HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
            ArrayList<Term> terms = new ArrayList<Term>();
            terms.addAll(this.span.getTargets());
            referenced.put(KAFDocument.Layer.TERMS, terms);
            return referenced;
        }

        public String getStr() {
            String str = "";
            for (Term term : this.span.getTargets()) {
                if (!str.isEmpty()) {
                    str = str + " ";
                }
                str = str + term.getStr();
            }
            return str;
        }

        public List<ExternalRef> getExternalRefs() {
            return this.externalReferences;
        }

        public void addExternalRef(ExternalRef externalRef) {
            this.externalReferences.add(externalRef);
        }

        public void addExternalRefs(List<ExternalRef> externalRefs) {
            this.externalReferences.addAll(externalRefs);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Role)) {
                return false;
            }
            Role ann = (Role)o;
            return KAFDocument.Utils.areEquals(this.semRole, ann.semRole) && KAFDocument.Utils.areEquals(this.span, ann.span) && KAFDocument.Utils.areEquals(this.externalReferences, ann.externalReferences);
        }
    }
}

