/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Predicate;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.Timex3;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PredicateAnchor
extends IdentifiableAnnotation
implements SentenceLevelAnnotation {
    private Timex3 anchorTime;
    private Timex3 beginPoint;
    private Timex3 endPoint;
    private Span<Predicate> span;

    public PredicateAnchor(String id, Timex3 anchorTime, Timex3 beginPoint, Timex3 endPoint, Span<Predicate> span) {
        super(id);
        this.anchorTime = anchorTime;
        this.beginPoint = beginPoint;
        this.endPoint = endPoint;
        this.span = span;
    }

    public Timex3 getAnchorTime() {
        return this.anchorTime;
    }

    public void setAnchorTime(Timex3 anchorTime) {
        this.anchorTime = anchorTime;
    }

    public Timex3 getBeginPoint() {
        return this.beginPoint;
    }

    public void setBeginPoint(Timex3 beginPoint) {
        this.beginPoint = beginPoint;
    }

    public Timex3 getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Timex3 endPoint) {
        this.endPoint = endPoint;
    }

    public Span<Predicate> getSpan() {
        return this.span;
    }

    public void setSpan(Span<Predicate> span) {
        this.span = span;
    }

    @Override
    public Integer getSent() {
        return this.span.getFirstTarget().getSent();
    }

    @Override
    public Integer getPara() {
        return this.span.getFirstTarget().getPara();
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> refs = new HashMap<KAFDocument.Layer, List<Annotation>>();
        if (this.span != null) {
            refs.put(KAFDocument.Layer.SRL, this.span.getTargets());
        }
        return refs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PredicateAnchor)) {
            return false;
        }
        PredicateAnchor ann = (PredicateAnchor)o;
        return KAFDocument.Utils.areEquals(this.anchorTime, ann.anchorTime) && KAFDocument.Utils.areEquals(this.beginPoint, ann.beginPoint) && KAFDocument.Utils.areEquals(this.endPoint, ann.endPoint) && KAFDocument.Utils.areEquals(this.span, ann.span);
    }
}

